/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.execution.dml.GeoShapeIndexer;
import io.crate.execution.dml.ValueIndexer;
import io.crate.expression.reference.doc.lucene.SourceParser;
import io.crate.geo.GeoJSONUtils;
import io.crate.metadata.ColumnIdent;
import io.crate.metadata.Reference;
import io.crate.metadata.RelationName;
import io.crate.types.DataType;
import io.crate.types.StorageSupport;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.runtime.SwitchBootstraps;
import java.nio.ByteBuffer;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.apache.lucene.util.RamUsageEstimator;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.ByteBufferStreamInput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.lucene.BytesRefs;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Point;
import org.locationtech.spatial4j.shape.Shape;

public class GeoShapeType
extends DataType<Map<String, Object>>
implements Streamer<Map<String, Object>> {
    public static final int ID = 14;
    public static final GeoShapeType INSTANCE = new GeoShapeType();
    private static final StorageSupport<Map<String, Object>> STORAGE = new StorageSupport<Map<String, Object>>(false, false, null){

        @Override
        public ValueIndexer<Map<String, Object>> valueIndexer(RelationName table, Reference ref, Function<ColumnIdent, Reference> getRef) {
            return new GeoShapeIndexer(ref);
        }

        @Override
        public Map<String, Object> decode(ColumnIdent column, SourceParser sourceParser, Version tableVersion, byte[] bytes) {
            Map<String, Object> map;
            ByteBufferStreamInput in = new ByteBufferStreamInput(ByteBuffer.wrap(bytes));
            try {
                in.setVersion(tableVersion);
                map = INSTANCE.streamer().readValueFrom(in);
            }
            catch (Throwable throwable) {
                try {
                    try {
                        ((StreamInput)in).close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException ee) {
                    throw new UncheckedIOException(ee);
                }
            }
            ((StreamInput)in).close();
            return map;
        }

        @Override
        public boolean retrieveFromStoredFields() {
            return true;
        }
    };

    private GeoShapeType() {
    }

    @Override
    public int id() {
        return 14;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.GEO_SHAPE;
    }

    @Override
    public String getName() {
        return "geo_shape";
    }

    @Override
    public Streamer<Map<String, Object>> streamer() {
        return this;
    }

    @Override
    public Map<String, Object> implicitCast(Object value) throws IllegalArgumentException, ClassCastException {
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return GeoJSONUtils.wkt2Map(BytesRefs.toString(value));
        }
        if (value instanceof Point) {
            Point point = (Point)value;
            return GeoJSONUtils.shape2Map((Shape)SpatialContext.GEO.getShapeFactory().pointXY(point.getX(), point.getY()));
        }
        if (value instanceof Shape) {
            Shape shape = (Shape)value;
            return GeoJSONUtils.shape2Map(shape);
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return GeoJSONUtils.sanitizeMap(map);
        }
        throw new ClassCastException("Can't cast '" + String.valueOf(value) + "' to " + this.getName());
    }

    @Override
    public Map<String, Object> sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            return GeoJSONUtils.sanitizeMap(map);
        }
        return GeoJSONUtils.shape2Map((Shape)value);
    }

    @Override
    public int compare(Map<String, Object> val1, Map<String, Object> val2) {
        return GeoJSONUtils.compare(val1, val2);
    }

    @Override
    public Map<String, Object> readValueFrom(StreamInput in) throws IOException {
        return in.readMap();
    }

    @Override
    public void writeValueTo(StreamOutput out, Map<String, Object> v) throws IOException {
        out.writeMap(v);
    }

    @Override
    public StorageSupport<Map<String, Object>> storageSupport() {
        return STORAGE;
    }

    private static long sizeOf(Object object) {
        Object object2 = object;
        Objects.requireNonNull(object2);
        Object object3 = object2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Map.class, Collection.class, double[][][][].class, double[][][].class, double[][].class}, (Object)object3, n)) {
            case 0 -> {
                Map map = (Map)object3;
                yield GeoShapeType.sizeOf(map);
            }
            case 1 -> {
                Collection collection = (Collection)object3;
                long bytes = RamUsageEstimator.shallowSizeOf((Object)collection);
                for (Object item : collection) {
                    bytes += GeoShapeType.sizeOf(item);
                }
                yield bytes;
            }
            case 2 -> {
                double[][][][] multiPolygon = (double[][][][])object3;
                long bytes = RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
                for (double[][][] polygon : multiPolygon) {
                    bytes += GeoShapeType.sizeOf(polygon);
                }
                yield bytes;
            }
            case 3 -> {
                double[][][] polygon = (double[][][])object3;
                long bytes = RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
                for (double[][] lineRing : polygon) {
                    bytes += GeoShapeType.sizeOf(lineRing);
                }
                yield bytes;
            }
            case 4 -> {
                double[][] lineRing = (double[][])object3;
                long bytes = RamUsageEstimator.NUM_BYTES_ARRAY_HEADER;
                for (double[] points : lineRing) {
                    bytes += RamUsageEstimator.sizeOf((double[])points);
                }
                yield bytes;
            }
            default -> RamUsageEstimator.sizeOfObject((Object)object);
        };
    }

    private static long sizeOf(Map<?, ?> map) {
        long bytes = RamUsageEstimator.shallowSizeOf(map);
        long entrySize = -1L;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entrySize == -1L) {
                entrySize = RamUsageEstimator.shallowSizeOf(entry);
            }
            bytes += entrySize;
            Object key = entry.getKey();
            bytes += RamUsageEstimator.sizeOfObject(key);
            Object value = entry.getValue();
            bytes += GeoShapeType.sizeOf(value);
        }
        return bytes;
    }

    @Override
    public long valueBytes(Map<String, Object> map) {
        if (map == null) {
            return RamUsageEstimator.NUM_BYTES_OBJECT_HEADER;
        }
        return RamUsageEstimator.alignObjectSize((long)GeoShapeType.sizeOf(map));
    }

    public static class Names {
        public static final String TREE_GEOHASH = "geohash";
        public static final String TREE_QUADTREE = "quadtree";
        public static final String TREE_LEGACY_QUADTREE = "legacyquadtree";
        public static final String TREE_BKD = "bkdtree";
    }
}

