/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.types.TimeTZParser;
import java.util.Objects;

public final class TimeTZ
implements Comparable<TimeTZ> {
    private final long microsFromMidnight;
    private final int secondsFromUTC;

    public TimeTZ(long microsFromMidnight, int secondsFromUTC) {
        this.microsFromMidnight = microsFromMidnight;
        this.secondsFromUTC = secondsFromUTC;
    }

    public long getMicrosFromMidnight() {
        return this.microsFromMidnight;
    }

    public int getSecondsFromUTC() {
        return this.secondsFromUTC;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeTZ timeTZ = (TimeTZ)o;
        return this.microsFromMidnight == timeTZ.microsFromMidnight && this.secondsFromUTC == timeTZ.secondsFromUTC;
    }

    public int hashCode() {
        return Objects.hash(this.microsFromMidnight, this.secondsFromUTC);
    }

    public String toString() {
        return TimeTZParser.formatTime(this);
    }

    @Override
    public int compareTo(TimeTZ that) {
        int micros = Long.compare(this.microsFromMidnight, that.microsFromMidnight);
        return 0 == micros ? Long.compare(this.secondsFromUTC, that.secondsFromUTC) : micros;
    }
}

