/*
 * Decompiled with CFR 0.152.
 */
package io.crate.types;

import io.crate.Streamer;
import io.crate.statistics.ColumnStatsSupport;
import io.crate.types.DataType;
import io.crate.types.FixedWidthType;
import io.crate.types.TimeTZ;
import io.crate.types.TimeTZParser;
import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;

public final class TimeTZType
extends DataType<TimeTZ>
implements FixedWidthType,
Streamer<TimeTZ> {
    public static final int ID = 20;
    public static final int TYPE_SIZE = 12;
    public static final String NAME = "time with time zone";
    public static final TimeTZType INSTANCE = new TimeTZType();

    @Override
    public int id() {
        return 20;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public DataType.Precedence precedence() {
        return DataType.Precedence.TIMETZ;
    }

    @Override
    public Streamer<TimeTZ> streamer() {
        return this;
    }

    @Override
    public int compare(TimeTZ val1, TimeTZ val2) {
        return val1.compareTo(val2);
    }

    @Override
    public TimeTZ readValueFrom(StreamInput in) throws IOException {
        if (in.readBoolean()) {
            return null;
        }
        return new TimeTZ(in.readLong(), in.readInt());
    }

    @Override
    public void writeValueTo(StreamOutput out, TimeTZ tz) throws IOException {
        out.writeBoolean(tz == null);
        if (tz != null) {
            out.writeLong(tz.getMicrosFromMidnight());
            out.writeInt(tz.getSecondsFromUTC());
        }
    }

    @Override
    public int fixedSize() {
        return 12;
    }

    @Override
    public TimeTZ implicitCast(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof TimeTZ) {
            TimeTZ timetz = (TimeTZ)value;
            return timetz;
        }
        if (value instanceof String) {
            String timetzStr = (String)value;
            try {
                return TimeTZParser.parse(timetzStr);
            }
            catch (IllegalArgumentException e0) {
                try {
                    return TimeTZParser.timeTZOf(TimeTZType.class.getSimpleName(), Long.parseLong(timetzStr));
                }
                catch (NumberFormatException e1) {
                    throw TimeTZParser.exceptionForInvalidLiteral(value);
                }
            }
        }
        throw TimeTZParser.exceptionForInvalidLiteral(value);
    }

    @Override
    public TimeTZ sanitizeValue(Object value) {
        if (value == null) {
            return null;
        }
        return (TimeTZ)value;
    }

    @Override
    public TimeTZ valueForInsert(TimeTZ value) {
        throw new UnsupportedOperationException(String.format(Locale.ENGLISH, "%s cannot be used in insert statements", TimeTZType.class.getSimpleName()));
    }

    @Override
    public long valueBytes(TimeTZ value) {
        return 12L;
    }

    @Override
    public ColumnStatsSupport<TimeTZ> columnStatsSupport() {
        return ColumnStatsSupport.singleValued(TimeTZ.class, this);
    }
}

