/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.joda.time.DateTimeZone;
import org.joda.time.format.ISODateTimeFormat;

public final class Build {
    public static final Build CURRENT;
    private final String hash;
    private final String hashShort;
    private final String timestamp;

    Build(String hash, String hashShort, String timestamp) {
        this.hash = hash;
        this.hashShort = hashShort;
        this.timestamp = timestamp;
    }

    public String hash() {
        return this.hash;
    }

    public String hashShort() {
        return this.hashShort;
    }

    public String timestamp() {
        return this.timestamp;
    }

    public static void writeBuildTo(Build build, StreamOutput out) throws IOException {
        out.writeString(build.hash());
        out.writeString(build.hashShort());
        out.writeString(build.timestamp());
    }

    public static Build readBuild(StreamInput in) throws IOException {
        return new Build(in.readString(), in.readString(), in.readString());
    }

    static {
        String hash = "NA";
        String hashShort = "NA";
        String timestamp = "NA";
        try (InputStream inputStream = Build.class.getResourceAsStream("/crate-build.properties");){
            Properties props = new Properties();
            if (inputStream != null) {
                props.load(inputStream);
            }
            hash = props.getProperty("git.commit.id.full", hash);
            hashShort = props.getProperty("git.commit.id.abbrev", hashShort);
            String gitTimestampRaw = props.getProperty("timestamp");
            if (gitTimestampRaw != null) {
                timestamp = ISODateTimeFormat.dateTimeNoMillis().withZone(DateTimeZone.UTC).print(Long.parseLong(gitTimestampRaw));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        CURRENT = new Build(hash, hashShort, timestamp);
    }
}

