/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.NotifyOnceListener;
import org.elasticsearch.common.CheckedConsumer;
import org.elasticsearch.common.util.concurrent.FutureUtils;

public final class StepListener<Response>
extends NotifyOnceListener<Response> {
    private final CompletableFuture<Response> delegate = new CompletableFuture();

    @Override
    protected void innerOnResponse(Response response) {
        this.delegate.complete(response);
    }

    @Override
    protected void innerOnFailure(Exception e) {
        this.delegate.completeExceptionally(e);
    }

    public void whenComplete(CheckedConsumer<Response, Exception> onResponse, Consumer<Exception> onFailure) {
        this.delegate.whenComplete((BiConsumer)ActionListener.wrap(onResponse, onFailure));
    }

    public Response result() {
        if (this.delegate.isDone() || this.delegate.isCompletedExceptionally()) {
            return FutureUtils.get(this.delegate, 0L, TimeUnit.NANOSECONDS);
        }
        throw new IllegalStateException("step is not completed yet");
    }
}

