/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.configuration;

import io.crate.common.unit.TimeValue;
import java.io.IOException;
import java.util.function.Predicate;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchTimeoutException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.configuration.ClearVotingConfigExclusionsRequest;
import org.elasticsearch.action.admin.cluster.configuration.ClearVotingConfigExclusionsResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.ClusterStateUpdateTask;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.coordination.CoordinationMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportClearVotingConfigExclusions
extends TransportMasterNodeAction<ClearVotingConfigExclusionsRequest, ClearVotingConfigExclusionsResponse> {
    public static final Action ACTION = new Action();

    @Inject
    public TransportClearVotingConfigExclusions(TransportService transportService, ClusterService clusterService, ThreadPool threadPool) {
        super(ACTION.name(), transportService, clusterService, threadPool, ClearVotingConfigExclusionsRequest::new);
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClearVotingConfigExclusionsResponse read(StreamInput in) throws IOException {
        return new ClearVotingConfigExclusionsResponse(in);
    }

    @Override
    protected void masterOperation(final ClearVotingConfigExclusionsRequest request, final ClusterState initialState, final ActionListener<ClearVotingConfigExclusionsResponse> listener) throws Exception {
        final long startTimeMillis = this.threadPool.relativeTimeInMillis();
        Predicate<ClusterState> allExclusionsRemoved = newState -> {
            for (CoordinationMetadata.VotingConfigExclusion tombstone : initialState.getVotingConfigExclusions()) {
                if (!newState.nodes().nodeExists(tombstone.getNodeId())) continue;
                return false;
            }
            return true;
        };
        if (request.getWaitForRemoval() && !allExclusionsRemoved.test(initialState)) {
            ClusterStateObserver clusterStateObserver = new ClusterStateObserver(initialState, this.clusterService.getClusterApplierService(), request.getTimeout(), this.logger);
            clusterStateObserver.waitForNextChange(new ClusterStateObserver.Listener(){
                final /* synthetic */ TransportClearVotingConfigExclusions this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void onNewClusterState(ClusterState state) {
                    this.this$0.submitClearVotingConfigExclusionsTask(request, startTimeMillis, listener);
                }

                @Override
                public void onClusterServiceClose() {
                    listener.onFailure(new ElasticsearchException("cluster service closed while waiting for removal of nodes " + String.valueOf(initialState.getVotingConfigExclusions()), new Object[0]));
                }

                @Override
                public void onTimeout(TimeValue timeout) {
                    listener.onFailure(new ElasticsearchTimeoutException("timed out waiting for removal of nodes; if nodes should not be removed, set waitForRemoval to false. " + String.valueOf(initialState.getVotingConfigExclusions()), new Object[0]));
                }
            }, allExclusionsRemoved);
        } else {
            this.submitClearVotingConfigExclusionsTask(request, startTimeMillis, listener);
        }
    }

    private void submitClearVotingConfigExclusionsTask(final ClearVotingConfigExclusionsRequest request, final long startTimeMillis, final ActionListener<ClearVotingConfigExclusionsResponse> listener) {
        this.clusterService.submitStateUpdateTask("clear-voting-config-exclusions", new ClusterStateUpdateTask(this, Priority.URGENT){
            final /* synthetic */ TransportClearVotingConfigExclusions this$0;
            {
                this.this$0 = this$0;
                super(priority);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                CoordinationMetadata newCoordinationMetadata = CoordinationMetadata.builder(currentState.coordinationMetadata()).clearVotingConfigExclusions().build();
                Metadata newMetadata = Metadata.builder(currentState.metadata()).coordinationMetadata(newCoordinationMetadata).build();
                return ClusterState.builder(currentState).metadata(newMetadata).build();
            }

            @Override
            public void onFailure(String source, Exception e) {
                listener.onFailure(e);
            }

            @Override
            public TimeValue timeout() {
                return TimeValue.timeValueMillis((long)(request.getTimeout().millis() + startTimeMillis - this.this$0.threadPool.relativeTimeInMillis()));
            }

            @Override
            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                listener.onResponse(new ClearVotingConfigExclusionsResponse());
            }
        });
    }

    @Override
    protected ClusterBlockException checkBlock(ClearVotingConfigExclusionsRequest request, ClusterState state) {
        return state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
    }

    public static class Action
    extends ActionType<ClearVotingConfigExclusionsResponse> {
        private static final String NAME = "cluster:admin/voting_config/clear_exclusions";

        private Action() {
            super(NAME);
        }
    }
}

