/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.restore;

import io.crate.analyze.SnapshotSettings;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.Version;
import org.elasticsearch.action.admin.cluster.snapshots.restore.TableOrPartition;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.MasterNodeRequest;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;

public class RestoreSnapshotRequest
extends MasterNodeRequest<RestoreSnapshotRequest> {
    private final String snapshot;
    private final String repository;
    private final IndicesOptions indicesOptions;
    private final Settings settings;
    private final boolean includeTables;
    private final boolean includeCustomMetadata;
    private final String[] customMetadataTypes;
    private final boolean includeGlobalSettings;
    private final String[] globalSettings;
    private final List<TableOrPartition> tablesToRestore;

    public RestoreSnapshotRequest(String repository, String snapshot, List<TableOrPartition> tablesToRestore, IndicesOptions indicesOptions, Settings settings, boolean includeTables, boolean includeCustomMetadata, Set<String> metadataTypes, boolean includeGlobalSettings, List<String> globalSettings) {
        this.repository = repository;
        this.snapshot = snapshot;
        this.tablesToRestore = tablesToRestore;
        this.indicesOptions = indicesOptions;
        this.settings = settings;
        this.includeTables = includeTables;
        this.includeCustomMetadata = includeCustomMetadata;
        this.customMetadataTypes = (String[])metadataTypes.toArray(String[]::new);
        this.includeGlobalSettings = includeGlobalSettings;
        this.globalSettings = (String[])globalSettings.toArray(String[]::new);
    }

    public String snapshot() {
        return this.snapshot;
    }

    public String repository() {
        return this.repository;
    }

    public List<TableOrPartition> tablesToRestore() {
        return this.tablesToRestore;
    }

    public IndicesOptions indicesOptions() {
        return this.indicesOptions;
    }

    public String tableRenamePattern() {
        return SnapshotSettings.TABLE_RENAME_PATTERN.get(this.settings);
    }

    public String tableRenameReplacement() {
        return SnapshotSettings.TABLE_RENAME_REPLACEMENT.get(this.settings);
    }

    public String schemaRenamePattern() {
        return SnapshotSettings.SCHEMA_RENAME_PATTERN.get(this.settings);
    }

    public String schemaRenameReplacement() {
        return SnapshotSettings.SCHEMA_RENAME_REPLACEMENT.get(this.settings);
    }

    public boolean waitForCompletion() {
        return SnapshotSettings.WAIT_FOR_COMPLETION.get(this.settings);
    }

    public Settings settings() {
        return this.settings;
    }

    public boolean includeTables() {
        return this.includeTables;
    }

    public boolean includeCustomMetadata() {
        return this.includeCustomMetadata;
    }

    public String[] customMetadataTypes() {
        return this.customMetadataTypes;
    }

    public boolean includeGlobalSettings() {
        return this.includeGlobalSettings;
    }

    public String[] globalSettings() {
        return this.globalSettings;
    }

    public RestoreSnapshotRequest(StreamInput in) throws IOException {
        super(in);
        this.snapshot = in.readString();
        this.repository = in.readString();
        Version version = in.getVersion();
        assert (version.onOrAfter(Version.V_5_10_0)) : "Rolling upgrade is only supported for 5.10 -> 6.0";
        if (version.before(Version.V_6_0_0)) {
            in.readStringArray();
        }
        this.indicesOptions = IndicesOptions.readIndicesOptions(in);
        if (version.before(Version.V_6_0_0)) {
            in.readString();
            in.readString();
            in.readBoolean();
            in.readBoolean();
            in.readBoolean();
        }
        this.settings = Settings.readSettingsFromStream(in);
        if (version.before(Version.V_6_0_0)) {
            Settings.readSettingsFromStream(in);
            in.readStringArray();
            in.readStringArray();
        }
        this.includeTables = in.readBoolean();
        this.includeCustomMetadata = in.readBoolean();
        this.customMetadataTypes = in.readStringArray();
        this.includeGlobalSettings = in.readBoolean();
        this.globalSettings = in.readStringArray();
        this.tablesToRestore = in.readList(TableOrPartition::new);
        if (version.before(Version.V_6_0_0)) {
            in.readString();
            in.readString();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeString(this.snapshot);
        out.writeString(this.repository);
        Version version = out.getVersion();
        assert (version.onOrAfter(Version.V_5_10_0)) : "Rolling upgrade is only supported for 5.10 -> 6.0";
        if (version.before(Version.V_6_0_0)) {
            out.writeStringArray(Strings.EMPTY_ARRAY);
        }
        this.indicesOptions.writeIndicesOptions(out);
        if (version.before(Version.V_6_0_0)) {
            out.writeString(this.tableRenamePattern());
            out.writeString(this.tableRenameReplacement());
            out.writeBoolean(this.waitForCompletion());
            out.writeBoolean(false);
            out.writeBoolean(this.includeTables);
        }
        Settings.writeSettingsToStream(out, this.settings);
        if (version.before(Version.V_6_0_0)) {
            Settings.writeSettingsToStream(out, Settings.EMPTY);
            out.writeStringArray(Strings.EMPTY_ARRAY);
            out.writeStringArray(Strings.EMPTY_ARRAY);
        }
        out.writeBoolean(this.includeTables);
        out.writeBoolean(this.includeCustomMetadata);
        out.writeStringArray(this.customMetadataTypes);
        out.writeBoolean(this.includeGlobalSettings);
        out.writeStringArray(this.globalSettings);
        out.writeCollection(this.tablesToRestore);
        if (version.before(Version.V_6_0_0)) {
            out.writeString(this.schemaRenamePattern());
            out.writeString(this.schemaRenameReplacement());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestoreSnapshotRequest that = (RestoreSnapshotRequest)o;
        return Objects.equals(this.snapshot, that.snapshot) && Objects.equals(this.repository, that.repository) && Objects.equals(this.indicesOptions, that.indicesOptions) && Objects.equals(this.settings, that.settings) && this.includeTables == that.includeTables && this.includeCustomMetadata == that.includeCustomMetadata && Arrays.equals(this.customMetadataTypes, that.customMetadataTypes) && this.includeGlobalSettings == that.includeGlobalSettings && Arrays.equals(this.globalSettings, that.globalSettings);
    }

    public int hashCode() {
        int result = Objects.hash(this.snapshot, this.repository, this.indicesOptions, this.settings, this.includeTables, this.includeCustomMetadata, this.includeGlobalSettings);
        result = 31 * result + Arrays.hashCode(this.customMetadataTypes);
        result = 31 * result + Arrays.hashCode(this.globalSettings);
        return result;
    }
}

