/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.snapshots.restore;

import java.io.IOException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreClusterStateListener;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotRequest;
import org.elasticsearch.action.admin.cluster.snapshots.restore.RestoreSnapshotResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.snapshots.RestoreService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportRestoreSnapshot
extends TransportMasterNodeAction<RestoreSnapshotRequest, RestoreSnapshotResponse> {
    public static final Action ACTION = new Action();
    private final RestoreService restoreService;

    @Inject
    public TransportRestoreSnapshot(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, RestoreService restoreService) {
        super(ACTION.name(), transportService, clusterService, threadPool, RestoreSnapshotRequest::new);
        this.restoreService = restoreService;
    }

    @Override
    protected String executor() {
        return "generic";
    }

    @Override
    protected RestoreSnapshotResponse read(StreamInput in) throws IOException {
        return new RestoreSnapshotResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(RestoreSnapshotRequest request, ClusterState state) {
        ClusterBlockException blockException = state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        if (blockException != null) {
            return blockException;
        }
        return state.blocks().globalBlockedException(ClusterBlockLevel.WRITE);
    }

    @Override
    protected void masterOperation(final RestoreSnapshotRequest request, ClusterState state, final ActionListener<RestoreSnapshotResponse> listener) {
        RestoreService.RestoreRequest restoreRequest = new RestoreService.RestoreRequest(request.repository(), request.snapshot(), request.indicesOptions(), request.settings(), request.masterNodeTimeout(), request.includeTables(), request.includeCustomMetadata(), request.customMetadataTypes(), request.includeGlobalSettings(), request.globalSettings());
        this.restoreService.restoreSnapshot(restoreRequest, request.tablesToRestore(), new ActionListener<RestoreService.RestoreCompletionResponse>(this){
            final /* synthetic */ TransportRestoreSnapshot this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResponse(RestoreService.RestoreCompletionResponse restoreCompletionResponse) {
                if (restoreCompletionResponse.getRestoreInfo() == null && request.waitForCompletion()) {
                    this.this$0.clusterService.addListener(new RestoreClusterStateListener(this.this$0.clusterService, restoreCompletionResponse, listener));
                } else {
                    listener.onResponse(new RestoreSnapshotResponse(restoreCompletionResponse.getRestoreInfo()));
                }
            }

            @Override
            public void onFailure(Exception t) {
                listener.onFailure(t);
            }
        });
    }

    public static class Action
    extends ActionType<RestoreSnapshotResponse> {
        private static final String NAME = "cluster:admin/snapshot/restore";

        private Action() {
            super(NAME);
        }
    }
}

