/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.forcemerge;

import io.crate.metadata.PartitionName;
import java.io.IOException;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.jetbrains.annotations.Nullable;

public class ForceMergeRequest
extends BroadcastRequest {
    private int maxNumSegments = -1;
    private boolean onlyExpungeDeletes = false;
    private boolean flush = true;
    private static final Version FORCE_MERGE_UUID_VERSION = Version.V_4_3_0;
    @Nullable
    private final String forceMergeUUID;

    public ForceMergeRequest(List<PartitionName> partitions) {
        super(partitions);
        this.forceMergeUUID = UUIDs.randomBase64UUID();
    }

    public int maxNumSegments() {
        return this.maxNumSegments;
    }

    public ForceMergeRequest maxNumSegments(int maxNumSegments) {
        this.maxNumSegments = maxNumSegments;
        return this;
    }

    public boolean onlyExpungeDeletes() {
        return this.onlyExpungeDeletes;
    }

    public ForceMergeRequest onlyExpungeDeletes(boolean onlyExpungeDeletes) {
        this.onlyExpungeDeletes = onlyExpungeDeletes;
        return this;
    }

    public boolean flush() {
        return this.flush;
    }

    public ForceMergeRequest flush(boolean flush) {
        this.flush = flush;
        return this;
    }

    @Nullable
    public String forceMergeUUID() {
        return this.forceMergeUUID;
    }

    public ForceMergeRequest(StreamInput in) throws IOException {
        super(in);
        this.maxNumSegments = in.readInt();
        this.onlyExpungeDeletes = in.readBoolean();
        this.flush = in.readBoolean();
        this.forceMergeUUID = in.getVersion().onOrAfter(FORCE_MERGE_UUID_VERSION) ? in.readOptionalString() : null;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeInt(this.maxNumSegments);
        out.writeBoolean(this.onlyExpungeDeletes);
        out.writeBoolean(this.flush);
        if (out.getVersion().onOrAfter(FORCE_MERGE_UUID_VERSION)) {
            out.writeOptionalString(this.forceMergeUUID);
        }
    }

    public String toString() {
        return "ForceMergeRequest{maxNumSegments=" + this.maxNumSegments + ", onlyExpungeDeletes=" + this.onlyExpungeDeletes + ", flush=" + this.flush + "}";
    }

    public static final class Defaults {
        public static final int MAX_NUM_SEGMENTS = -1;
        public static final boolean ONLY_EXPUNGE_DELETES = false;
        public static final boolean FLUSH = true;
    }
}

