/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.settings.put;

import java.io.IOException;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.MetadataUpdateSettingsService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportUpdateSettings
extends TransportMasterNodeAction<UpdateSettingsRequest, AcknowledgedResponse> {
    public static final Action ACTION = new Action();
    private final MetadataUpdateSettingsService updateSettingsService;

    @Inject
    public TransportUpdateSettings(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataUpdateSettingsService updateSettingsService) {
        super(ACTION.name(), transportService, clusterService, threadPool, UpdateSettingsRequest::new);
        this.updateSettingsService = updateSettingsService;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ClusterBlockException checkBlock(UpdateSettingsRequest request, ClusterState state) {
        ClusterBlockException globalBlock = state.blocks().globalBlockedException(ClusterBlockLevel.METADATA_WRITE);
        if (globalBlock != null) {
            return globalBlock;
        }
        Settings settings = request.settings().filter(k -> !k.startsWith("archived.*"));
        if (settings.size() == 1 && IndexMetadata.INDEX_BLOCKS_METADATA_SETTING.exists(settings) || IndexMetadata.INDEX_READ_ONLY_SETTING.exists(settings) || IndexMetadata.INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING.exists(settings)) {
            return null;
        }
        String[] indices = (String[])state.metadata().getIndices(request.partitions(), false, im -> im.getIndex().getName()).toArray(String[]::new);
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, indices);
    }

    @Override
    protected AcknowledgedResponse read(StreamInput in) throws IOException {
        return new AcknowledgedResponse(in);
    }

    @Override
    protected void masterOperation(final UpdateSettingsRequest request, ClusterState state, final ActionListener<AcknowledgedResponse> listener) {
        this.updateSettingsService.updateSettings(request, new ActionListener<ClusterStateUpdateResponse>(){
            final /* synthetic */ TransportUpdateSettings this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResponse(ClusterStateUpdateResponse response) {
                listener.onResponse(new AcknowledgedResponse(response.isAcknowledged()));
            }

            @Override
            public void onFailure(Exception t) {
                this.this$0.logger.debug(() -> new ParameterizedMessage("failed to update settings on partitions [{}]", request.partitions()), (Throwable)t);
                listener.onFailure(t);
            }
        });
    }

    public static class Action
    extends ActionType<AcknowledgedResponse> {
        private static final String NAME = "indices:admin/settings/update";

        private Action() {
            super(NAME);
        }
    }
}

