/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.settings.put;

import io.crate.metadata.PartitionName;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.broadcast.BroadcastRequest;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;

public class UpdateSettingsRequest
extends AcknowledgedRequest<UpdateSettingsRequest> {
    private final List<PartitionName> partitions;
    private Settings settings = Settings.EMPTY;

    public UpdateSettingsRequest(Settings settings, List<PartitionName> partitions) {
        this.partitions = partitions;
        this.settings = settings;
    }

    public Settings settings() {
        return this.settings;
    }

    public List<PartitionName> partitions() {
        return this.partitions;
    }

    public UpdateSettingsRequest(StreamInput in) throws IOException {
        super(in);
        this.partitions = in.getVersion().before(Version.V_6_0_0) ? BroadcastRequest.readPartitionNamesFromPre60(in) : in.readList(PartitionName::new);
        this.settings = Settings.readSettingsFromStream(in);
        if (in.getVersion().before(Version.V_5_10_0)) {
            in.readBoolean();
        }
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().before(Version.V_6_0_0)) {
            BroadcastRequest.writePartitionNamesToPre60(out, this.partitions);
        } else {
            out.writeCollection(this.partitions);
        }
        Settings.writeSettingsToStream(out, this.settings);
        if (out.getVersion().before(Version.V_5_10_0)) {
            out.writeBoolean(false);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateSettingsRequest that = (UpdateSettingsRequest)o;
        return this.masterNodeTimeout.equals((Object)that.masterNodeTimeout) && this.timeout.equals((Object)that.timeout) && Objects.equals(this.settings, that.settings) && Objects.equals(this.partitions, that.partitions);
    }

    public int hashCode() {
        return Objects.hash(this.masterNodeTimeout, this.timeout, this.settings, this.partitions);
    }
}

