/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.shrink;

import io.crate.execution.ddl.index.SwapAndDropIndexRequest;
import io.crate.execution.ddl.index.TransportSwapAndDropIndexName;
import io.crate.execution.ddl.tables.GCDanglingArtifactsRequest;
import io.crate.execution.ddl.tables.TransportGCDanglingArtifacts;
import io.crate.metadata.PartitionName;
import java.io.IOException;
import java.util.concurrent.CompletableFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.admin.indices.shrink.ResizeRequest;
import org.elasticsearch.action.admin.indices.shrink.ResizeResponse;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsRequest;
import org.elasticsearch.action.admin.indices.stats.IndicesStatsResponse;
import org.elasticsearch.action.support.master.TransportMasterNodeAction;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.block.ClusterBlockException;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.MetadataCreateIndexService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportResize
extends TransportMasterNodeAction<ResizeRequest, ResizeResponse> {
    public static final Action ACTION = new Action();
    private final MetadataCreateIndexService createIndexService;
    private final Client client;
    private final TransportSwapAndDropIndexName swapAndDropIndexAction;
    private final TransportGCDanglingArtifacts gcDanglingArtifactsAction;

    @Inject
    public TransportResize(TransportService transportService, ClusterService clusterService, ThreadPool threadPool, MetadataCreateIndexService createIndexService, TransportSwapAndDropIndexName swapAndDropIndexAction, TransportGCDanglingArtifacts gcDanglingArtifactsAction, Client client) {
        super(ACTION.name(), transportService, clusterService, threadPool, ResizeRequest::new);
        this.createIndexService = createIndexService;
        this.swapAndDropIndexAction = swapAndDropIndexAction;
        this.gcDanglingArtifactsAction = gcDanglingArtifactsAction;
        this.client = client;
    }

    @Override
    protected String executor() {
        return "same";
    }

    @Override
    protected ResizeResponse read(StreamInput in) throws IOException {
        return new ResizeResponse(in);
    }

    @Override
    protected ClusterBlockException checkBlock(ResizeRequest request, ClusterState state) {
        String[] indices = (String[])state.metadata().getIndices(request.table(), request.partitionValues(), false, idxMd -> idxMd.getIndex().getName()).toArray(String[]::new);
        return state.blocks().indicesBlockedException(ClusterBlockLevel.METADATA_WRITE, indices);
    }

    @Override
    protected void masterOperation(ResizeRequest request, ClusterState state, ActionListener<ResizeResponse> listener) {
        String sourceIndex = request.partitionValues().isEmpty() ? request.table().indexNameOrAlias() : new PartitionName(request.table(), request.partitionValues()).asIndexName();
        String resizedIndex = ".resized." + sourceIndex;
        ((CompletableFuture)((CompletableFuture)this.client.stats(new IndicesStatsRequest(new PartitionName(request.table(), request.partitionValues())).clear().docs(true)).thenCompose(statsResponse -> this.createIndexService.resizeIndex(request, (IndicesStatsResponse)statsResponse))).thenCompose(resizeResp -> {
            if (resizeResp.isAcknowledged() && resizeResp.isShardsAcknowledged()) {
                SwapAndDropIndexRequest req = new SwapAndDropIndexRequest(resizedIndex, sourceIndex);
                return this.swapAndDropIndexAction.execute(req).thenApply(ignored -> resizeResp);
            }
            return this.gcDanglingArtifactsAction.execute(GCDanglingArtifactsRequest.INSTANCE).handle((ignored, err) -> {
                throw new IllegalStateException("Resize operation wasn't acknowledged. Check shard allocation and retry", (Throwable)err);
            });
        })).whenComplete(listener);
    }

    public static class Action
    extends ActionType<ResizeResponse> {
        private static final String NAME = "indices:admin/resize";

        private Action() {
            super(NAME);
        }
    }
}

