/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.indices.stats;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.admin.indices.stats.IndexStats;
import org.elasticsearch.action.admin.indices.stats.ShardStats;
import org.elasticsearch.action.support.DefaultShardOperationFailedException;
import org.elasticsearch.action.support.broadcast.BroadcastResponse;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.index.Index;

public class IndicesStatsResponse
extends BroadcastResponse {
    private final ShardStats[] shards;
    private Map<String, IndexStats> indicesStats;

    IndicesStatsResponse(ShardStats[] shards, int totalShards, int successfulShards, int failedShards, List<DefaultShardOperationFailedException> shardFailures) {
        super(totalShards, successfulShards, failedShards, shardFailures);
        this.shards = shards;
    }

    public ShardStats[] getShards() {
        return this.shards;
    }

    public IndexStats getIndex(String index) {
        return this.getIndices().get(index);
    }

    public Map<String, IndexStats> getIndices() {
        if (this.indicesStats != null) {
            return this.indicesStats;
        }
        HashMap<String, IndexStats> indicesStats = new HashMap<String, IndexStats>();
        HashSet<Index> indices = new HashSet<Index>();
        for (ShardStats shard : this.shards) {
            indices.add(shard.getShardRouting().index());
        }
        for (Index index : indices) {
            ArrayList<ShardStats> shards = new ArrayList<ShardStats>();
            String indexName = index.getName();
            for (ShardStats shard : this.shards) {
                if (!shard.getShardRouting().getIndexName().equals(indexName)) continue;
                shards.add(shard);
            }
            indicesStats.put(indexName, new IndexStats(shards));
        }
        this.indicesStats = indicesStats;
        return indicesStats;
    }

    public IndicesStatsResponse(StreamInput in) throws IOException {
        super(in);
        this.shards = in.readArray(ShardStats::new, ShardStats[]::new);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeArray(this.shards);
    }
}

