/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support;

import io.crate.common.collections.RingBuffer;
import io.crate.common.exceptions.Exceptions;
import io.crate.common.unit.TimeValue;
import io.crate.exceptions.SQLExceptions;
import java.util.Iterator;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRunnable;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;

public abstract class RetryableAction<Response> {
    private static final Logger LOGGER = LogManager.getLogger(RetryableAction.class);
    private final Logger logger;
    private final AtomicBoolean isDone = new AtomicBoolean(false);
    private final ScheduledExecutorService scheduler;
    private final ActionListener<Response> finalListener;
    private final Iterator<TimeValue> delay;
    private final ActionRunnable<Response> runnable;
    private volatile ScheduledFuture<?> retryTask;

    public static <T> RetryableAction<T> of(ScheduledExecutorService scheduler, final Consumer<ActionListener<T>> command, Iterable<TimeValue> backoffPolicy, ActionListener<T> listener) {
        return new RetryableAction<T>(LOGGER, scheduler, backoffPolicy, listener){

            @Override
            public void tryAction(ActionListener<T> listener) {
                command.accept(listener);
            }
        };
    }

    public RetryableAction(Logger logger, ScheduledExecutorService scheduler, Iterable<TimeValue> backoffPolicy, ActionListener<Response> listener) {
        this.logger = logger;
        this.scheduler = scheduler;
        this.delay = backoffPolicy.iterator();
        this.finalListener = listener;
        this.runnable = new ActionRunnable<Response>(new RetryingListener()){

            @Override
            public void doRun() throws Exception {
                RetryableAction.this.retryTask = null;
                if (!RetryableAction.this.isDone.get()) {
                    RetryableAction.this.tryAction(this.listener);
                }
            }

            @Override
            public void onRejection(Exception e) {
                RetryableAction.this.retryTask = null;
                this.onFailure(e);
            }
        };
    }

    public void run() {
        this.runnable.run();
    }

    public void cancel(Exception e) {
        if (this.isDone.compareAndSet(false, true)) {
            ScheduledFuture<?> localRetryTask = this.retryTask;
            if (localRetryTask != null) {
                localRetryTask.cancel(false);
            }
            this.onFinished();
            this.finalListener.onFailure(e);
        }
    }

    public abstract void tryAction(ActionListener<Response> var1);

    public boolean shouldRetry(Throwable t) {
        EsRejectedExecutionException rejected;
        return t instanceof EsRejectedExecutionException && !(rejected = (EsRejectedExecutionException)t).isExecutorShutdown();
    }

    public void onFinished() {
    }

    private class RetryingListener
    implements ActionListener<Response> {
        private static final int MAX_EXCEPTIONS = 4;
        private RingBuffer<Exception> caughtExceptions;

        private RetryingListener() {
        }

        @Override
        public void onResponse(Response response) {
            if (RetryableAction.this.isDone.compareAndSet(false, true)) {
                RetryableAction.this.onFinished();
                RetryableAction.this.finalListener.onResponse(response);
            }
        }

        @Override
        public void onFailure(Exception e) {
            Throwable t = SQLExceptions.unwrap(e);
            if (RetryableAction.this.shouldRetry(t) && RetryableAction.this.delay.hasNext()) {
                TimeValue currentDelay = RetryableAction.this.delay.next();
                this.addException(e);
                if (!RetryableAction.this.isDone.get()) {
                    RetryableAction.this.logger.debug("Retrying action that failed in delay={} err={}", (Object)currentDelay, (Object)e);
                    try {
                        RetryableAction.this.retryTask = RetryableAction.this.scheduler.schedule(RetryableAction.this.runnable, currentDelay.millis(), TimeUnit.MILLISECONDS);
                    }
                    catch (EsRejectedExecutionException ree) {
                        this.onFinalFailure(ree);
                    }
                }
            } else {
                this.onFinalFailure(e);
            }
        }

        private void onFinalFailure(Exception e) {
            this.addException(e);
            if (RetryableAction.this.isDone.compareAndSet(false, true)) {
                RetryableAction.this.onFinished();
                RetryableAction.this.finalListener.onFailure((Exception)Exceptions.merge(this.caughtExceptions));
            }
        }

        private void addException(Exception e) {
            if (this.caughtExceptions == null) {
                this.caughtExceptions = new RingBuffer(4);
            }
            this.caughtExceptions.add((Object)e);
        }
    }
}

