/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.support.broadcast;

import io.crate.metadata.IndexName;
import io.crate.metadata.IndexParts;
import io.crate.metadata.PartitionName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.Version;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.transport.TransportRequest;

public class BroadcastRequest
extends TransportRequest {
    protected final List<PartitionName> partitions;

    protected BroadcastRequest(List<PartitionName> partitions) {
        this.partitions = partitions;
    }

    protected BroadcastRequest(PartitionName partition) {
        this(List.of(partition));
    }

    public BroadcastRequest(StreamInput in) throws IOException {
        super(in);
        this.partitions = BroadcastRequest.readPartitions(in);
    }

    public final List<PartitionName> partitions() {
        return this.partitions;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        if (out.getVersion().onOrAfter(Version.V_6_0_0)) {
            out.writeCollection(this.partitions);
        } else {
            BroadcastRequest.writePartitionNamesToPre60(out, this.partitions);
        }
    }

    private static List<PartitionName> readPartitions(StreamInput in) throws IOException {
        if (in.getVersion().onOrAfter(Version.V_6_0_0)) {
            return in.readList(PartitionName::new);
        }
        return BroadcastRequest.readPartitionNamesFromPre60(in);
    }

    public static List<PartitionName> readPartitionNamesFromPre60(StreamInput in) throws IOException {
        String[] indexes = in.readStringArray();
        ArrayList<PartitionName> partitions = new ArrayList<PartitionName>(indexes.length);
        IndicesOptions.readIndicesOptions(in);
        for (String index : indexes) {
            IndexParts indexParts = IndexName.decode(index);
            partitions.add(indexParts.toPartitionName());
        }
        return partitions;
    }

    public static void writePartitionNamesToPre60(StreamOutput out, List<PartitionName> partitions) throws IOException {
        ArrayList<String> indexes = new ArrayList<String>();
        for (PartitionName partition : partitions) {
            if (partition.values().isEmpty()) {
                indexes.add(partition.relationName().name());
                continue;
            }
            indexes.add(IndexName.encode(partition.relationName(), partition.ident()));
        }
        out.writeStringCollection(indexes);
        IndicesOptions.LENIENT_EXPAND_OPEN.writeIndicesOptions(out);
    }
}

