/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.coordination;

import io.crate.common.io.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.IncompatibleClusterStateVersionException;
import org.elasticsearch.cluster.coordination.ApplyCommitRequest;
import org.elasticsearch.cluster.coordination.PublishRequest;
import org.elasticsearch.cluster.coordination.PublishWithJoinResponse;
import org.elasticsearch.cluster.metadata.MetadataUpgradeService;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.compress.Compressor;
import org.elasticsearch.common.compress.CompressorFactory;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.transport.BytesTransportRequest;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class PublicationTransportHandler {
    private static final Logger LOGGER = LogManager.getLogger(PublicationTransportHandler.class);
    public static final String PUBLISH_STATE_ACTION_NAME = "internal:cluster/coordination/publish_state";
    public static final String COMMIT_STATE_ACTION_NAME = "internal:cluster/coordination/commit_state";
    private final TransportService transportService;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private final MetadataUpgradeService metadataUpgradeService;
    private final Function<PublishRequest, PublishWithJoinResponse> handlePublishRequest;
    private final AtomicReference<ClusterState> lastSeenClusterState = new AtomicReference();
    private final AtomicReference<PublishRequest> currentPublishRequestToSelf = new AtomicReference();
    private final AtomicLong fullClusterStateReceivedCount = new AtomicLong();
    private final AtomicLong incompatibleClusterStateDiffReceivedCount = new AtomicLong();
    private final AtomicLong compatibleClusterStateDiffReceivedCount = new AtomicLong();
    private final TransportRequestOptions stateRequestOptions = new TransportRequestOptions(null, TransportRequestOptions.Type.STATE);

    public PublicationTransportHandler(TransportService transportService, NamedWriteableRegistry namedWriteableRegistry, MetadataUpgradeService metadataUpgradeService, Function<PublishRequest, PublishWithJoinResponse> handlePublishRequest, BiConsumer<ApplyCommitRequest, ActionListener<Void>> handleApplyCommit) {
        this.transportService = transportService;
        this.namedWriteableRegistry = namedWriteableRegistry;
        this.metadataUpgradeService = metadataUpgradeService;
        this.handlePublishRequest = handlePublishRequest;
        transportService.registerRequestHandler(PUBLISH_STATE_ACTION_NAME, "generic", false, false, BytesTransportRequest::new, (request, channel) -> channel.sendResponse(this.handleIncomingPublishRequest((BytesTransportRequest)request)));
        transportService.registerRequestHandler(COMMIT_STATE_ACTION_NAME, "generic", false, false, ApplyCommitRequest::new, (request, channel) -> handleApplyCommit.accept((ApplyCommitRequest)request, this.transportCommitCallback(channel)));
    }

    private ActionListener<Void> transportCommitCallback(final TransportChannel channel) {
        return new ActionListener<Void>(){

            @Override
            public void onResponse(Void aVoid) {
                try {
                    channel.sendResponse(TransportResponse.Empty.INSTANCE);
                }
                catch (IOException e) {
                    LOGGER.debug("failed to send response on commit", (Throwable)e);
                }
            }

            @Override
            public void onFailure(Exception e) {
                try {
                    channel.sendResponse(e);
                }
                catch (IOException ie) {
                    e.addSuppressed(ie);
                    LOGGER.debug("failed to send response on commit", (Throwable)e);
                }
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PublishWithJoinResponse handleIncomingPublishRequest(BytesTransportRequest request) throws IOException {
        ClusterState incomingState;
        StreamInput in;
        block22: {
            Writeable tempState;
            Compressor compressor = CompressorFactory.compressor(request.bytes());
            in = request.bytes().streamInput();
            try {
                ClusterState incomingState2;
                if (compressor != null) {
                    in = new InputStreamStreamInput(compressor.threadLocalInputStream(in));
                }
                in = new NamedWriteableAwareStreamInput(in, this.namedWriteableRegistry);
                in.setVersion(request.version());
                if (!in.readBoolean()) break block22;
                try (StreamInput input = in;){
                    tempState = ClusterState.readFrom(input, this.transportService.getLocalNode());
                    incomingState2 = in.getVersion().before(Version.V_6_0_0) ? ClusterState.builder(tempState).metadata(this.metadataUpgradeService.upgradeMetadata(tempState.metadata())).build() : tempState;
                }
                catch (Exception e) {
                    LOGGER.warn("unexpected error while deserializing an incoming cluster state", (Throwable)e);
                    throw e;
                }
                this.fullClusterStateReceivedCount.incrementAndGet();
                LOGGER.debug("received full cluster state version [{}] with size [{}]", (Object)incomingState2.version(), (Object)request.bytes().length());
                PublishWithJoinResponse response = this.acceptState(incomingState2);
                this.lastSeenClusterState.set(incomingState2);
                tempState = response;
            }
            catch (Throwable throwable) {
                IOUtils.close((Closeable[])new Closeable[]{in});
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{in});
            return tempState;
        }
        ClusterState lastSeen = this.lastSeenClusterState.get();
        if (lastSeen == null) {
            LOGGER.debug("received diff for but don't have any local cluster state - requesting full state");
            this.incompatibleClusterStateDiffReceivedCount.incrementAndGet();
            throw new IncompatibleClusterStateVersionException("have no local cluster state");
        }
        try {
            Diff<ClusterState> diff;
            try (StreamInput input = in;){
                diff = ClusterState.readDiffFrom(input, lastSeen.nodes().getLocalNode());
            }
            ClusterState tempState = diff.apply(lastSeen);
            incomingState = in.getVersion().before(Version.V_6_0_0) ? ClusterState.builder(tempState).metadata(this.metadataUpgradeService.upgradeMetadata(tempState.metadata())).build() : tempState;
        }
        catch (IncompatibleClusterStateVersionException e) {
            this.incompatibleClusterStateDiffReceivedCount.incrementAndGet();
            throw e;
        }
        catch (Exception e) {
            LOGGER.warn("unexpected error while deserializing an incoming cluster state", (Throwable)e);
            throw e;
        }
        this.compatibleClusterStateDiffReceivedCount.incrementAndGet();
        LOGGER.debug("received diff cluster state version [{}] with uuid [{}], diff size [{}]", (Object)incomingState.version(), (Object)incomingState.stateUUID(), (Object)request.bytes().length());
        PublishWithJoinResponse response = this.acceptState(incomingState);
        this.lastSeenClusterState.compareAndSet(lastSeen, incomingState);
        PublishWithJoinResponse publishWithJoinResponse = response;
        IOUtils.close((Closeable[])new Closeable[]{in});
        return publishWithJoinResponse;
    }

    private PublishWithJoinResponse acceptState(ClusterState incomingState) {
        if (this.transportService.getLocalNode().equals(incomingState.nodes().getMasterNode())) {
            PublishRequest publishRequest = this.currentPublishRequestToSelf.get();
            if (publishRequest == null || !publishRequest.getAcceptedState().stateUUID().equals(incomingState.stateUUID())) {
                throw new IllegalStateException("publication to self failed for " + String.valueOf(publishRequest));
            }
            return this.handlePublishRequest.apply(publishRequest);
        }
        return this.handlePublishRequest.apply(new PublishRequest(incomingState));
    }

    public PublicationContext newPublicationContext(ClusterChangedEvent clusterChangedEvent) {
        PublicationContext publicationContext = new PublicationContext(clusterChangedEvent);
        publicationContext.buildDiffAndSerializeStates();
        return publicationContext;
    }

    private static BytesReference serializeFullClusterState(ClusterState clusterState, Version nodeVersion) throws IOException {
        BytesStreamOutput bStream = new BytesStreamOutput();
        try (OutputStreamStreamOutput stream = new OutputStreamStreamOutput(CompressorFactory.COMPRESSOR.threadLocalOutputStream(bStream));){
            stream.setVersion(nodeVersion);
            stream.writeBoolean(true);
            clusterState.writeTo(stream);
        }
        BytesReference serializedState = bStream.bytes();
        LOGGER.trace("serialized full cluster state version [{}] for node version [{}] with size [{}]", (Object)clusterState.version(), (Object)nodeVersion, (Object)serializedState.length());
        return serializedState;
    }

    private static BytesReference serializeDiffClusterState(Diff<ClusterState> diff, Version nodeVersion) throws IOException {
        BytesStreamOutput bStream = new BytesStreamOutput();
        try (OutputStreamStreamOutput stream = new OutputStreamStreamOutput(CompressorFactory.COMPRESSOR.threadLocalOutputStream(bStream));){
            stream.setVersion(nodeVersion);
            stream.writeBoolean(false);
            diff.writeTo(stream);
        }
        return bStream.bytes();
    }

    public class PublicationContext {
        private final DiscoveryNodes discoveryNodes;
        private final ClusterState newState;
        private final ClusterState previousState;
        private final boolean sendFullVersion;
        private final Map<Version, BytesReference> serializedStates = new HashMap<Version, BytesReference>();
        private final Map<Version, BytesReference> serializedDiffs = new HashMap<Version, BytesReference>();

        PublicationContext(ClusterChangedEvent clusterChangedEvent) {
            this.discoveryNodes = clusterChangedEvent.state().nodes();
            this.newState = clusterChangedEvent.state();
            this.previousState = clusterChangedEvent.previousState();
            this.sendFullVersion = this.previousState.blocks().disableStatePersistence();
        }

        void buildDiffAndSerializeStates() {
            Diff<ClusterState> diff = null;
            for (DiscoveryNode node : this.discoveryNodes) {
                try {
                    if (this.sendFullVersion || !this.previousState.nodes().nodeExists(node)) {
                        if (this.serializedStates.containsKey(node.getVersion())) continue;
                        this.serializedStates.put(node.getVersion(), PublicationTransportHandler.serializeFullClusterState(this.newState, node.getVersion()));
                        continue;
                    }
                    if (diff == null) {
                        diff = this.newState.diff(this.previousState);
                    }
                    if (this.serializedDiffs.containsKey(node.getVersion())) continue;
                    BytesReference serializedDiff = PublicationTransportHandler.serializeDiffClusterState(diff, node.getVersion());
                    this.serializedDiffs.put(node.getVersion(), serializedDiff);
                    LOGGER.trace("serialized cluster state diff for version [{}] in for node version [{}] with size [{}]", (Object)this.newState.version(), (Object)node.getVersion(), (Object)serializedDiff.length());
                }
                catch (IOException e) {
                    throw new ElasticsearchException("failed to serialize cluster state for publishing to node {}", (Throwable)e, node);
                }
            }
        }

        public void sendPublishRequest(DiscoveryNode destination, final PublishRequest publishRequest, final ActionListener<PublishWithJoinResponse> listener) {
            ActionListener<PublishWithJoinResponse> responseActionListener;
            assert (publishRequest.getAcceptedState() == this.newState) : "state got switched on us";
            if (destination.equals(this.discoveryNodes.getLocalNode())) {
                PublishRequest previousRequest = PublicationTransportHandler.this.currentPublishRequestToSelf.getAndSet(publishRequest);
                assert (previousRequest == null || previousRequest.getAcceptedState().term() < publishRequest.getAcceptedState().term());
                responseActionListener = new ActionListener<PublishWithJoinResponse>(){
                    final /* synthetic */ PublicationContext this$1;
                    {
                        this.this$1 = this$1;
                    }

                    @Override
                    public void onResponse(PublishWithJoinResponse publishWithJoinResponse) {
                        this.this$1.PublicationTransportHandler.this.currentPublishRequestToSelf.compareAndSet(publishRequest, null);
                        listener.onResponse(publishWithJoinResponse);
                    }

                    @Override
                    public void onFailure(Exception e) {
                        this.this$1.PublicationTransportHandler.this.currentPublishRequestToSelf.compareAndSet(publishRequest, null);
                        listener.onFailure(e);
                    }
                };
            } else {
                responseActionListener = listener;
            }
            if (this.sendFullVersion || !this.previousState.nodes().nodeExists(destination)) {
                LOGGER.trace("sending full cluster state version [{}] to [{}]", (Object)this.newState.version(), (Object)destination);
                this.sendFullClusterState(destination, responseActionListener);
            } else {
                LOGGER.trace("sending cluster state diff for version [{}] to [{}]", (Object)this.newState.version(), (Object)destination);
                this.sendClusterStateDiff(destination, responseActionListener);
            }
        }

        public void sendApplyCommit(DiscoveryNode destination, ApplyCommitRequest applyCommitRequest, ActionListener<TransportResponse.Empty> listener) {
            PublicationTransportHandler.this.transportService.sendRequest(destination, PublicationTransportHandler.COMMIT_STATE_ACTION_NAME, (TransportRequest)applyCommitRequest, PublicationTransportHandler.this.stateRequestOptions, new ActionListenerResponseHandler<TransportResponse.Empty>(PublicationTransportHandler.COMMIT_STATE_ACTION_NAME, listener, streamInput -> TransportResponse.Empty.INSTANCE, "generic"));
        }

        private void sendFullClusterState(DiscoveryNode destination, ActionListener<PublishWithJoinResponse> listener) {
            BytesReference bytes = this.serializedStates.get(destination.getVersion());
            if (bytes == null) {
                try {
                    bytes = PublicationTransportHandler.serializeFullClusterState(this.newState, destination.getVersion());
                    this.serializedStates.put(destination.getVersion(), bytes);
                }
                catch (Exception e) {
                    LOGGER.warn(() -> new ParameterizedMessage("failed to serialize cluster state before publishing it to node {}", (Object)destination), (Throwable)e);
                    listener.onFailure(e);
                    return;
                }
            }
            this.sendClusterState(destination, bytes, false, listener);
        }

        private void sendClusterStateDiff(DiscoveryNode destination, ActionListener<PublishWithJoinResponse> listener) {
            BytesReference bytes = this.serializedDiffs.get(destination.getVersion());
            assert (bytes != null) : "failed to find serialized diff for node " + String.valueOf(destination) + " of version [" + String.valueOf(destination.getVersion()) + "]";
            this.sendClusterState(destination, bytes, true, listener);
        }

        private void sendClusterState(DiscoveryNode destination, BytesReference bytes, boolean retryWithFullClusterStateOnFailure, final ActionListener<PublishWithJoinResponse> listener) {
            try {
                BytesTransportRequest request = new BytesTransportRequest(bytes, destination.getVersion());
                final Consumer<TransportException> transportExceptionHandler = exp -> {
                    if (retryWithFullClusterStateOnFailure && exp.unwrapCause() instanceof IncompatibleClusterStateVersionException) {
                        LOGGER.debug("resending full cluster state to node {} reason {}", (Object)destination, (Object)exp.getDetailedMessage());
                        this.sendFullClusterState(destination, listener);
                    } else {
                        LOGGER.debug(() -> new ParameterizedMessage("failed to send cluster state to {}", (Object)destination), (Throwable)exp);
                        listener.onFailure((Exception)exp);
                    }
                };
                TransportResponseHandler<PublishWithJoinResponse> responseHandler = new TransportResponseHandler<PublishWithJoinResponse>(){

                    @Override
                    public PublishWithJoinResponse read(StreamInput in) throws IOException {
                        return new PublishWithJoinResponse(in);
                    }

                    @Override
                    public void handleResponse(PublishWithJoinResponse response) {
                        listener.onResponse(response);
                    }

                    @Override
                    public void handleException(TransportException exp) {
                        transportExceptionHandler.accept(exp);
                    }

                    @Override
                    public String executor() {
                        return "generic";
                    }
                };
                PublicationTransportHandler.this.transportService.sendRequest(destination, PublicationTransportHandler.PUBLISH_STATE_ACTION_NAME, (TransportRequest)request, PublicationTransportHandler.this.stateRequestOptions, responseHandler);
            }
            catch (Exception e) {
                LOGGER.warn(() -> new ParameterizedMessage("error sending cluster state to {}", (Object)destination), (Throwable)e);
                listener.onFailure(e);
            }
        }
    }
}

