/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import io.crate.common.collections.MapBuilder;
import io.crate.execution.ddl.tables.MappingUtil;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.AbstractDiffable;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.metadata.AliasMetadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.compress.CompressedXContent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentParser;
import org.jetbrains.annotations.Nullable;

@Deprecated(since="6.0.0")
public class IndexTemplateMetadata
extends AbstractDiffable<IndexTemplateMetadata> {
    private final String name;
    @Nullable
    private final Integer version;
    private final List<String> patterns;
    private final Settings settings;
    private final CompressedXContent mapping;
    private final ImmutableOpenMap<String, AliasMetadata> aliases;

    public IndexTemplateMetadata(String name, Integer version, List<String> patterns, Settings settings, CompressedXContent mapping, ImmutableOpenMap<String, AliasMetadata> aliases) {
        if (patterns == null || patterns.isEmpty()) {
            throw new IllegalArgumentException("Index patterns must not be null or empty; got " + String.valueOf(patterns));
        }
        if (mapping == null) {
            throw new IllegalArgumentException("Template must have a mapping");
        }
        this.name = name;
        this.version = version;
        this.patterns = patterns;
        this.settings = settings;
        this.mapping = mapping;
        this.aliases = aliases;
    }

    public String name() {
        return this.name;
    }

    @Nullable
    public Integer version() {
        return this.version;
    }

    public List<String> patterns() {
        return this.patterns;
    }

    public Settings settings() {
        return this.settings;
    }

    public CompressedXContent mapping() {
        return this.mapping;
    }

    public ImmutableOpenMap<String, AliasMetadata> aliases() {
        return this.aliases;
    }

    public static Builder builder(String name) {
        return new Builder(name);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexTemplateMetadata that = (IndexTemplateMetadata)o;
        if (!this.mapping.equals(that.mapping)) {
            return false;
        }
        if (!this.name.equals(that.name)) {
            return false;
        }
        if (!this.settings.equals(that.settings)) {
            return false;
        }
        if (!this.patterns.equals(that.patterns)) {
            return false;
        }
        return Objects.equals(this.version, that.version);
    }

    public int hashCode() {
        int result = this.name.hashCode();
        result = 31 * result + Objects.hashCode(this.version);
        result = 31 * result + this.patterns.hashCode();
        result = 31 * result + this.settings.hashCode();
        result = 31 * result + this.mapping.hashCode();
        return result;
    }

    public static IndexTemplateMetadata readFrom(StreamInput in) throws IOException {
        int i;
        Builder builder = new Builder(in.readString());
        if (in.getVersion().before(Version.V_5_4_0)) {
            in.readInt();
        }
        builder.patterns(in.readList(StreamInput::readString));
        builder.settings(Settings.readSettingsFromStream(in));
        if (in.getVersion().onOrAfter(Version.V_5_2_0)) {
            builder.putMapping(CompressedXContent.readCompressedString(in));
        } else {
            int mappingsSize = in.readVInt();
            assert (mappingsSize <= 1) : "There was always a single `default` mapping";
            for (i = 0; i < mappingsSize; ++i) {
                in.readString();
                builder.putMapping(CompressedXContent.readCompressedString(in));
            }
        }
        int aliasesSize = in.readVInt();
        for (i = 0; i < aliasesSize; ++i) {
            AliasMetadata aliasMd = new AliasMetadata(in);
            builder.putAlias(aliasMd);
        }
        builder.version(in.readOptionalVInt());
        return builder.build();
    }

    public static Diff<IndexTemplateMetadata> readDiffFrom(StreamInput in) throws IOException {
        return IndexTemplateMetadata.readDiffFrom(IndexTemplateMetadata::readFrom, in);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        if (out.getVersion().before(Version.V_5_4_0)) {
            out.writeInt(1);
        }
        out.writeStringCollection(this.patterns);
        Settings.writeSettingsToStream(out, this.settings);
        if (out.getVersion().onOrAfter(Version.V_5_2_0)) {
            this.mapping.writeTo(out);
        } else {
            out.writeVInt(1);
            out.writeString("default");
            this.mapping.writeTo(out);
        }
        out.writeVInt(this.aliases.size());
        for (ObjectCursor cursor : this.aliases.values()) {
            ((AliasMetadata)cursor.value).writeTo(out);
        }
        out.writeOptionalVInt(this.version);
    }

    public static class Builder {
        private static final Set<String> VALID_FIELDS = Set.of("template", "mappings", "settings", "index_patterns", "aliases", "version");
        private String name;
        private Integer version;
        private List<String> indexPatterns;
        private Settings settings = Settings.EMPTY;
        private CompressedXContent mapping;
        private final ImmutableOpenMap.Builder<String, AliasMetadata> aliases;

        public Builder(String name) {
            this.name = name;
            this.aliases = ImmutableOpenMap.builder();
        }

        public Builder(IndexTemplateMetadata indexTemplateMetadata) {
            this.name = indexTemplateMetadata.name();
            this.version(indexTemplateMetadata.version());
            this.patterns(indexTemplateMetadata.patterns());
            this.settings(indexTemplateMetadata.settings());
            this.mapping = indexTemplateMetadata.mapping();
            this.aliases = ImmutableOpenMap.builder(indexTemplateMetadata.aliases());
        }

        public Builder version(Integer version) {
            this.version = version;
            return this;
        }

        public Builder patterns(List<String> indexPatterns) {
            this.indexPatterns = indexPatterns;
            return this;
        }

        public Builder settings(Settings.Builder settings) {
            this.settings = settings.build();
            return this;
        }

        public Builder settings(Settings settings) {
            this.settings = settings;
            return this;
        }

        public Builder putMapping(CompressedXContent mappingSource) {
            if (mappingSource != null) {
                this.mapping = mappingSource;
            }
            return this;
        }

        public Builder putMapping(String mappingSource) {
            this.mapping = new CompressedXContent(mappingSource);
            return this;
        }

        public Builder putAlias(AliasMetadata aliasMetadata) {
            this.aliases.put(aliasMetadata.alias(), aliasMetadata);
            return this;
        }

        public Builder putAlias(AliasMetadata.Builder aliasMetadata) {
            this.aliases.put(aliasMetadata.alias(), aliasMetadata.build());
            return this;
        }

        public IndexTemplateMetadata build() {
            return new IndexTemplateMetadata(this.name, this.version, this.indexPatterns, this.settings, this.mapping, this.aliases.build());
        }

        public static IndexTemplateMetadata fromXContent(XContentParser parser, String templateName) throws IOException {
            XContentParser.Token token;
            Builder builder = new Builder(templateName);
            String currentFieldName = Builder.skipTemplateName(parser);
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                if (token == XContentParser.Token.FIELD_NAME) {
                    currentFieldName = parser.currentName();
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if ("settings".equals(currentFieldName)) {
                        Settings.Builder templateSettingsBuilder = Settings.builder();
                        templateSettingsBuilder.put(Settings.fromXContent(parser));
                        templateSettingsBuilder.normalizePrefix("index.");
                        builder.settings(templateSettingsBuilder.build());
                        continue;
                    }
                    if ("mappings".equals(currentFieldName)) {
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token == XContentParser.Token.FIELD_NAME) {
                                currentFieldName = parser.currentName();
                                continue;
                            }
                            if (token != XContentParser.Token.START_OBJECT) continue;
                            Map mappingSource = MapBuilder.newMapBuilder().put((Object)currentFieldName, (Object)parser.mapOrdered()).map();
                            builder.putMapping(new CompressedXContent(mappingSource));
                        }
                        continue;
                    }
                    if ("aliases".equals(currentFieldName)) {
                        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                            builder.putAlias(AliasMetadata.Builder.fromXContent(parser));
                        }
                        continue;
                    }
                    throw new ElasticsearchParseException("unknown key [{}] for index template", currentFieldName);
                }
                if (token == XContentParser.Token.START_ARRAY) {
                    if ("mappings".equals(currentFieldName)) {
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            Map mapping = parser.mapOrdered();
                            if (mapping.size() != 1) continue;
                            builder.putMapping(new CompressedXContent(mapping));
                        }
                        continue;
                    }
                    if (!"index_patterns".equals(currentFieldName)) continue;
                    ArrayList<String> index_patterns = new ArrayList<String>();
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        index_patterns.add(parser.text());
                    }
                    builder.patterns(index_patterns);
                    continue;
                }
                if (!token.isValue() || !"version".equals(currentFieldName)) continue;
                builder.version(parser.intValue());
            }
            return builder.build();
        }

        private static String skipTemplateName(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.nextToken();
            if (token != null && token == XContentParser.Token.START_OBJECT && (token = parser.nextToken()) == XContentParser.Token.FIELD_NAME) {
                String currentFieldName = parser.currentName();
                if (VALID_FIELDS.contains(currentFieldName)) {
                    return currentFieldName;
                }
                parser.nextToken();
            }
            return null;
        }

        public static IndexTemplateMetadata of(RelationMetadata.Table table) {
            assert (!table.partitionedBy().isEmpty()) : "table must be partitioned";
            RelationName relationName = table.name();
            String templateName = PartitionName.templateName(relationName.schema(), relationName.name());
            String templatePrefix = PartitionName.templatePrefix(relationName.schema(), relationName.name());
            return IndexTemplateMetadata.builder(templateName).version(null).patterns(List.of(templatePrefix)).putAlias(new AliasMetadata(relationName.indexNameOrAlias())).settings(table.settings()).putMapping(new CompressedXContent(Map.of("default", MappingUtil.createMapping(MappingUtil.AllocPosition.forTable(table), table.pkConstraintName(), table.columns(), table.primaryKeys(), table.checkConstraints(), table.partitionedBy(), table.columnPolicy(), table.routingColumn())))).build();
        }
    }
}

