/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import io.crate.metadata.PartitionName;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequest;
import org.elasticsearch.cluster.AckedClusterStateUpdateTask;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ack.AckedRequest;
import org.elasticsearch.cluster.ack.ClusterStateUpdateResponse;
import org.elasticsearch.cluster.block.ClusterBlock;
import org.elasticsearch.cluster.block.ClusterBlocks;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.ValidationException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.ShardLimitValidator;

public class MetadataUpdateSettingsService {
    private static final Logger LOGGER = LogManager.getLogger(MetadataUpdateSettingsService.class);
    private final ClusterService clusterService;
    private final AllocationService allocationService;
    private final IndexScopedSettings indexScopedSettings;
    private final IndicesService indicesService;
    private final ShardLimitValidator shardLimitValidator;

    @Inject
    public MetadataUpdateSettingsService(ClusterService clusterService, AllocationService allocationService, IndexScopedSettings indexScopedSettings, IndicesService indicesService, ShardLimitValidator shardLimitValidator) {
        this.clusterService = clusterService;
        this.allocationService = allocationService;
        this.indexScopedSettings = indexScopedSettings;
        this.indicesService = indicesService;
        this.shardLimitValidator = shardLimitValidator;
    }

    public void updateSettings(final UpdateSettingsRequest request, ActionListener<ClusterStateUpdateResponse> listener) {
        Settings normalizedSettings = Settings.builder().put(request.settings()).normalizePrefix("index.").build();
        Settings.Builder settingsForClosedIndices = Settings.builder();
        Settings.Builder settingsForOpenIndices = Settings.builder();
        final HashSet<String> skippedSettings = new HashSet<String>();
        this.indexScopedSettings.validate(normalizedSettings, false, true);
        for (String key : normalizedSettings.keySet()) {
            Setting<?> setting = this.indexScopedSettings.get(key);
            assert (setting != null) : "unknown setting: " + key + " hasValue: " + normalizedSettings.hasValue(key);
            settingsForClosedIndices.copy(key, normalizedSettings);
            if (setting.isDynamic()) {
                settingsForOpenIndices.copy(key, normalizedSettings);
                continue;
            }
            skippedSettings.add(key.replace("index.", ""));
        }
        final Settings closedSettings = settingsForClosedIndices.build();
        final Settings openSettings = settingsForOpenIndices.build();
        AckedClusterStateUpdateTask<ClusterStateUpdateResponse> updateTask = new AckedClusterStateUpdateTask<ClusterStateUpdateResponse>(this, Priority.URGENT, (AckedRequest)request, listener){
            final /* synthetic */ MetadataUpdateSettingsService this$0;
            {
                this.this$0 = this$0;
                super(priority, request2, listener);
            }

            @Override
            protected ClusterStateUpdateResponse newResponse(boolean acknowledged) {
                return new ClusterStateUpdateResponse(acknowledged);
            }

            @Override
            public ClusterState execute(ClusterState currentState) {
                return this.this$0.updateState(currentState, request.partitions(), skippedSettings, closedSettings, openSettings);
            }
        };
        this.clusterService.submitStateUpdateTask("update-settings", updateTask);
    }

    public ClusterState updateState(ClusterState currentState, List<PartitionName> partitions, Set<String> skippedSettings, Settings closedSettings, Settings openSettings) {
        RoutingTable.Builder routingTableBuilder = RoutingTable.builder(currentState.routingTable());
        Metadata.Builder metadataBuilder = Metadata.builder(currentState.metadata());
        List<IndexMetadata> indexes = currentState.metadata().getIndices(partitions, true, Function.identity());
        List<String> openIndices = indexes.stream().filter(im -> im.getState() == IndexMetadata.State.OPEN).map(im -> im.getIndex().getName()).toList();
        if (!skippedSettings.isEmpty() && !openIndices.isEmpty()) {
            throw new IllegalArgumentException(String.format(Locale.ROOT, "Can't update non dynamic settings [%s] for open indices %s", skippedSettings, openIndices));
        }
        if (IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.exists(openSettings)) {
            int updatedNumberOfReplicas = IndexMetadata.INDEX_NUMBER_OF_REPLICAS_SETTING.get(openSettings);
            int totalNewShards = indexes.stream().mapToInt(i -> MetadataUpdateSettingsService.getTotalNewShards(i, updatedNumberOfReplicas)).sum();
            Optional<String> optional = this.shardLimitValidator.checkShardLimit(totalNewShards, currentState);
            if (optional.isPresent()) {
                ValidationException ex = new ValidationException();
                ex.addValidationError(optional.get());
                throw ex;
            }
            routingTableBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, indexes);
            metadataBuilder.updateNumberOfReplicas(updatedNumberOfReplicas, indexes);
            LOGGER.info("updating number_of_replicas to [{}] for indices {}", (Object)updatedNumberOfReplicas, partitions);
        }
        ClusterBlocks.Builder blocks = ClusterBlocks.builder().blocks(currentState.blocks());
        MetadataUpdateSettingsService.maybeUpdateClusterBlock(indexes, blocks, IndexMetadata.INDEX_READ_ONLY_BLOCK, IndexMetadata.INDEX_READ_ONLY_SETTING, openSettings);
        MetadataUpdateSettingsService.maybeUpdateClusterBlock(indexes, blocks, IndexMetadata.INDEX_READ_ONLY_ALLOW_DELETE_BLOCK, IndexMetadata.INDEX_BLOCKS_READ_ONLY_ALLOW_DELETE_SETTING, openSettings);
        MetadataUpdateSettingsService.maybeUpdateClusterBlock(indexes, blocks, IndexMetadata.INDEX_METADATA_BLOCK, IndexMetadata.INDEX_BLOCKS_METADATA_SETTING, openSettings);
        MetadataUpdateSettingsService.maybeUpdateClusterBlock(indexes, blocks, IndexMetadata.INDEX_WRITE_BLOCK, IndexMetadata.INDEX_BLOCKS_WRITE_SETTING, openSettings);
        MetadataUpdateSettingsService.maybeUpdateClusterBlock(indexes, blocks, IndexMetadata.INDEX_READ_BLOCK, IndexMetadata.INDEX_BLOCKS_READ_SETTING, openSettings);
        for (IndexMetadata indexMetadata : indexes) {
            Settings.Builder updates = Settings.builder();
            Settings.Builder indexSettings = Settings.builder().put(indexMetadata.getSettings());
            Settings toUpdate = indexMetadata.getState() == IndexMetadata.State.OPEN ? openSettings : closedSettings;
            String indexName = indexMetadata.getIndex().getName();
            boolean updated = indexMetadata.getState() == IndexMetadata.State.OPEN ? this.indexScopedSettings.updateDynamicSettings(toUpdate, indexSettings, updates, indexName) : this.indexScopedSettings.updateSettings(toUpdate, indexSettings, updates, indexName);
            if (!updated) continue;
            Settings finalSettings = indexSettings.build();
            this.indexScopedSettings.validate(finalSettings.filter(k -> !this.indexScopedSettings.isPrivateSetting((String)k)), true);
            if (IndexSettings.same(indexMetadata.getSettings(), finalSettings)) continue;
            metadataBuilder.put(IndexMetadata.builder(indexMetadata).settings(finalSettings).incrementSettingsVersion());
        }
        ClusterState updatedState = ClusterState.builder(currentState).metadata(metadataBuilder).routingTable(routingTableBuilder.build()).blocks(blocks).build();
        updatedState = this.allocationService.reroute(updatedState, "settings update");
        try {
            for (IndexMetadata indexMetadata : indexes) {
                IndexMetadata updatedMetadata = updatedState.metadata().getIndexSafe(indexMetadata.getIndex());
                this.indicesService.verifyIndexMetadata(indexMetadata, updatedMetadata);
                if (indexMetadata.getState() != IndexMetadata.State.CLOSE) continue;
                this.indicesService.verifyIndexMetadata(updatedMetadata, updatedMetadata);
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
        return updatedState;
    }

    public static int getTotalNewShards(IndexMetadata indexMetadata, int updatedNumberOfReplicas) {
        int shardsInIndex = indexMetadata.getNumberOfShards();
        int oldNumberOfReplicas = indexMetadata.getNumberOfReplicas();
        int replicaIncrease = updatedNumberOfReplicas - oldNumberOfReplicas;
        return replicaIncrease * shardsInIndex;
    }

    private static void maybeUpdateClusterBlock(List<IndexMetadata> indexes, ClusterBlocks.Builder blocks, ClusterBlock block, Setting<Boolean> setting, Settings openSettings) {
        if (setting.exists(openSettings)) {
            boolean updateBlock = setting.get(openSettings);
            for (IndexMetadata im : indexes) {
                String index = im.getIndex().getName();
                if (updateBlock) {
                    blocks.addIndexBlock(index, block);
                    continue;
                }
                blocks.removeIndexBlock(index, block);
            }
        }
    }
}

