/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.metadata;

import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import io.crate.expression.udf.UserDefinedFunctionService;
import io.crate.expression.udf.UserDefinedFunctionsMetadata;
import io.crate.metadata.IndexName;
import io.crate.metadata.IndexParts;
import io.crate.metadata.NodeContext;
import io.crate.metadata.PartitionName;
import io.crate.metadata.RelationName;
import io.crate.metadata.doc.DocTableInfo;
import io.crate.metadata.doc.DocTableInfoFactory;
import io.crate.metadata.upgrade.IndexTemplateUpgrader;
import io.crate.metadata.upgrade.MetadataIndexUpgrader;
import io.crate.sql.tree.CheckConstraint;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.LongSupplier;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.IndexTemplateMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.RelationMetadata;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Settings;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class MetadataUpgradeService {
    private static final Logger LOGGER = LogManager.getLogger(MetadataUpgradeService.class);
    private final IndexScopedSettings indexScopedSettings;
    private final MetadataIndexUpgrader indexUpgrader;
    private final DocTableInfoFactory tableFactory;
    private final UserDefinedFunctionService userDefinedFunctionService;
    private final IndexTemplateUpgrader templateUpgrader;

    public MetadataUpgradeService(NodeContext nodeContext, IndexScopedSettings indexScopedSettings, UserDefinedFunctionService userDefinedFunctionService) {
        this.tableFactory = new DocTableInfoFactory(nodeContext);
        this.indexScopedSettings = indexScopedSettings;
        this.indexUpgrader = new MetadataIndexUpgrader();
        this.templateUpgrader = new IndexTemplateUpgrader();
        this.userDefinedFunctionService = userDefinedFunctionService;
    }

    public Metadata upgradeMetadata(Metadata metadata) {
        boolean changed = false;
        Metadata.Builder upgradedMetadata = Metadata.builder(metadata);
        HashMap upgradedIndexTemplateMetadata = new HashMap();
        if (MetadataUpgradeService.applyUpgrader(metadata.templates(), this::upgradeTemplates, upgradedMetadata::removeTemplate, (s, indexTemplateMetadata) -> {
            upgradedIndexTemplateMetadata.put(s, indexTemplateMetadata);
            upgradedMetadata.put((IndexTemplateMetadata)indexTemplateMetadata);
        })) {
            changed = true;
        }
        Iterator<IndexMetadata> iterator = metadata.iterator();
        while (iterator.hasNext()) {
            IndexMetadata indexMetadata;
            String indexName = (indexMetadata = iterator.next()).getIndex().getName();
            IndexMetadata newMetadata = this.upgradeIndexMetadata(indexMetadata, IndexName.isPartitioned(indexName) ? (IndexTemplateMetadata)upgradedIndexTemplateMetadata.get(PartitionName.templateName(indexName)) : null, Version.CURRENT.minimumIndexCompatibilityVersion(), (UserDefinedFunctionsMetadata)metadata.custom("user_defined_functions"));
            changed |= indexMetadata != newMetadata;
            upgradedMetadata.put(newMetadata, false);
        }
        return changed ? this.addOrUpgradeRelationMetadata(upgradedMetadata.build()) : this.addOrUpgradeRelationMetadata(metadata);
    }

    private static <Data> boolean applyUpgrader(ImmutableOpenMap<String, Data> existingData, UnaryOperator<Map<String, Data>> upgrader, Consumer<String> removeData, BiConsumer<String, Data> putData) {
        HashMap<String, Object> existingMap = new HashMap<String, Object>();
        for (ObjectObjectCursor<String, Data> objectObjectCursor : existingData) {
            existingMap.put((String)objectObjectCursor.key, objectObjectCursor.value);
        }
        Map upgradedCustoms = (Map)upgrader.apply(existingMap);
        if (!upgradedCustoms.equals(existingMap)) {
            existingMap.keySet().forEach(removeData);
            for (Map.Entry upgradedCustomEntry : upgradedCustoms.entrySet()) {
                putData.accept((String)upgradedCustomEntry.getKey(), upgradedCustomEntry.getValue());
            }
            return true;
        }
        return false;
    }

    public IndexMetadata upgradeIndexMetadata(IndexMetadata indexMetadata, @Nullable IndexTemplateMetadata indexTemplateMetadata, Version minimumIndexCompatibilityVersion, @Nullable UserDefinedFunctionsMetadata userDefinedFunctionsMetadata) {
        if (this.isUpgraded(indexMetadata)) {
            return indexMetadata;
        }
        if (userDefinedFunctionsMetadata != null) {
            this.userDefinedFunctionService.updateImplementations(userDefinedFunctionsMetadata.functionsMetadata());
        }
        this.checkSupportedVersion(indexMetadata, minimumIndexCompatibilityVersion);
        IndexMetadata newMetadata = indexMetadata;
        newMetadata = this.archiveBrokenIndexSettings(newMetadata);
        newMetadata = this.indexUpgrader.upgrade(newMetadata, indexTemplateMetadata);
        this.checkMappingsCompatibility(newMetadata);
        return this.markAsUpgraded(newMetadata);
    }

    /*
     * WARNING - void declaration
     */
    private Metadata addOrUpgradeRelationMetadata(Metadata metadata) {
        Metadata.Builder newMetadata = Metadata.builder(metadata);
        for (ObjectObjectCursor<String, IndexTemplateMetadata> objectObjectCursor : metadata.templates()) {
            IndexTemplateMetadata indexTemplateMetadata = (IndexTemplateMetadata)objectObjectCursor.value;
            RelationName relationName = IndexName.decode(indexTemplateMetadata.name()).toRelationName();
            RelationMetadata.Table table = (RelationMetadata.Table)newMetadata.getRelation(relationName);
            DocTableInfo docTable = this.tableFactory.create(indexTemplateMetadata, metadata);
            Settings settings = Settings.builder().put(indexTemplateMetadata.settings()).put(IndexMetadata.SETTING_INDEX_VERSION_CREATED.getKey(), docTable.versionCreated()).build();
            newMetadata.setTable(docTable.versionCreated().before(DocTableInfo.COLUMN_OID_VERSION) ? Metadata.Builder.NO_OID_COLUMN_OID_SUPPLIER : newMetadata.columnOidSupplier(), relationName, docTable.allReferences(), settings, docTable.clusteredBy(), docTable.columnPolicy(), docTable.pkConstraintName(), docTable.checkConstraints().stream().collect(Collectors.toMap(CheckConstraint::name, CheckConstraint::expressionStr)), docTable.primaryKey(), docTable.partitionedBy(), docTable.isClosed() ? IndexMetadata.State.CLOSE : IndexMetadata.State.OPEN, List.of(), table != null ? table.tableVersion() + 1L : docTable.tableVersion());
            newMetadata.removeTemplate(indexTemplateMetadata.name());
        }
        for (IndexMetadata indexMetadata : metadata) {
            void var4_9;
            RelationMetadata.Table table;
            LongSupplier columnOidSupplier;
            IndexMetadata indexMetadata2 = this.upgradeIndexMetadata(indexMetadata, null, Version.V_5_0_0, null);
            DocTableInfo docTable = this.tableFactory.create(indexMetadata2);
            String indexName = indexMetadata2.getIndex().getName();
            IndexParts indexParts = IndexName.decode(indexName);
            RelationName relationName = indexParts.toRelationName();
            Object relation = newMetadata.getRelation(relationName);
            LongSupplier longSupplier = columnOidSupplier = docTable.versionCreated().before(DocTableInfo.COLUMN_OID_VERSION) ? Metadata.Builder.NO_OID_COLUMN_OID_SUPPLIER : newMetadata.columnOidSupplier();
            if (relation == null) {
                newMetadata.setTable(columnOidSupplier, relationName, docTable.allReferences(), indexMetadata2.getSettings(), docTable.clusteredBy(), docTable.columnPolicy(), docTable.pkConstraintName(), docTable.checkConstraints().stream().collect(Collectors.toMap(CheckConstraint::name, CheckConstraint::expressionStr)), docTable.primaryKey(), docTable.partitionedBy(), indexMetadata2.getState(), List.of(indexMetadata2.getIndexUUID()), docTable.tableVersion());
                continue;
            }
            if (!(relation instanceof RelationMetadata.Table) || (table = (RelationMetadata.Table)relation).indexUUIDs().contains(indexMetadata2.getIndexUUID())) continue;
            if (indexParts.isPartitioned()) {
                IndexMetadata indexMetadata3 = IndexMetadata.builder(indexMetadata2).partitionValues(PartitionName.decodeIdent(indexParts.partitionIdent())).build();
                newMetadata.put(indexMetadata3, false);
            }
            newMetadata.addIndexUUIDs(table, List.of(var4_9.getIndexUUID()));
        }
        return newMetadata.build();
    }

    private Map<String, IndexTemplateMetadata> upgradeTemplates(Map<String, IndexTemplateMetadata> templates) {
        return this.templateUpgrader.upgrade(templates);
    }

    private boolean isUpgraded(IndexMetadata indexMetadata) {
        return indexMetadata.getCreationVersion().onOrAfter(Version.CURRENT) || indexMetadata.getUpgradedVersion().onOrAfter(Version.CURRENT);
    }

    private void checkSupportedVersion(IndexMetadata indexMetadata, Version minimumIndexCompatibilityVersion) {
        if (indexMetadata.getState() == IndexMetadata.State.OPEN && !MetadataUpgradeService.isSupportedVersion(indexMetadata, minimumIndexCompatibilityVersion)) {
            throw new IllegalStateException("The index [" + String.valueOf(indexMetadata.getIndex()) + "] was created with version [" + String.valueOf(indexMetadata.getCreationVersion()) + "] but the minimum compatible version is [" + String.valueOf(minimumIndexCompatibilityVersion) + "].It should be re-indexed in the previous major version of CrateDB before upgrading to " + String.valueOf(Version.CURRENT) + ".");
        }
    }

    private static boolean isSupportedVersion(IndexMetadata indexMetadata, Version minimumIndexCompatibilityVersion) {
        return indexMetadata.getCreationVersion().onOrAfter(minimumIndexCompatibilityVersion);
    }

    @VisibleForTesting
    void checkMappingsCompatibility(IndexMetadata indexMetadata) {
        try {
            this.tableFactory.create(indexMetadata);
        }
        catch (Exception ex) {
            throw new IllegalStateException("unable to upgrade the mappings for the index [" + String.valueOf(indexMetadata.getIndex()) + "]", ex);
        }
    }

    private IndexMetadata markAsUpgraded(IndexMetadata indexMetadata) {
        Settings settings = Settings.builder().put(indexMetadata.getSettings()).put("index.version.upgraded", Version.CURRENT).build();
        return IndexMetadata.builder(indexMetadata).settings(settings).build();
    }

    private IndexMetadata archiveBrokenIndexSettings(IndexMetadata indexMetadata) {
        Settings settings = indexMetadata.getSettings();
        Settings upgrade = this.indexScopedSettings.archiveUnknownOrInvalidSettings(settings, e -> LOGGER.warn("{} ignoring unknown index setting: [{}] with value [{}]; archiving", (Object)indexMetadata.getIndex(), e.getKey(), e.getValue()), (e, ex) -> LOGGER.warn(() -> new ParameterizedMessage("{} ignoring invalid index setting: [{}] with value [{}]; archiving", new Object[]{indexMetadata.getIndex(), e.getKey(), e.getValue()}), (Throwable)ex));
        if (upgrade != settings) {
            return IndexMetadata.builder(indexMetadata).settings(upgrade).build();
        }
        return indexMetadata;
    }
}

