/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing;

import java.util.Iterator;
import java.util.List;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.cluster.routing.ShardIterator;

public final class GroupShardsIterator<ShardIt extends ShardIterator>
implements Iterable<ShardIt> {
    private final List<ShardIt> iterators;

    public static <ShardIt extends ShardIterator> GroupShardsIterator<ShardIt> sortAndCreate(List<ShardIt> iterators) {
        CollectionUtil.timSort(iterators);
        return new GroupShardsIterator<ShardIt>(iterators);
    }

    private GroupShardsIterator(List<ShardIt> iterators) {
        this.iterators = iterators;
    }

    public int totalSize() {
        int size = 0;
        for (ShardIterator shard : this.iterators) {
            size += shard.size();
        }
        return size;
    }

    public int totalSizeWith1ForEmpty() {
        int size = 0;
        for (ShardIterator shard : this.iterators) {
            size += Math.max(1, shard.size());
        }
        return size;
    }

    public int size() {
        return this.iterators.size();
    }

    @Override
    public Iterator<ShardIt> iterator() {
        return this.iterators.iterator();
    }

    public ShardIt get(int index) {
        return (ShardIt)((ShardIterator)this.iterators.get(index));
    }
}

