/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.breaker;

import java.io.IOException;
import java.util.Locale;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.rest.RestStatus;

public class CircuitBreakingException
extends ElasticsearchException {
    private final long bytesWanted;
    private final long byteLimit;

    public CircuitBreakingException(String message) {
        super(message, new Object[0]);
        this.bytesWanted = 0L;
        this.byteLimit = 0L;
    }

    public CircuitBreakingException(StreamInput in) throws IOException {
        super(in);
        this.byteLimit = in.readLong();
        this.bytesWanted = in.readLong();
    }

    public CircuitBreakingException(long bytesAdded, long bytesUsed, long bytesLimit, String component) {
        super(String.format(Locale.ENGLISH, "Allocating %s for '%s' failed, breaker would use %s in total. Limit is %s. Either increase memory and limit, change the query or reduce concurrent query load", new ByteSizeValue(bytesAdded), component, new ByteSizeValue(bytesUsed), new ByteSizeValue(bytesLimit)), new Object[0]);
        this.bytesWanted = bytesUsed;
        this.byteLimit = bytesLimit;
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        out.writeLong(this.byteLimit);
        out.writeLong(this.bytesWanted);
    }

    public long getBytesWanted() {
        return this.bytesWanted;
    }

    public long getByteLimit() {
        return this.byteLimit;
    }

    @Override
    public RestStatus status() {
        return RestStatus.SERVICE_UNAVAILABLE;
    }
}

