/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo;

import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.util.SloppyMath;
import org.elasticsearch.common.unit.DistanceUnit;

public class GeoUtils {
    public static final String LATITUDE = "lat";
    public static final String LONGITUDE = "lon";
    public static final String GEOHASH = "geohash";
    public static final double EARTH_SEMI_MAJOR_AXIS = 6378137.0;
    public static final double EARTH_SEMI_MINOR_AXIS = 6356752.314245;
    public static final double EARTH_MEAN_RADIUS = 6371008.7714;
    public static final double EARTH_AXIS_RATIO = 0.9966471893352243;
    public static final double EARTH_EQUATOR = 4.007501668557849E7;
    public static final double EARTH_POLAR_DISTANCE = 1.9970326371122006E7;
    public static final double TOLERANCE = 1.0E-6;

    public static int quadTreeLevelsForPrecision(double meters) {
        int level;
        assert (meters >= 0.0);
        if (meters == 0.0) {
            return 50;
        }
        double ratio = 1.4983235946676121;
        double width = Math.sqrt(meters * meters / 2.244973594337675);
        long part = Math.round(Math.ceil(4.007501668557849E7 / width));
        return part <= 1L << (level = 64 - Long.numberOfLeadingZeros(part) - 1) ? level : level + 1;
    }

    public static int quadTreeLevelsForPrecision(String distance) {
        return GeoUtils.quadTreeLevelsForPrecision(DistanceUnit.METERS.parse(distance, DistanceUnit.DEFAULT));
    }

    public static int geoHashLevelsForPrecision(double meters) {
        int full;
        assert (meters >= 0.0);
        if (meters == 0.0) {
            return GeohashPrefixTree.getMaxLevelsPossible();
        }
        double ratio = 1.4983235946676121;
        double width = Math.sqrt(meters * meters / 2.244973594337675);
        double part = Math.ceil(4.007501668557849E7 / width);
        if (part == 1.0) {
            return 1;
        }
        int bits = (int)Math.round(Math.ceil(Math.log(part) / Math.log(2.0)));
        int left = bits - (full = bits / 5) * 5;
        int even = full + (left > 0 ? 1 : 0);
        int odd = full + (left > 3 ? 1 : 0);
        return even + odd;
    }

    public static int geoHashLevelsForPrecision(String distance) {
        return GeoUtils.geoHashLevelsForPrecision(DistanceUnit.METERS.parse(distance, DistanceUnit.DEFAULT));
    }

    public static double normalizeLon(double lon) {
        if (lon > 180.0 || lon <= -180.0) {
            lon = GeoUtils.centeredModulus(lon, 360.0);
        }
        return lon + 0.0;
    }

    public static double normalizeLat(double lat) {
        if (lat > 90.0 || lat < -90.0) {
            if ((lat = GeoUtils.centeredModulus(lat, 360.0)) < -90.0) {
                lat = -180.0 - lat;
            } else if (lat > 90.0) {
                lat = 180.0 - lat;
            }
        }
        return lat + 0.0;
    }

    private static double centeredModulus(double dividend, double divisor) {
        double rtn = dividend % divisor;
        if (rtn <= 0.0) {
            rtn += divisor;
        }
        if (rtn > divisor / 2.0) {
            rtn -= divisor;
        }
        return rtn;
    }

    public static double arcDistance(double lat1, double lon1, double lat2, double lon2) {
        return SloppyMath.haversinMeters((double)lat1, (double)lon1, (double)lat2, (double)lon2);
    }

    private GeoUtils() {
    }
}

