/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.geo.builders;

import java.util.Objects;
import org.elasticsearch.common.geo.GeoShapeType;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.spatial4j.shape.Rectangle;

public class EnvelopeBuilder
extends ShapeBuilder<Rectangle, EnvelopeBuilder> {
    public static final GeoShapeType TYPE = GeoShapeType.ENVELOPE;
    private final Coordinate topLeft;
    private final Coordinate bottomRight;

    public EnvelopeBuilder(Coordinate topLeft, Coordinate bottomRight) {
        Objects.requireNonNull(topLeft, "topLeft of envelope cannot be null");
        Objects.requireNonNull(bottomRight, "bottomRight of envelope cannot be null");
        if (Double.isNaN(topLeft.z) != Double.isNaN(bottomRight.z)) {
            throw new IllegalArgumentException("expected same number of dimensions for topLeft and bottomRight");
        }
        this.topLeft = topLeft;
        this.bottomRight = bottomRight;
    }

    @Override
    public Rectangle buildS4J() {
        return SHAPE_FACTORY.rect(this.topLeft.x, this.bottomRight.x, this.bottomRight.y, this.topLeft.y);
    }

    public org.apache.lucene.geo.Rectangle buildLucene() {
        return new org.apache.lucene.geo.Rectangle(this.bottomRight.y, this.topLeft.y, this.topLeft.x, this.bottomRight.x);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.topLeft, this.bottomRight);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EnvelopeBuilder other = (EnvelopeBuilder)obj;
        return Objects.equals(this.topLeft, other.topLeft) && Objects.equals(this.bottomRight, other.bottomRight);
    }
}

