/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.joda;

import io.crate.common.time.IsoLocale;
import io.crate.time.StrictISODateTimeFormat;
import java.io.IOException;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.Locale;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.joda.FormatDateTimeFormatter;
import org.joda.time.Chronology;
import org.joda.time.DateTime;
import org.joda.time.DateTimeField;
import org.joda.time.DateTimeFieldType;
import org.joda.time.DateTimeZone;
import org.joda.time.DurationField;
import org.joda.time.DurationFieldType;
import org.joda.time.ReadablePartial;
import org.joda.time.field.DividedDateTimeField;
import org.joda.time.field.OffsetDateTimeField;
import org.joda.time.field.ScaledDurationField;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;
import org.joda.time.format.DateTimeFormatterBuilder;
import org.joda.time.format.DateTimeParser;
import org.joda.time.format.DateTimeParserBucket;
import org.joda.time.format.DateTimePrinter;

public class Joda {
    public static final DurationFieldType QUARTERS = new DurationFieldType("quarters"){

        public DurationField getField(Chronology chronology) {
            return new ScaledDurationField(chronology.months(), QUARTERS, 3);
        }
    };
    public static final DateTimeFieldType QUARTER_OF_YEAR = new DateTimeFieldType("quarterOfYear"){

        public DurationFieldType getDurationType() {
            return QUARTERS;
        }

        public DurationFieldType getRangeDurationType() {
            return DurationFieldType.years();
        }

        public DateTimeField getField(Chronology chronology) {
            return new OffsetDateTimeField((DateTimeField)new DividedDateTimeField((DateTimeField)new OffsetDateTimeField(chronology.monthOfYear(), -1), QUARTER_OF_YEAR, 3), 1);
        }
    };

    public static FormatDateTimeFormatter forPattern(String input) {
        DateTimeFormatter formatter;
        if (Strings.hasLength(input)) {
            input = input.trim();
        }
        if (input == null || input.length() == 0) {
            throw new IllegalArgumentException("No date pattern provided");
        }
        if ("epoch_millis".equals(input)) {
            formatter = new DateTimeFormatterBuilder().append((DateTimePrinter)new EpochTimePrinter(true), (DateTimeParser)new EpochTimeParser(true)).toFormatter();
        } else {
            if ("strict_date_optional_time".equals(input)) {
                return new FormatDateTimeFormatter(input, StrictISODateTimeFormat.dateOptionalTimeParser().withZone(DateTimeZone.UTC), StrictISODateTimeFormat.dateTime().withZone(DateTimeZone.UTC), IsoLocale.ROOT);
            }
            if (Strings.hasLength(input) && input.contains("||")) {
                String[] formats = Strings.delimitedListToStringArray(input, "||");
                DateTimeParser[] parsers = new DateTimeParser[formats.length];
                if (formats.length == 1) {
                    formatter = Joda.forPattern(input).parser();
                } else {
                    DateTimeFormatter dateTimeFormatter = null;
                    for (int i = 0; i < formats.length; ++i) {
                        FormatDateTimeFormatter currentFormatter = Joda.forPattern(formats[i]);
                        DateTimeFormatter currentParser = currentFormatter.parser();
                        if (dateTimeFormatter == null) {
                            dateTimeFormatter = currentFormatter.printer();
                        }
                        parsers[i] = currentParser.getParser();
                    }
                    assert (dateTimeFormatter != null);
                    DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().append(dateTimeFormatter.withZone(DateTimeZone.UTC).getPrinter(), parsers);
                    formatter = builder.toFormatter();
                }
            } else {
                try {
                    formatter = DateTimeFormat.forPattern((String)input);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Invalid format: [" + input + "]: " + e.getMessage(), e);
                }
            }
        }
        return new FormatDateTimeFormatter(input, formatter.withZone(DateTimeZone.UTC), IsoLocale.ROOT);
    }

    public static FormatDateTimeFormatter getStrictStandardDateFormatter() {
        DateTimeFormatter shortFormatter = new DateTimeFormatterBuilder().appendFixedDecimal(DateTimeFieldType.year(), 4).appendLiteral('/').appendFixedDecimal(DateTimeFieldType.monthOfYear(), 2).appendLiteral('/').appendFixedDecimal(DateTimeFieldType.dayOfMonth(), 2).toFormatter().withZoneUTC();
        DateTimeFormatter longFormatter = new DateTimeFormatterBuilder().appendFixedDecimal(DateTimeFieldType.year(), 4).appendLiteral('/').appendFixedDecimal(DateTimeFieldType.monthOfYear(), 2).appendLiteral('/').appendFixedDecimal(DateTimeFieldType.dayOfMonth(), 2).appendLiteral(' ').appendFixedSignedDecimal(DateTimeFieldType.hourOfDay(), 2).appendLiteral(':').appendFixedSignedDecimal(DateTimeFieldType.minuteOfHour(), 2).appendLiteral(':').appendFixedSignedDecimal(DateTimeFieldType.secondOfMinute(), 2).toFormatter().withZoneUTC();
        DateTimeFormatterBuilder builder = new DateTimeFormatterBuilder().append(longFormatter.withZone(DateTimeZone.UTC).getPrinter(), new DateTimeParser[]{longFormatter.getParser(), shortFormatter.getParser(), new EpochTimeParser(true)});
        return new FormatDateTimeFormatter("yyyy/MM/dd HH:mm:ss||yyyy/MM/dd||epoch_millis", builder.toFormatter().withZone(DateTimeZone.UTC), Locale.ROOT);
    }

    public static class EpochTimePrinter
    implements DateTimePrinter {
        private boolean hasMilliSecondPrecision;

        public EpochTimePrinter(boolean hasMilliSecondPrecision) {
            this.hasMilliSecondPrecision = hasMilliSecondPrecision;
        }

        public int estimatePrintedLength() {
            return this.hasMilliSecondPrecision ? 19 : 16;
        }

        public void printTo(StringBuffer buf, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) {
            if (this.hasMilliSecondPrecision) {
                buf.append(instant - (long)displayOffset);
            } else {
                buf.append((instant - (long)displayOffset) / 1000L);
            }
        }

        public void printTo(Writer out, long instant, Chronology chrono, int displayOffset, DateTimeZone displayZone, Locale locale) throws IOException {
            if (this.hasMilliSecondPrecision) {
                out.write(String.valueOf(instant - (long)displayOffset));
            } else {
                out.append(String.valueOf((instant - (long)displayOffset) / 1000L));
            }
        }

        public void printTo(StringBuffer buf, ReadablePartial partial, Locale locale) {
            if (this.hasMilliSecondPrecision) {
                buf.append(String.valueOf(this.getDateTimeMillis(partial)));
            } else {
                buf.append(String.valueOf(this.getDateTimeMillis(partial) / 1000L));
            }
        }

        public void printTo(Writer out, ReadablePartial partial, Locale locale) throws IOException {
            if (this.hasMilliSecondPrecision) {
                out.append(String.valueOf(this.getDateTimeMillis(partial)));
            } else {
                out.append(String.valueOf(this.getDateTimeMillis(partial) / 1000L));
            }
        }

        private long getDateTimeMillis(ReadablePartial partial) {
            int year = partial.get(DateTimeFieldType.year());
            int monthOfYear = partial.get(DateTimeFieldType.monthOfYear());
            int dayOfMonth = partial.get(DateTimeFieldType.dayOfMonth());
            int hourOfDay = partial.get(DateTimeFieldType.hourOfDay());
            int minuteOfHour = partial.get(DateTimeFieldType.minuteOfHour());
            int secondOfMinute = partial.get(DateTimeFieldType.secondOfMinute());
            int millisOfSecond = partial.get(DateTimeFieldType.millisOfSecond());
            return partial.getChronology().getDateTimeMillis(year, monthOfYear, dayOfMonth, hourOfDay, minuteOfHour, secondOfMinute, millisOfSecond);
        }
    }

    public static class EpochTimeParser
    implements DateTimeParser {
        private final boolean hasMilliSecondPrecision;

        public EpochTimeParser(boolean hasMilliSecondPrecision) {
            this.hasMilliSecondPrecision = hasMilliSecondPrecision;
        }

        public int estimateParsedLength() {
            return this.hasMilliSecondPrecision ? 19 : 16;
        }

        public int parseInto(DateTimeParserBucket bucket, String text, int position) {
            boolean isTooLong;
            boolean isPositive = !text.startsWith("-");
            int firstDotIndex = text.indexOf(46);
            boolean bl = isTooLong = (firstDotIndex == -1 ? text.length() : firstDotIndex) > this.estimateParsedLength();
            if (bucket.getZone() != DateTimeZone.UTC) {
                String format = this.hasMilliSecondPrecision ? "epoch_millis" : "epoch_second";
                throw new IllegalArgumentException("time_zone must be UTC for format [" + format + "]");
            }
            if (isPositive && isTooLong) {
                return -1;
            }
            int factor = this.hasMilliSecondPrecision ? 1 : 1000;
            try {
                long millis = new BigDecimal(text).longValue() * (long)factor;
                DateTime dt = new DateTime(millis, DateTimeZone.UTC);
                bucket.saveField(DateTimeFieldType.year(), dt.getYear());
                bucket.saveField(DateTimeFieldType.monthOfYear(), dt.getMonthOfYear());
                bucket.saveField(DateTimeFieldType.dayOfMonth(), dt.getDayOfMonth());
                bucket.saveField(DateTimeFieldType.hourOfDay(), dt.getHourOfDay());
                bucket.saveField(DateTimeFieldType.minuteOfHour(), dt.getMinuteOfHour());
                bucket.saveField(DateTimeFieldType.secondOfMinute(), dt.getSecondOfMinute());
                bucket.saveField(DateTimeFieldType.millisOfSecond(), dt.getMillisOfSecond());
                bucket.setZone(DateTimeZone.UTC);
            }
            catch (Exception e) {
                return -1;
            }
            return text.length();
        }
    }
}

