/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.network;

import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import org.apache.lucene.document.InetAddressPoint;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.Constants;
import org.elasticsearch.common.network.NetworkAddress;

public abstract class NetworkUtils {
    static final boolean PREFER_V6 = Boolean.parseBoolean(System.getProperty("java.net.preferIPv6Addresses", "false"));
    public static final boolean SUPPORTS_V6;

    private NetworkUtils() {
    }

    static int sortKey(InetAddress address, boolean prefer_v6) {
        int key = address.getAddress().length;
        if (prefer_v6) {
            key = -key;
        }
        if (address.isAnyLocalAddress()) {
            key += 5;
        }
        if (address.isMulticastAddress()) {
            key += 4;
        }
        if (address.isLoopbackAddress()) {
            key += 3;
        }
        if (address.isLinkLocalAddress()) {
            key += 2;
        }
        if (address.isSiteLocalAddress()) {
            ++key;
        }
        return key;
    }

    public static String formatIPBytes(BytesRef value) {
        byte[] bytes = Arrays.copyOfRange(value.bytes, value.offset, value.offset + value.length);
        InetAddress inet = InetAddressPoint.decode((byte[])bytes);
        return NetworkAddress.format(inet);
    }

    public static void sortAddresses(List<InetAddress> list) {
        list.sort((left, right) -> {
            int cmp = Integer.compare(NetworkUtils.sortKey(left, PREFER_V6), NetworkUtils.sortKey(right, PREFER_V6));
            if (cmp == 0) {
                cmp = new BytesRef(left.getAddress()).compareTo(new BytesRef(right.getAddress()));
            }
            return cmp;
        });
    }

    static List<NetworkInterface> getInterfaces() throws SocketException {
        ArrayList<NetworkInterface> all = new ArrayList<NetworkInterface>();
        NetworkUtils.addAllInterfaces(all, Collections.list(NetworkInterface.getNetworkInterfaces()));
        Collections.sort(all, new Comparator<NetworkInterface>(){

            @Override
            public int compare(NetworkInterface left, NetworkInterface right) {
                return Integer.compare(left.getIndex(), right.getIndex());
            }
        });
        return all;
    }

    private static void addAllInterfaces(List<NetworkInterface> target, List<NetworkInterface> level) {
        if (!level.isEmpty()) {
            target.addAll(level);
            for (NetworkInterface intf : level) {
                NetworkUtils.addAllInterfaces(target, Collections.list(intf.getSubInterfaces()));
            }
        }
    }

    public static boolean defaultReuseAddress() {
        return !Constants.WINDOWS;
    }

    private static List<InetAddress> getAddresses(Predicate<InetAddress> predicate) throws SocketException {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        for (NetworkInterface intf : NetworkUtils.getInterfaces()) {
            if (!intf.isUp()) continue;
            Enumeration<InetAddress> inetAddresses = intf.getInetAddresses();
            while (inetAddresses.hasMoreElements()) {
                InetAddress address = inetAddresses.nextElement();
                if (!predicate.test(address)) continue;
                list.add(address);
            }
        }
        return list;
    }

    static List<InetAddress> getLoopbackAddresses() throws SocketException {
        List<InetAddress> list = NetworkUtils.getAddresses(InetAddress::isLoopbackAddress);
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No up-and-running loopback addresses found, got " + String.valueOf(NetworkUtils.getInterfaces()));
        }
        return list;
    }

    static List<InetAddress> getSiteLocalAddresses() throws SocketException {
        List<InetAddress> list = NetworkUtils.getAddresses(InetAddress::isSiteLocalAddress);
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No up-and-running site-local (private) addresses found, got " + String.valueOf(NetworkUtils.getInterfaces()));
        }
        return list;
    }

    static List<InetAddress> getGlobalAddresses() throws SocketException {
        List<InetAddress> list = NetworkUtils.getAddresses(x -> !x.isLoopbackAddress() && !x.isSiteLocalAddress() && !x.isLinkLocalAddress());
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No up-and-running global-scope (public) addresses found, got " + String.valueOf(NetworkUtils.getInterfaces()));
        }
        return list;
    }

    static List<InetAddress> getAllAddresses() throws SocketException {
        List<InetAddress> list = NetworkUtils.getAddresses(x -> true);
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No up-and-running addresses found, got " + String.valueOf(NetworkUtils.getInterfaces()));
        }
        return list;
    }

    static List<InetAddress> getAddressesForInterface(String name) throws SocketException {
        Optional<NetworkInterface> networkInterface = NetworkUtils.getInterfaces().stream().filter(netIf -> name.equals(netIf.getName())).findFirst();
        if (!networkInterface.isPresent()) {
            throw new IllegalArgumentException("No interface named '" + name + "' found, got " + String.valueOf(NetworkUtils.getInterfaces()));
        }
        if (!networkInterface.get().isUp()) {
            throw new IllegalArgumentException("Interface '" + name + "' is not up and running");
        }
        ArrayList<InetAddress> list = Collections.list(networkInterface.get().getInetAddresses());
        if (list.isEmpty()) {
            throw new IllegalArgumentException("Interface '" + name + "' has no internet addresses");
        }
        return list;
    }

    static List<InetAddress> filterIPV4(List<InetAddress> addresses) {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        for (InetAddress address : addresses) {
            if (!(address instanceof Inet4Address)) continue;
            list.add(address);
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No ipv4 addresses found in " + String.valueOf(addresses));
        }
        return list;
    }

    static List<InetAddress> filterIPV6(List<InetAddress> addresses) {
        ArrayList<InetAddress> list = new ArrayList<InetAddress>();
        for (InetAddress address : addresses) {
            if (!(address instanceof Inet6Address)) continue;
            list.add(address);
        }
        if (list.isEmpty()) {
            throw new IllegalArgumentException("No ipv6 addresses found in " + String.valueOf(addresses));
        }
        return list;
    }

    static {
        boolean v = false;
        try {
            block2: for (NetworkInterface nic : NetworkUtils.getInterfaces()) {
                for (InetAddress address : Collections.list(nic.getInetAddresses())) {
                    if (!(address instanceof Inet6Address)) continue;
                    v = true;
                    continue block2;
                }
            }
        }
        catch (SecurityException | SocketException misconfiguration) {
            v = true;
        }
        SUPPORTS_V6 = v;
    }
}

