/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import ch.randelshofer.fastdoubleparser.JavaDoubleParser;
import ch.randelshofer.fastdoubleparser.JavaFloatParser;
import io.crate.common.Booleans;
import io.crate.common.io.IOUtils;
import io.crate.common.unit.TimeValue;
import io.crate.server.xcontent.LoggingDeprecationHandler;
import io.crate.server.xcontent.XContentParserUtils;
import io.crate.sql.tree.GenericProperties;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.lang.invoke.CallSite;
import java.lang.runtime.SwitchBootstraps;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.lucene.util.SetOnce;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.DeprecationLogger;
import org.elasticsearch.common.settings.PropertyPlaceholder;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.jetbrains.annotations.Nullable;

public final class Settings {
    public static final Settings EMPTY = new Builder().build();
    public static final String MASKED_VALUE = "[xxxxx]";
    private final Map<String, Object> settings;
    private final SetOnce<Set<String>> firstLevelNames = new SetOnce();
    private final SetOnce<Set<String>> keys = new SetOnce();

    Settings(Map<String, Object> settings) {
        this.settings = Collections.unmodifiableSortedMap(new TreeMap<String, Object>(settings));
    }

    public Map<String, Object> getAsStructuredMap() {
        return this.getAsStructuredMap(Set.of());
    }

    public Map<String, Object> getAsStructuredMap(Set<String> maskedSettings) {
        HashMap<String, Object> map = new HashMap<String, Object>(2);
        for (Map.Entry<String, Object> entry : this.settings.entrySet()) {
            this.processSetting(map, "", entry.getKey(), entry.getValue(), maskedSettings);
        }
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (!(entry.getValue() instanceof Map)) continue;
            Map valMap = (Map)entry.getValue();
            entry.setValue(this.convertMapsToArrays(valMap));
        }
        return map;
    }

    private void processSetting(Map<String, Object> map, String prefix, String setting, Object value, Set<String> maskedSettings) {
        int prefixLength = setting.indexOf(46);
        if (prefixLength == -1) {
            String settingKey;
            Map innerMap = (Map)map.get(prefix + setting);
            if (innerMap != null) {
                for (Map.Entry entry : innerMap.entrySet()) {
                    map.put(prefix + setting + "." + (String)entry.getKey(), entry.getValue());
                }
            }
            Object settingValue = maskedSettings.contains(settingKey = prefix + setting) ? MASKED_VALUE : value;
            map.put(settingKey, settingValue);
        } else {
            String key = setting.substring(0, prefixLength);
            String rest = setting.substring(prefixLength + 1);
            Object existingValue = map.get(prefix + key);
            if (existingValue == null) {
                HashMap<String, Object> newMap = new HashMap<String, Object>(2);
                this.processSetting(newMap, "", rest, value, maskedSettings);
                map.put(key, newMap);
            } else if (existingValue instanceof Map) {
                Map innerMap = (Map)existingValue;
                this.processSetting(innerMap, "", rest, value, maskedSettings);
                map.put(key, innerMap);
            } else {
                this.processSetting(map, prefix + key + ".", rest, value, maskedSettings);
            }
        }
    }

    private Object convertMapsToArrays(Map<String, Object> map) {
        if (map.isEmpty()) {
            return map;
        }
        boolean isArray = true;
        int maxIndex = -1;
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            if (isArray) {
                try {
                    int index = Integer.parseInt(entry.getKey());
                    if (index >= 0) {
                        maxIndex = Math.max(maxIndex, index);
                    } else {
                        isArray = false;
                    }
                }
                catch (NumberFormatException ex) {
                    isArray = false;
                }
            }
            if (!(entry.getValue() instanceof Map)) continue;
            Map valMap = (Map)entry.getValue();
            entry.setValue(this.convertMapsToArrays(valMap));
        }
        if (isArray && maxIndex + 1 == map.size()) {
            ArrayList<Object> newValue = new ArrayList<Object>(maxIndex + 1);
            for (int i = 0; i <= maxIndex; ++i) {
                Object obj = map.get(Integer.toString(i));
                if (obj == null) {
                    return map;
                }
                newValue.add(obj);
            }
            return newValue;
        }
        return map;
    }

    public Settings getByPrefix(String prefix) {
        return new Settings(new FilteredMap(this.settings, k -> k.startsWith(prefix), prefix));
    }

    public Settings filter(Predicate<String> predicate) {
        return new Settings(new FilteredMap(this.settings, predicate, null));
    }

    public Settings getAsSettings(String setting) {
        return this.getByPrefix(setting + ".");
    }

    public String get(String setting) {
        return Settings.toString(this.settings.get(setting));
    }

    public String get(String setting, String defaultValue) {
        String retVal = this.get(setting);
        return retVal == null ? defaultValue : retVal;
    }

    public Float getAsFloat(String setting, Float defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Float.valueOf(JavaFloatParser.parseFloat((CharSequence)sValue));
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse float setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Double getAsDouble(String setting, Double defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return JavaDoubleParser.parseDouble((CharSequence)sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse double setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Integer getAsInt(String setting, Integer defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse int setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public Long getAsLong(String setting, Long defaultValue) {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(sValue);
        }
        catch (NumberFormatException e) {
            throw new SettingsException("Failed to parse long setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    public boolean hasValue(String key) {
        return this.settings.get(key) != null;
    }

    public Boolean getAsBoolean(String setting, Boolean defaultValue) {
        return Booleans.parseBoolean((String)this.get(setting), (Boolean)defaultValue);
    }

    public TimeValue getAsTime(String setting, TimeValue defaultValue) {
        return TimeValue.parseTimeValue((String)this.get(setting), (TimeValue)defaultValue, (String)setting);
    }

    public ByteSizeValue getAsBytesSize(String setting, ByteSizeValue defaultValue) throws SettingsException {
        return ByteSizeValue.parseBytesSizeValue(this.get(setting), defaultValue, setting);
    }

    public List<String> getAsList(String key) throws SettingsException {
        return this.getAsList(key, Collections.emptyList());
    }

    public List<String> getAsList(String key, List<String> defaultValue) throws SettingsException {
        return this.getAsList(key, defaultValue, true);
    }

    public List<String> getAsList(String key, List<String> defaultValue, Boolean commaDelimited) throws SettingsException {
        ArrayList<String> result = new ArrayList<String>();
        Object valueFromPrefix = this.settings.get(key);
        if (valueFromPrefix != null) {
            if (valueFromPrefix instanceof List) {
                return Collections.unmodifiableList((List)valueFromPrefix);
            }
            if (commaDelimited.booleanValue()) {
                String[] strings;
                for (String string : strings = Strings.splitStringByCommaToArray(this.get(key))) {
                    result.add(string.trim());
                }
            } else {
                result.add(this.get(key).trim());
            }
        }
        if (result.isEmpty()) {
            return defaultValue;
        }
        return Collections.unmodifiableList(result);
    }

    public Map<String, Settings> getGroups(String settingPrefix) throws SettingsException {
        return this.getGroups(settingPrefix, false);
    }

    public Map<String, Settings> getGroups(String settingPrefix, boolean ignoreNonGrouped) throws SettingsException {
        if (!Strings.hasLength((CharSequence)settingPrefix)) {
            throw new IllegalArgumentException("illegal setting prefix " + (String)settingPrefix);
        }
        if (((String)settingPrefix).charAt(((String)settingPrefix).length() - 1) != '.') {
            settingPrefix = (String)settingPrefix + ".";
        }
        return this.getGroupsInternal((String)settingPrefix, ignoreNonGrouped);
    }

    private Map<String, Settings> getGroupsInternal(String settingPrefix, boolean ignoreNonGrouped) throws SettingsException {
        Settings prefixSettings = this.getByPrefix(settingPrefix);
        HashMap<String, Settings> groups = new HashMap<String, Settings>();
        for (String groupName : prefixSettings.names()) {
            Settings groupSettings = prefixSettings.getByPrefix(groupName + ".");
            if (groupSettings.isEmpty()) {
                if (ignoreNonGrouped) continue;
                throw new SettingsException("Failed to get setting group for [" + settingPrefix + "] setting prefix and setting [" + settingPrefix + groupName + "] because of a missing '.'");
            }
            groups.put(groupName, groupSettings);
        }
        return Collections.unmodifiableMap(groups);
    }

    public Map<String, Settings> getAsGroups() throws SettingsException {
        return this.getAsGroups(false);
    }

    public Map<String, Settings> getAsGroups(boolean ignoreNonGrouped) throws SettingsException {
        return this.getGroupsInternal("", ignoreNonGrouped);
    }

    public Version getAsVersion(String setting, Version defaultVersion) throws SettingsException {
        String sValue = this.get(setting);
        if (sValue == null) {
            return defaultVersion;
        }
        try {
            return Version.fromId(Integer.parseInt(sValue));
        }
        catch (Exception e) {
            throw new SettingsException("Failed to parse version setting [" + setting + "] with value [" + sValue + "]", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> names() {
        SetOnce<Set<String>> setOnce = this.firstLevelNames;
        synchronized (setOnce) {
            if (this.firstLevelNames.get() == null) {
                Set names = this.settings.keySet().stream().map(k -> {
                    int i = k.indexOf(46);
                    return i < 0 ? k : k.substring(0, i);
                }).collect(Collectors.toSet());
                this.firstLevelNames.set(Collections.unmodifiableSet(names));
            }
        }
        return (Set)this.firstLevelNames.get();
    }

    public String toDelimitedString(char delimiter) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, Object> entry : this.settings.entrySet()) {
            sb.append(entry.getKey()).append("=").append(entry.getValue()).append(delimiter);
        }
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Settings that = (Settings)o;
        return Objects.equals(this.settings, that.settings);
    }

    public int hashCode() {
        return this.settings != null ? this.settings.hashCode() : 0;
    }

    public static Settings readSettingsFromStream(StreamInput in) throws IOException {
        Builder builder = new Builder();
        int numberOfSettings = in.readVInt();
        for (int i = 0; i < numberOfSettings; ++i) {
            String key = in.readString();
            Object value = in.readGenericValue();
            if (value == null) {
                builder.putNull(key);
                continue;
            }
            if (value instanceof List) {
                builder.putList(key, (List)value);
                continue;
            }
            builder.put(key, value.toString());
        }
        return builder.build();
    }

    public static void writeSettingsToStream(StreamOutput out, Settings settings) throws IOException {
        Set<Map.Entry<String, Object>> entries = settings.settings.entrySet();
        out.writeVInt(entries.size());
        for (Map.Entry<String, Object> entry : entries) {
            out.writeString(entry.getKey());
            out.writeGenericValue(entry.getValue());
        }
    }

    public static Builder builder() {
        return new Builder();
    }

    public XContentBuilder toXContent(XContentBuilder builder, boolean flat) throws IOException {
        if (flat) {
            for (Map.Entry<String, Object> entry : this.settings.entrySet()) {
                builder.field(entry.getKey(), entry.getValue());
            }
        } else {
            for (Map.Entry<String, Object> entry : this.getAsStructuredMap().entrySet()) {
                builder.field(entry.getKey(), entry.getValue());
            }
        }
        return builder;
    }

    public static Settings fromXContent(XContentParser parser) throws IOException {
        return Settings.fromXContent(parser, true, false);
    }

    private static Settings fromXContent(XContentParser parser, boolean allowNullValues, boolean validateEndOfStream) throws IOException {
        if (parser.currentToken() == null) {
            parser.nextToken();
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.currentToken(), parser);
        Builder innerBuilder = Settings.builder();
        StringBuilder currentKeyBuilder = new StringBuilder();
        Settings.fromXContent(parser, currentKeyBuilder, innerBuilder, allowNullValues);
        if (validateEndOfStream) {
            XContentParser.Token lastToken = null;
            try {
                while (!parser.isClosed() && (lastToken = parser.nextToken()) == null) {
                }
            }
            catch (Exception e) {
                throw new ElasticsearchParseException("malformed, expected end of settings but encountered additional content starting at line number: [{}], column number: [{}]", (Throwable)e, parser.getTokenLocation().lineNumber, parser.getTokenLocation().columnNumber);
            }
            if (lastToken != null) {
                throw new ElasticsearchParseException("malformed, expected end of settings but encountered additional content starting at line number: [{}], column number: [{}]", parser.getTokenLocation().lineNumber, parser.getTokenLocation().columnNumber);
            }
        }
        return innerBuilder.build();
    }

    private static void fromXContent(XContentParser parser, StringBuilder keyBuilder, Builder builder, boolean allowNullValues) throws IOException {
        int length = keyBuilder.length();
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String key;
            if (parser.currentToken() == XContentParser.Token.FIELD_NAME) {
                keyBuilder.setLength(length);
                keyBuilder.append(parser.currentName());
                continue;
            }
            if (parser.currentToken() == XContentParser.Token.START_OBJECT) {
                keyBuilder.append('.');
                Settings.fromXContent(parser, keyBuilder, builder, allowNullValues);
                continue;
            }
            if (parser.currentToken() == XContentParser.Token.START_ARRAY) {
                ArrayList<String> list = new ArrayList<String>();
                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                    if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
                        list.add(parser.text());
                        continue;
                    }
                    if (parser.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                        list.add(parser.text());
                        continue;
                    }
                    if (parser.currentToken() == XContentParser.Token.VALUE_BOOLEAN) {
                        list.add(String.valueOf(parser.text()));
                        continue;
                    }
                    throw new IllegalStateException("only value lists are allowed in serialized settings");
                }
                String key2 = keyBuilder.toString();
                Settings.validateValue(key2, list, builder, parser, allowNullValues);
                builder.putList(key2, list);
                continue;
            }
            if (parser.currentToken() == XContentParser.Token.VALUE_NULL) {
                key = keyBuilder.toString();
                Settings.validateValue(key, null, builder, parser, allowNullValues);
                builder.putNull(key);
                continue;
            }
            if (parser.currentToken() == XContentParser.Token.VALUE_STRING || parser.currentToken() == XContentParser.Token.VALUE_NUMBER) {
                key = keyBuilder.toString();
                String value = parser.text();
                Settings.validateValue(key, value, builder, parser, allowNullValues);
                builder.put(key, value);
                continue;
            }
            if (parser.currentToken() == XContentParser.Token.VALUE_BOOLEAN) {
                key = keyBuilder.toString();
                Settings.validateValue(key, parser.text(), builder, parser, allowNullValues);
                builder.put(key, parser.booleanValue());
                continue;
            }
            XContentParserUtils.throwUnknownToken(parser.currentToken(), parser.getTokenLocation());
        }
    }

    private static void validateValue(String key, Object currentValue, Builder builder, XContentParser parser, boolean allowNullValues) {
        if (builder.map.containsKey(key)) {
            throw new ElasticsearchParseException("duplicate settings key [{}] found at line number [{}], column number [{}], previous value [{}], current value [{}]", key, parser.getTokenLocation().lineNumber, parser.getTokenLocation().columnNumber, builder.map.get(key), currentValue);
        }
        if (currentValue == null && !allowNullValues) {
            throw new ElasticsearchParseException("null-valued setting found for key [{}] found at line number [{}], column number [{}]", key, parser.getTokenLocation().lineNumber, parser.getTokenLocation().columnNumber);
        }
    }

    public boolean isEmpty() {
        return this.settings.isEmpty();
    }

    public int size() {
        return this.keySet().size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> keySet() {
        SetOnce<Set<String>> setOnce = this.keys;
        synchronized (setOnce) {
            if (this.keys.get() == null) {
                this.keys.set(this.settings.keySet());
            }
        }
        return (Set)this.keys.get();
    }

    public String toString() {
        String string;
        block8: {
            XContentBuilder builder = XContentBuilder.builder((XContent)XContentType.JSON.xContent());
            try {
                builder.startObject();
                this.toXContent(builder, true);
                builder.endObject();
                string = Strings.toString(builder);
                if (builder == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (builder != null) {
                        try {
                            builder.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            }
            builder.close();
        }
        return string;
    }

    private static String toString(Object o) {
        return o == null ? null : o.toString();
    }

    private static final class FilteredMap
    extends AbstractMap<String, Object> {
        private final Map<String, Object> delegate;
        private final Predicate<String> filter;
        private final String prefix;
        private int size = -1;

        @Override
        public Set<Map.Entry<String, Object>> entrySet() {
            final Set<Map.Entry<String, Object>> delegateSet = this.delegate.entrySet();
            return new AbstractSet<Map.Entry<String, Object>>(this){
                final /* synthetic */ FilteredMap this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public Iterator<Map.Entry<String, Object>> iterator() {
                    final Iterator iter = delegateSet.iterator();
                    return new Iterator<Map.Entry<String, Object>>(){
                        private int numIterated;
                        private Map.Entry<String, Object> currentElement;
                        final /* synthetic */ 1 this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public boolean hasNext() {
                            if (this.currentElement != null) {
                                return true;
                            }
                            if (this.numIterated == this.this$1.this$0.size) {
                                assert (this.this$1.this$0.size != -1) : "size was never set: " + this.numIterated + " vs. " + this.this$1.this$0.size;
                                return false;
                            }
                            while (iter.hasNext()) {
                                this.currentElement = (Map.Entry)iter.next();
                                if (!this.this$1.this$0.filter.test((String)this.currentElement.getKey())) continue;
                                ++this.numIterated;
                                return true;
                            }
                            this.currentElement = null;
                            return false;
                        }

                        @Override
                        public Map.Entry<String, Object> next() {
                            if (this.currentElement == null && !this.hasNext()) {
                                throw new NoSuchElementException("make sure to call hasNext first");
                            }
                            final Map.Entry<String, Object> current = this.currentElement;
                            this.currentElement = null;
                            if (this.this$1.this$0.prefix == null) {
                                return current;
                            }
                            return new Map.Entry<String, Object>(){
                                final /* synthetic */ FilteredMap.1 this$2;
                                {
                                    this.this$2 = this$2;
                                }

                                @Override
                                public String getKey() {
                                    return ((String)current.getKey()).substring(this.this$2.this$1.this$0.prefix.length());
                                }

                                @Override
                                public Object getValue() {
                                    return current.getValue();
                                }

                                @Override
                                public Object setValue(Object value) {
                                    throw new UnsupportedOperationException();
                                }
                            };
                        }
                    };
                }

                @Override
                public int size() {
                    return this.this$0.size();
                }
            };
        }

        private FilteredMap(Map<String, Object> delegate, Predicate<String> filter, String prefix) {
            this.delegate = delegate;
            this.filter = filter;
            this.prefix = prefix;
        }

        @Override
        public Object get(Object key) {
            if (key instanceof String) {
                String theKey;
                String str = (String)key;
                String string = theKey = this.prefix == null ? str : this.prefix + str;
                if (this.filter.test(theKey)) {
                    return this.delegate.get(theKey);
                }
            }
            return null;
        }

        @Override
        public boolean containsKey(Object key) {
            if (key instanceof String) {
                String theKey;
                String str = (String)key;
                String string = theKey = this.prefix == null ? str : this.prefix + str;
                if (this.filter.test(theKey)) {
                    return this.delegate.containsKey(theKey);
                }
            }
            return false;
        }

        @Override
        public int size() {
            if (this.size == -1) {
                this.size = Math.toIntExact(this.delegate.keySet().stream().filter(this.filter).count());
            }
            return this.size;
        }
    }

    public static class Builder {
        private final Map<String, Object> map = new TreeMap<String, Object>();

        private Builder() {
        }

        public Set<String> keys() {
            return this.map.keySet();
        }

        public String remove(String key) {
            return Settings.toString(this.map.remove(key));
        }

        public String get(String key) {
            return Settings.toString(this.map.get(key));
        }

        public Builder put(String key, Path path) {
            return this.put(key, path.toString());
        }

        public Builder put(String key, TimeValue timeValue) {
            return this.put(key, timeValue.toString());
        }

        public Builder put(String key, ByteSizeValue byteSizeValue) {
            return this.put(key, byteSizeValue.toString());
        }

        public Builder put(String key, Enum<?> enumValue) {
            return this.put(key, enumValue.toString());
        }

        public Builder put(String key, Level level) {
            return this.put(key, level.toString());
        }

        public Builder put(String key, org.apache.lucene.util.Version luceneVersion) {
            return this.put(key, luceneVersion.toString());
        }

        public Builder put(String key, String value) {
            this.map.put(key, value);
            return this;
        }

        public Builder putStringOrList(String key, @Nullable Object value) {
            if (value instanceof String[]) {
                String[] strings = (String[])value;
                return this.putList(key, strings);
            }
            if (value instanceof List) {
                List list = (List)value;
                return this.putList(key, list);
            }
            return this.put(key, value == null ? null : value.toString());
        }

        public Builder copy(String key, Settings source) {
            return this.copy(key, key, source);
        }

        public Builder copy(String key, String sourceKey, Settings source) {
            if (!source.settings.containsKey(sourceKey)) {
                throw new IllegalArgumentException("source key not found in the source settings");
            }
            Object value = source.settings.get(sourceKey);
            if (value instanceof List) {
                List list = (List)value;
                return this.putList(key, list);
            }
            if (value == null) {
                return this.putNull(key);
            }
            return this.put(key, Settings.toString(value));
        }

        public Builder putNull(String key) {
            return this.put(key, (String)null);
        }

        public Builder put(String key, Class<?> clazz) {
            this.map.put(key, clazz.getName());
            return this;
        }

        public Builder put(String setting, boolean value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, int value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, Object value) {
            Object object = value;
            Objects.requireNonNull(object);
            Object object2 = object;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Integer.class, Long.class, String.class, Float.class, Double.class, Boolean.class, List.class}, (Object)object2, n)) {
                case 0: {
                    Integer i = (Integer)object2;
                    this.put(setting, i);
                    break;
                }
                case 1: {
                    Long l = (Long)object2;
                    this.put(setting, l);
                    break;
                }
                case 2: {
                    String l = (String)object2;
                    this.put(setting, l);
                    break;
                }
                case 3: {
                    Float f = (Float)object2;
                    this.put(setting, f.floatValue());
                    break;
                }
                case 4: {
                    Double d = (Double)object2;
                    this.put(setting, d);
                    break;
                }
                case 5: {
                    Boolean b = (Boolean)object2;
                    this.put(setting, b);
                    break;
                }
                case 6: {
                    List l = (List)object2;
                    this.putList(setting, l);
                    break;
                }
                default: {
                    throw new IllegalArgumentException(String.format(Locale.ENGLISH, "Unsupported value: `%s`", setting, value));
                }
            }
            return this;
        }

        public Builder put(GenericProperties<Object> properties) {
            for (Map.Entry entry : properties) {
                String settingName = (String)entry.getKey();
                this.putStringOrList(settingName, entry.getValue());
            }
            return this;
        }

        public Builder put(String setting, Version version) {
            this.put(setting, version.internalId);
            return this;
        }

        public Builder put(String setting, long value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, float value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, double value) {
            this.put(setting, String.valueOf(value));
            return this;
        }

        public Builder put(String setting, long value, TimeUnit timeUnit) {
            this.put(setting, timeUnit.toMillis(value) + "ms");
            return this;
        }

        public Builder put(String setting, long value, ByteSizeUnit sizeUnit) {
            this.put(setting, sizeUnit.toBytes(value) + "b");
            return this;
        }

        public Builder putList(String setting, String ... values) {
            return this.putList(setting, Arrays.asList(values));
        }

        public Builder putList(String setting, List<?> values) {
            this.remove(setting);
            this.map.put(setting, new ArrayList(values));
            return this;
        }

        public Builder put(String settingPrefix, String groupName, String[] settings, String[] values) throws SettingsException {
            if (settings.length != values.length) {
                throw new SettingsException("The settings length must match the value length");
            }
            for (int i = 0; i < settings.length; ++i) {
                if (values[i] == null) continue;
                this.put(settingPrefix + "." + groupName + "." + settings[i], values[i]);
            }
            return this;
        }

        public Builder put(Settings settings) {
            HashMap<String, Object> settingsMap = new HashMap<String, Object>(settings.settings);
            this.processLegacyLists(settingsMap);
            this.map.putAll(settingsMap);
            return this;
        }

        private void processLegacyLists(Map<String, Object> map) {
            String[] array;
            block0: for (String key : array = map.keySet().toArray(new String[0])) {
                if (!key.endsWith(".0")) continue;
                int counter = 0;
                String prefix = key.substring(0, key.lastIndexOf(46));
                if (map.containsKey(prefix)) {
                    throw new IllegalStateException("settings builder can't contain values for [" + prefix + "=" + String.valueOf(map.get(prefix)) + "] and [" + key + "=" + String.valueOf(map.get(key)) + "]");
                }
                ArrayList<String> values = new ArrayList<String>();
                while (true) {
                    String listKey;
                    String value;
                    if ((value = this.get(listKey = prefix + "." + counter++)) == null) {
                        map.put(prefix, values);
                        continue block0;
                    }
                    values.add(value);
                    map.remove(listKey);
                }
            }
        }

        public Builder loadFromSource(String source, XContentType xContentType) {
            try (XContentParser parser = xContentType.xContent().createParser(NamedXContentRegistry.EMPTY, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, source);){
                this.put(Settings.fromXContent(parser, true, true));
            }
            catch (Exception e) {
                throw new SettingsException("Failed to load settings from [" + source + "]", e);
            }
            return this;
        }

        public Builder loadFromPath(Path path) throws IOException {
            return this.loadFromStream(path.getFileName().toString(), Files.newInputStream(path, new OpenOption[0]), false);
        }

        /*
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Builder loadFromStream(String resourceName, InputStream is, boolean acceptNullValues) throws IOException {
            block18: {
                block16: {
                    block17: {
                        if (resourceName.endsWith(".json")) {
                            xContentType = XContentType.JSON;
                        } else {
                            if (!resourceName.endsWith(".yml")) {
                                if (resourceName.endsWith(".yaml") == false) throw new IllegalArgumentException("unable to detect content type from resource name [" + resourceName + "]");
                            }
                            xContentType = XContentType.YAML;
                        }
                        try {
                            parser = xContentType.xContent().createParser(NamedXContentRegistry.EMPTY, DeprecationHandler.THROW_UNSUPPORTED_OPERATION, is);
                            if (parser.currentToken() != null || parser.nextToken() != null) break block16;
                            var6_8 = this;
                            if (parser == null) break block17;
                            parser.close();
                        }
                        catch (ElasticsearchParseException e) {
                            try {
                                throw e;
                                catch (Exception e) {
                                    throw new SettingsException("Failed to load settings from [" + resourceName + "]", e);
                                }
                            }
                            catch (Throwable var8_11) {
                                IOUtils.close((Closeable[])new Closeable[]{is});
                                throw var8_11;
                            }
                        }
                    }
                    IOUtils.close((Closeable[])new Closeable[]{is});
                    return var6_8;
                }
                ** try [egrp 3[TRYBLOCK] [1 : 128->140)] { 
lbl31:
                // 1 sources

                break block18;
lbl32:
                // 1 sources

                finally {
                    if (parser != null) {
                        parser.close();
                    }
                }
            }
            this.put(Settings.fromXContent(parser, acceptNullValues, true));
            IOUtils.close((Closeable[])new Closeable[]{is});
            return this;
        }

        public Builder putProperties(Map<String, String> esSettings, UnaryOperator<String> keyFunction) {
            for (Map.Entry<String, String> esSetting : esSettings.entrySet()) {
                String key = esSetting.getKey();
                this.put((String)keyFunction.apply(key), esSetting.getValue());
            }
            return this;
        }

        public Builder replacePropertyPlaceholders() {
            return this.replacePropertyPlaceholders(System::getenv);
        }

        Builder replacePropertyPlaceholders(final UnaryOperator<String> getenv) {
            PropertyPlaceholder propertyPlaceholder = new PropertyPlaceholder("${", "}", false);
            PropertyPlaceholder.PlaceholderResolver placeholderResolver = new PropertyPlaceholder.PlaceholderResolver(){
                final /* synthetic */ Builder this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public String resolvePlaceholder(String placeholderName) {
                    String value = (String)getenv.apply(placeholderName);
                    if (value != null) {
                        return value;
                    }
                    return Settings.toString(this.this$0.map.get(placeholderName));
                }

                @Override
                public boolean shouldIgnoreMissing(String placeholderName) {
                    return placeholderName.startsWith("prompt.");
                }

                @Override
                public boolean shouldRemoveMissingPlaceholder(String placeholderName) {
                    return !placeholderName.startsWith("prompt.");
                }
            };
            Iterator<Map.Entry<String, Object>> entryItr = this.map.entrySet().iterator();
            while (entryItr.hasNext()) {
                Map.Entry<String, Object> entry = entryItr.next();
                if (entry.getValue() == null) continue;
                if (entry.getValue() instanceof List) {
                    ListIterator<String> li = ((List)entry.getValue()).listIterator();
                    while (li.hasNext()) {
                        String settingValueRaw = (String)li.next();
                        String settingValueResolved = propertyPlaceholder.replacePlaceholders(settingValueRaw, placeholderResolver);
                        li.set(settingValueResolved);
                    }
                    continue;
                }
                String value = propertyPlaceholder.replacePlaceholders(Settings.toString(entry.getValue()), placeholderResolver);
                if (Strings.hasLength(value)) {
                    entry.setValue(value);
                    continue;
                }
                entryItr.remove();
            }
            return this;
        }

        public Builder normalizePrefix(String prefix) {
            HashMap<CallSite, Object> replacements = new HashMap<CallSite, Object>();
            Iterator<Map.Entry<String, Object>> iterator = this.map.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String key = entry.getKey();
                if (key.startsWith(prefix) || key.endsWith("*")) continue;
                replacements.put((CallSite)((Object)(prefix + key)), entry.getValue());
                iterator.remove();
            }
            this.map.putAll(replacements);
            return this;
        }

        public Settings build() {
            this.processLegacyLists(this.map);
            return new Settings(this.map);
        }
    }

    static class DeprecationLoggerHolder {
        static DeprecationLogger deprecationLogger = new DeprecationLogger(LogManager.getLogger(Settings.class));

        DeprecationLoggerHolder() {
        }
    }
}

