/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.settings;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.Module;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.SettingUpgrader;
import org.elasticsearch.common.settings.Settings;

public class SettingsModule
implements Module {
    private final Settings settings;
    private final Map<String, Setting<?>> nodeSettings = new HashMap();
    private final Map<String, Setting<?>> indexSettings = new HashMap();
    private final IndexScopedSettings indexScopedSettings;
    private final ClusterSettings clusterSettings;

    public SettingsModule(Settings settings, Setting<?> ... additionalSettings) {
        this(settings, Arrays.asList(additionalSettings), Collections.emptySet());
    }

    public SettingsModule(Settings settings, List<Setting<?>> additionalSettings, Set<SettingUpgrader<?>> settingUpgraders) {
        this.settings = settings;
        ArrayList maskedSettings = new ArrayList();
        for (Setting<?> setting : ClusterSettings.BUILT_IN_CLUSTER_SETTINGS) {
            this.registerSetting(setting);
            if (!setting.isMasked()) continue;
            maskedSettings.add(setting);
        }
        for (Setting<?> setting : IndexScopedSettings.BUILT_IN_INDEX_SETTINGS) {
            this.registerSetting(setting);
        }
        for (Setting<?> setting : additionalSettings) {
            this.registerSetting(setting);
            if (!setting.isMasked()) continue;
            maskedSettings.add(setting);
        }
        HashSet clusterSettingUpgraders = new HashSet();
        for (SettingUpgrader<?> settingUpgrader : settingUpgraders) {
            assert (settingUpgrader.getSetting().hasNodeScope()) : settingUpgrader.getSetting().getKey();
            boolean added = clusterSettingUpgraders.add(settingUpgrader);
            assert (added) : settingUpgrader.getSetting().getKey();
        }
        this.indexScopedSettings = new IndexScopedSettings(settings, new HashSet(this.indexSettings.values()));
        this.clusterSettings = new ClusterSettings(settings, maskedSettings, new HashSet(this.nodeSettings.values()), clusterSettingUpgraders);
        Settings settings2 = settings.filter(s -> s.startsWith("index.") && this.clusterSettings.get((String)s) == null);
        if (!settings2.isEmpty()) {
            throw new IllegalArgumentException("Index settings found. These have been unsupported since CrateDB 2.0 and should've been migrated.");
        }
        this.clusterSettings.validate(settings, true);
    }

    public void configure(Binder binder) {
        binder.bind(Settings.class).toInstance((Object)this.settings);
        binder.bind(ClusterSettings.class).toInstance((Object)this.clusterSettings);
        binder.bind(IndexScopedSettings.class).toInstance((Object)this.indexScopedSettings);
    }

    private void registerSetting(Setting<?> setting) {
        if (setting.hasNodeScope() || setting.hasIndexScope()) {
            Setting<?> existingSetting;
            if (setting.hasNodeScope()) {
                existingSetting = this.nodeSettings.get(setting.getKey());
                if (existingSetting != null) {
                    throw new IllegalArgumentException("Cannot register setting [" + setting.getKey() + "] twice");
                }
                this.nodeSettings.put(setting.getKey(), setting);
            }
            if (setting.hasIndexScope()) {
                existingSetting = this.indexSettings.get(setting.getKey());
                if (existingSetting != null) {
                    throw new IllegalArgumentException("Cannot register setting [" + setting.getKey() + "] twice");
                }
                this.indexSettings.put(setting.getKey(), setting);
            }
        } else {
            throw new IllegalArgumentException("No scope found for setting [" + setting.getKey() + "]");
        }
    }

    public Settings getSettings() {
        return this.settings;
    }

    public IndexScopedSettings getIndexScopedSettings() {
        return this.indexScopedSettings;
    }

    public ClusterSettings getClusterSettings() {
        return this.clusterSettings;
    }
}

