/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.util.concurrent;

import java.util.Objects;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.util.concurrent.RejectableRunnable;

public abstract class AbstractLifecycleRunnable
implements RejectableRunnable {
    private final Lifecycle lifecycle;
    private final Logger logger;

    public AbstractLifecycleRunnable(Lifecycle lifecycle, Logger logger) {
        this.lifecycle = Objects.requireNonNull(lifecycle, "lifecycle must not be null");
        this.logger = Objects.requireNonNull(logger, "logger must not be null");
    }

    @Override
    public final void doRun() throws Exception {
        if (this.lifecycle.stoppedOrClosed()) {
            this.logger.trace("lifecycle is stopping. exiting");
            return;
        }
        this.doRunInLifecycle();
    }

    protected abstract void doRunInLifecycle() throws Exception;

    @Override
    public final void onAfter() {
        if (!this.lifecycle.stoppedOrClosed()) {
            this.onAfterInLifecycle();
        }
    }

    protected void onAfterInLifecycle() {
    }
}

