/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import io.crate.common.collections.Tuple;
import io.crate.common.io.IOUtils;
import io.crate.exceptions.SQLExceptions;
import io.crate.server.xcontent.LoggingDeprecationHandler;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.backward_codecs.store.EndiannessReverserUtil;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.IndexFormatTooNewException;
import org.apache.lucene.index.IndexFormatTooOldException;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.NIOFSDirectory;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.InputStreamStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableAwareStreamInput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.OutputStreamStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lucene.store.IndexOutputOutputStream;
import org.elasticsearch.common.lucene.store.InputStreamIndexInput;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.gateway.CorruptStateException;
import org.elasticsearch.gateway.WriteStateException;

public abstract class MetadataStateFormat<T extends Writeable> {
    public static final XContentType FORMAT = XContentType.SMILE;
    public static final String STATE_DIR_NAME = "_state";
    public static final String STATE_FILE_EXTENSION = ".st";
    private static final String STATE_FILE_CODEC = "state";
    private static final int MIN_COMPATIBLE_STATE_FILE_VERSION = 1;
    private static final int XCONTENT_STATE_VERSION = 1;
    private static final int STATE_FILE_VERSION = 2;
    private final String prefix;
    private final Pattern stateFilePattern;
    private static final Logger LOGGER = LogManager.getLogger(MetadataStateFormat.class);

    protected MetadataStateFormat(String prefix) {
        this.prefix = prefix;
        this.stateFilePattern = Pattern.compile(Pattern.quote(prefix) + "(\\d+)(.st)?");
    }

    private static void deleteFileIfExists(Path stateLocation, Directory directory, String fileName) throws IOException {
        try {
            directory.deleteFile(fileName);
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            // empty catch block
        }
        LOGGER.trace("cleaned up {}", (Object)stateLocation.resolve(fileName));
    }

    private static void deleteFileIgnoreExceptions(Path stateLocation, Directory directory, String fileName) {
        try {
            MetadataStateFormat.deleteFileIfExists(stateLocation, directory, fileName);
        }
        catch (IOException e) {
            LOGGER.trace("clean up failed {}", (Object)stateLocation.resolve(fileName));
        }
    }

    private void writeStateToFirstLocation(T state, Path stateLocation, Directory stateDir, String tmpFileName) throws WriteStateException {
        try {
            MetadataStateFormat.deleteFileIfExists(stateLocation, stateDir, tmpFileName);
            try (IndexOutput out = EndiannessReverserUtil.createOutput((Directory)stateDir, (String)tmpFileName, (IOContext)IOContext.DEFAULT);){
                CodecUtil.writeHeader((DataOutput)out, (String)STATE_FILE_CODEC, (int)2);
                OutputStreamStreamOutput streamOutput = new OutputStreamStreamOutput(new IndexOutputOutputStream(out));
                Version.writeVersion(Version.CURRENT, streamOutput);
                state.writeTo(streamOutput);
                CodecUtil.writeFooter((IndexOutput)out);
            }
            stateDir.sync(Collections.singleton(tmpFileName));
        }
        catch (Exception e) {
            throw new WriteStateException(false, "failed to write state to the first location tmp file " + String.valueOf(stateLocation.resolve(tmpFileName)), e);
        }
    }

    private static void copyStateToExtraLocations(List<Tuple<Path, Directory>> stateDirs, String tmpFileName) throws WriteStateException {
        Directory srcStateDir = (Directory)stateDirs.get(0).v2();
        for (int i = 1; i < stateDirs.size(); ++i) {
            Tuple<Path, Directory> extraStatePathAndDir = stateDirs.get(i);
            Path extraStateLocation = (Path)extraStatePathAndDir.v1();
            Directory extraStateDir = (Directory)extraStatePathAndDir.v2();
            try {
                MetadataStateFormat.deleteFileIfExists(extraStateLocation, extraStateDir, tmpFileName);
                extraStateDir.copyFrom(srcStateDir, tmpFileName, tmpFileName, IOContext.DEFAULT);
                extraStateDir.sync(Collections.singleton(tmpFileName));
                continue;
            }
            catch (Exception e) {
                throw new WriteStateException(false, "failed to copy tmp state file to extra location " + String.valueOf(extraStateLocation), e);
            }
        }
    }

    private static void performRenames(String tmpFileName, String fileName, List<Tuple<Path, Directory>> stateDirectories) throws WriteStateException {
        Directory firstStateDirectory = (Directory)stateDirectories.get(0).v2();
        try {
            firstStateDirectory.rename(tmpFileName, fileName);
        }
        catch (IOException e) {
            throw new WriteStateException(false, "failed to rename tmp file to final name in the first state location " + String.valueOf(((Path)stateDirectories.get(0).v1()).resolve(tmpFileName)), e);
        }
        for (int i = 1; i < stateDirectories.size(); ++i) {
            Directory extraStateDirectory = (Directory)stateDirectories.get(i).v2();
            try {
                extraStateDirectory.rename(tmpFileName, fileName);
                continue;
            }
            catch (IOException e) {
                throw new WriteStateException(true, "failed to rename tmp file to final name in extra state location " + String.valueOf(((Path)stateDirectories.get(i).v1()).resolve(tmpFileName)), e);
            }
        }
    }

    private static void performStateDirectoriesFsync(List<Tuple<Path, Directory>> stateDirectories) throws WriteStateException {
        for (int i = 0; i < stateDirectories.size(); ++i) {
            try {
                ((Directory)stateDirectories.get(i).v2()).syncMetaData();
                continue;
            }
            catch (IOException e) {
                throw new WriteStateException(true, "meta data directory fsync has failed " + String.valueOf(stateDirectories.get(i).v1()), e);
            }
        }
    }

    public final long writeAndCleanup(T state, Path ... locations) throws WriteStateException {
        return this.write(state, true, locations);
    }

    public final long write(T state, Path ... locations) throws WriteStateException {
        return this.write(state, false, locations);
    }

    private long write(T state, boolean cleanup, Path ... locations) throws WriteStateException {
        long newGenerationId;
        long oldGenerationId;
        if (locations == null) {
            throw new IllegalArgumentException("Locations must not be null");
        }
        if (locations.length <= 0) {
            throw new IllegalArgumentException("One or more locations required");
        }
        try {
            oldGenerationId = this.findMaxGenerationId(this.prefix, locations);
            newGenerationId = oldGenerationId + 1L;
        }
        catch (Exception e) {
            throw new WriteStateException(false, "exception during looking up new generation id", e);
        }
        assert (newGenerationId >= 0L) : "newGenerationId must be positive but was: [" + oldGenerationId + "]";
        String fileName = this.getStateFileName(newGenerationId);
        String tmpFileName = fileName + ".tmp";
        ArrayList<Tuple<Path, Directory>> directories = new ArrayList<Tuple<Path, Directory>>();
        try {
            for (Path location : locations) {
                Path stateLocation = location.resolve(STATE_DIR_NAME);
                try {
                    directories.add(new Tuple((Object)location, (Object)this.newDirectory(stateLocation)));
                }
                catch (IOException e) {
                    throw new WriteStateException(false, "failed to open state directory " + String.valueOf(stateLocation), e);
                }
            }
            this.writeStateToFirstLocation(state, (Path)((Tuple)directories.get(0)).v1(), (Directory)((Tuple)directories.get(0)).v2(), tmpFileName);
            MetadataStateFormat.copyStateToExtraLocations(directories, tmpFileName);
            MetadataStateFormat.performRenames(tmpFileName, fileName, directories);
            MetadataStateFormat.performStateDirectoriesFsync(directories);
        }
        catch (WriteStateException e) {
            try {
                if (cleanup) {
                    this.cleanupOldFiles(oldGenerationId, locations);
                }
                throw e;
            }
            catch (Throwable throwable) {
                for (Tuple tuple : directories) {
                    MetadataStateFormat.deleteFileIgnoreExceptions((Path)tuple.v1(), (Directory)tuple.v2(), tmpFileName);
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{(Closeable)tuple.v2()});
                }
                throw throwable;
            }
        }
        for (Tuple tuple : directories) {
            MetadataStateFormat.deleteFileIgnoreExceptions((Path)tuple.v1(), (Directory)tuple.v2(), tmpFileName);
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{(Closeable)tuple.v2()});
        }
        if (cleanup) {
            this.cleanupOldFiles(newGenerationId, locations);
        }
        return newGenerationId;
    }

    @Deprecated
    public abstract T fromXContent(XContentParser var1) throws IOException;

    public abstract T readFrom(StreamInput var1) throws IOException;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final T read(NamedWriteableRegistry namedWritableRegistry, NamedXContentRegistry namedXContentRegistry, Path file) throws IOException {
        T t;
        XContentParser parser;
        XContentType xContentType;
        Directory dir = this.newDirectory(file.getParent());
        IndexInput indexInput = EndiannessReverserUtil.openInput((Directory)dir, (String)file.getFileName().toString(), (IOContext)IOContext.DEFAULT);
        CodecUtil.checksumEntireFile((IndexInput)indexInput);
        int stateVersion = CodecUtil.checkHeader((DataInput)indexInput, (String)STATE_FILE_CODEC, (int)1, (int)2);
        if (stateVersion == 1 && (xContentType = XContentType.values()[indexInput.readInt()]) != FORMAT) {
            throw new IllegalStateException("expected state in " + String.valueOf(file) + " to be " + String.valueOf(FORMAT) + " format but was " + String.valueOf(xContentType));
        }
        long filePointer = indexInput.getFilePointer();
        long contentSize = indexInput.length() - (long)CodecUtil.footerLength() - filePointer;
        IndexInput slice = indexInput.slice("state_xcontent", filePointer, contentSize);
        InputStreamIndexInput in = new InputStreamIndexInput(slice, contentSize);
        if (stateVersion == 1) {
            parser = FORMAT.xContent().createParser(namedXContentRegistry, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE, (InputStream)in);
            T t2 = this.fromXContent(parser);
            return t2;
        }
        NamedWriteableAwareStreamInput streamInput = new NamedWriteableAwareStreamInput(new InputStreamStreamInput(in), namedWritableRegistry);
        try {
            Version version = Version.readVersion(streamInput);
            streamInput.setVersion(version);
            t = this.readFrom(streamInput);
        }
        catch (Throwable throwable) {
            try {
                try {
                    streamInput.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (CorruptIndexException | IndexFormatTooNewException | IndexFormatTooOldException ex) {}
            throw new CorruptStateException(ex);
            finally {
                if (parser != null) {
                    parser.close();
                }
            }
            finally {
                in.close();
            }
            finally {
                if (slice != null) {
                    slice.close();
                }
            }
            finally {
                if (indexInput != null) {
                    indexInput.close();
                }
            }
        }
        finally {
            if (dir != null) {
                dir.close();
            }
        }
        streamInput.close();
        return t;
    }

    protected Directory newDirectory(Path dir) throws IOException {
        return new NIOFSDirectory(dir);
    }

    public void cleanupOldFiles(long currentGeneration, Path[] locations) {
        String fileNameToKeep = this.getStateFileName(currentGeneration);
        for (Path location : locations) {
            LOGGER.trace("cleanupOldFiles: cleaning up {}", (Object)location);
            Path stateLocation = location.resolve(STATE_DIR_NAME);
            try (Directory stateDir = this.newDirectory(stateLocation);){
                for (String file : stateDir.listAll()) {
                    if (!file.startsWith(this.prefix) || file.equals(fileNameToKeep)) continue;
                    MetadataStateFormat.deleteFileIgnoreExceptions(stateLocation, stateDir, file);
                }
            }
            catch (Exception e) {
                LOGGER.trace("clean up failed for state location {}", (Object)stateLocation);
            }
        }
    }

    private long findMaxGenerationId(String prefix, Path ... locations) throws IOException {
        long maxId = -1L;
        for (Path dataLocation : locations) {
            Path resolve = dataLocation.resolve(STATE_DIR_NAME);
            if (!Files.exists(resolve, new LinkOption[0])) continue;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(resolve, prefix + "*");){
                for (Path stateFile : stream) {
                    Matcher matcher = this.stateFilePattern.matcher(stateFile.getFileName().toString());
                    if (!matcher.matches()) continue;
                    long id = Long.parseLong(matcher.group(1));
                    maxId = Math.max(maxId, id);
                }
            }
        }
        return maxId;
    }

    private List<Path> findStateFilesByGeneration(long generation, Path ... locations) {
        ArrayList<Path> files = new ArrayList<Path>();
        if (generation == -1L) {
            return files;
        }
        String fileName = this.getStateFileName(generation);
        for (Path dataLocation : locations) {
            Path stateFilePath = dataLocation.resolve(STATE_DIR_NAME).resolve(fileName);
            if (!Files.exists(stateFilePath, new LinkOption[0])) continue;
            LOGGER.trace("found state file: {}", (Object)stateFilePath);
            files.add(stateFilePath);
        }
        return files;
    }

    public String getStateFileName(long generation) {
        return this.prefix + generation + STATE_FILE_EXTENSION;
    }

    public T loadGeneration(Logger logger, NamedWriteableRegistry namedWriteableRegistry, NamedXContentRegistry namedXContentRegistry, long generation, Path ... dataLocations) {
        List<Path> stateFiles = this.findStateFilesByGeneration(generation, dataLocations);
        ArrayList<IOException> exceptions = new ArrayList<IOException>();
        for (Path stateFile : stateFiles) {
            try {
                T state = this.read(namedWriteableRegistry, namedXContentRegistry, stateFile);
                logger.trace("generation id [{}] read from [{}]", (Object)generation, (Object)stateFile.getFileName());
                return state;
            }
            catch (Exception e) {
                exceptions.add(new IOException("failed to read " + String.valueOf(stateFile.toAbsolutePath()), e));
                logger.debug(() -> new ParameterizedMessage("{}: failed to read [{}], ignoring...", (Object)stateFile.toAbsolutePath(), (Object)this.prefix), (Throwable)e);
            }
        }
        SQLExceptions.maybeThrowRuntimeAndSuppress(exceptions);
        if (stateFiles.size() > 0) {
            throw new IllegalStateException("Could not find a state file to recover from among " + stateFiles.stream().map(Path::toAbsolutePath).map(Object::toString).collect(Collectors.joining(", ")));
        }
        return null;
    }

    public Tuple<T, Long> loadLatestStateWithGeneration(Logger logger, NamedWriteableRegistry namedWriteableRegistry, NamedXContentRegistry namedXContentRegistry, Path ... dataLocations) throws IOException {
        long generation = this.findMaxGenerationId(this.prefix, dataLocations);
        T state = this.loadGeneration(logger, namedWriteableRegistry, namedXContentRegistry, generation, dataLocations);
        if (generation > -1L && state == null) {
            throw new IllegalStateException("unable to find state files with generation id " + generation + " returned by findMaxGenerationId function, in data folders [" + Arrays.stream(dataLocations).map(Path::toAbsolutePath).map(Object::toString).collect(Collectors.joining(", ")) + "], concurrent writes?");
        }
        return new Tuple(state, (Object)generation);
    }

    public T loadLatestState(Logger logger, NamedWriteableRegistry namedWriteableRegistry, NamedXContentRegistry namedXContentRegistry, Path ... dataLocations) throws IOException {
        return (T)((Writeable)this.loadLatestStateWithGeneration(logger, namedWriteableRegistry, namedXContentRegistry, dataLocations).v1());
    }

    public static void deleteMetaState(Path ... dataLocations) throws IOException {
        Path[] stateDirectories = new Path[dataLocations.length];
        for (int i = 0; i < dataLocations.length; ++i) {
            stateDirectories[i] = dataLocations[i].resolve(STATE_DIR_NAME);
        }
        IOUtils.rm((Path[])stateDirectories);
    }

    public String getPrefix() {
        return this.prefix;
    }
}

