/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.util.Map;
import java.util.Objects;
import org.apache.lucene.search.Sort;
import org.apache.lucene.util.Version;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.jetbrains.annotations.Nullable;

public class Segment {
    private final String name;
    private final long generation;
    public boolean committed;
    public boolean search;
    public long sizeInBytes = -1L;
    public int docCount = -1;
    public int delDocCount = -1;
    public Version version = null;
    public Boolean compound = null;
    public String mergeId;
    public int docsWithSource;
    public Sort segmentSort;
    public Map<String, String> attributes;

    public Segment(String name) {
        this.name = name;
        this.generation = Long.parseLong(name.substring(1), 36);
    }

    public String getName() {
        return this.name;
    }

    public long getGeneration() {
        return this.generation;
    }

    public boolean isCommitted() {
        return this.committed;
    }

    public boolean isSearch() {
        return this.search;
    }

    public int getNumDocs() {
        return this.docCount;
    }

    public int getDeletedDocs() {
        return this.delDocCount;
    }

    public ByteSizeValue getSize() {
        return new ByteSizeValue(this.sizeInBytes);
    }

    @Nullable
    public String getMergeId() {
        return this.mergeId;
    }

    public Version getVersion() {
        return this.version;
    }

    @Nullable
    public Boolean isCompound() {
        return this.compound;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Segment segment = (Segment)o;
        return Objects.equals(this.name, segment.name);
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public String toString() {
        return "Segment{name='" + this.name + "', generation=" + this.generation + ", committed=" + this.committed + ", search=" + this.search + ", sizeInBytes=" + this.sizeInBytes + ", docCount=" + this.docCount + ", delDocCount=" + this.delDocCount + ", version='" + String.valueOf(this.version) + "', compound=" + this.compound + ", mergeId='" + this.mergeId + "'" + (String)(this.segmentSort != null ? ", sort=" + String.valueOf(this.segmentSort) : "") + ", attributes=" + String.valueOf(this.attributes) + "}";
    }
}

