/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.util.Objects;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;

public class SequenceIDFields {
    public final Field seqNo;
    public final Field seqNoDocValue;
    public final Field primaryTerm;
    public final Field tombstoneField;

    public SequenceIDFields(Field seqNo, Field seqNoDocValue, Field primaryTerm, Field tombstoneField) {
        Objects.requireNonNull(seqNo, "sequence number field cannot be null");
        Objects.requireNonNull(seqNoDocValue, "sequence number dv field cannot be null");
        Objects.requireNonNull(primaryTerm, "primary term field cannot be null");
        this.seqNo = seqNo;
        this.seqNoDocValue = seqNoDocValue;
        this.primaryTerm = primaryTerm;
        this.tombstoneField = tombstoneField;
    }

    public static SequenceIDFields emptySeqID() {
        return new SequenceIDFields((Field)new LongPoint("_seq_no", new long[]{-2L}), (Field)new NumericDocValuesField("_seq_no", -2L), (Field)new NumericDocValuesField("_primary_term", 0L), (Field)new NumericDocValuesField("_tombstone", 0L));
    }
}

