/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.seqno;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.single.shard.SingleShardRequest;
import org.elasticsearch.action.support.single.shard.TransportSingleShardAction;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.routing.ShardsIterator;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportService;

public class RetentionLeaseActions {
    public static final long RETAIN_ALL = -1L;

    public static class Response
    extends TransportResponse {
        public Response() {
        }

        Response(StreamInput in) throws IOException {
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
        }
    }

    public static class RemoveRequest
    extends Request {
        RemoveRequest(StreamInput in) throws IOException {
            super(in);
        }

        public RemoveRequest(ShardId shardId, String id) {
            super(shardId, id);
        }
    }

    public static class AddOrRenewRequest
    extends Request {
        private final long retainingSequenceNumber;
        private final String source;

        public long getRetainingSequenceNumber() {
            return this.retainingSequenceNumber;
        }

        public String getSource() {
            return this.source;
        }

        AddOrRenewRequest(StreamInput in) throws IOException {
            super(in);
            this.retainingSequenceNumber = in.readZLong();
            this.source = in.readString();
        }

        public AddOrRenewRequest(ShardId shardId, String id, long retainingSequenceNumber, String source) {
            super(shardId, id);
            if (retainingSequenceNumber < 0L && retainingSequenceNumber != -1L) {
                throw new IllegalArgumentException("retaining sequence number [" + retainingSequenceNumber + "] out of range");
            }
            this.retainingSequenceNumber = retainingSequenceNumber;
            this.source = Objects.requireNonNull(source);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            out.writeZLong(this.retainingSequenceNumber);
            out.writeString(this.source);
        }
    }

    private static abstract class Request
    extends SingleShardRequest {
        private final ShardId shardId;
        private final String id;

        public ShardId getShardId() {
            return this.shardId;
        }

        public String getId() {
            return this.id;
        }

        Request(StreamInput in) throws IOException {
            super(in);
            this.shardId = new ShardId(in);
            this.id = in.readString();
        }

        Request(ShardId shardId, String id) {
            super(Objects.requireNonNull(shardId).getIndexName());
            this.shardId = shardId;
            this.id = Objects.requireNonNull(id);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.shardId.writeTo(out);
            out.writeString(this.id);
        }
    }

    public static class Remove
    extends ActionType<Response> {
        public static final Remove INSTANCE = new Remove();
        public static final String ACTION_NAME = "indices:admin/seq_no/remove_retention_lease";

        private Remove() {
            super(ACTION_NAME);
        }

        @Override
        public Writeable.Reader<Response> getResponseReader() {
            return Response::new;
        }

        public static class TransportAction
        extends TransportRetentionLeaseAction<RemoveRequest> {
            @Inject
            public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService) {
                super(Remove.ACTION_NAME, threadPool, clusterService, transportService, indicesService, RemoveRequest::new);
            }

            @Override
            void doRetentionLeaseAction(IndexShard indexShard, RemoveRequest request, ActionListener<Response> listener) {
                indexShard.removeRetentionLease(request.getId(), listener.map(r -> new Response()));
            }
        }
    }

    public static class Renew
    extends ActionType<Response> {
        public static final Renew INSTANCE = new Renew();
        public static final String ACTION_NAME = "indices:admin/seq_no/renew_retention_lease";

        private Renew() {
            super(ACTION_NAME);
        }

        @Override
        public Writeable.Reader<Response> getResponseReader() {
            return Response::new;
        }

        public static class TransportAction
        extends TransportRetentionLeaseAction<AddOrRenewRequest> {
            @Inject
            public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService) {
                super(Renew.ACTION_NAME, threadPool, clusterService, transportService, indicesService, AddOrRenewRequest::new);
            }

            @Override
            void doRetentionLeaseAction(IndexShard indexShard, AddOrRenewRequest request, ActionListener<Response> listener) {
                indexShard.renewRetentionLease(request.getId(), request.getRetainingSequenceNumber(), request.getSource());
                listener.onResponse(new Response());
            }
        }
    }

    public static class Add
    extends ActionType<Response> {
        public static final Add INSTANCE = new Add();
        public static final String ACTION_NAME = "indices:admin/seq_no/add_retention_lease";

        private Add() {
            super(ACTION_NAME);
        }

        @Override
        public Writeable.Reader<Response> getResponseReader() {
            return Response::new;
        }

        public static class TransportAction
        extends TransportRetentionLeaseAction<AddOrRenewRequest> {
            @Inject
            public TransportAction(ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService) {
                super(Add.ACTION_NAME, threadPool, clusterService, transportService, indicesService, AddOrRenewRequest::new);
            }

            @Override
            void doRetentionLeaseAction(IndexShard indexShard, AddOrRenewRequest request, ActionListener<Response> listener) {
                indexShard.addRetentionLease(request.getId(), request.getRetainingSequenceNumber(), request.getSource(), listener.map(r -> new Response()));
            }
        }
    }

    static abstract class TransportRetentionLeaseAction<T extends Request>
    extends TransportSingleShardAction<T, Response> {
        private final IndicesService indicesService;

        @Inject
        TransportRetentionLeaseAction(String name, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndicesService indicesService, Writeable.Reader<T> requestSupplier) {
            super(name, threadPool, clusterService, transportService, requestSupplier, "management");
            this.indicesService = Objects.requireNonNull(indicesService);
        }

        @Override
        protected ShardsIterator shards(ClusterState state, T request) {
            return state.routingTable().shardRoutingTable(((Request)request).getShardId().getIndexName(), ((Request)request).getShardId().id()).primaryShardIt();
        }

        @Override
        protected void asyncShardOperation(T request, ShardId shardId, ActionListener<Response> listener) {
            IndexService indexService = this.indicesService.indexServiceSafe(shardId.getIndex());
            IndexShard indexShard = indexService.getShard(shardId.id());
            indexShard.acquirePrimaryOperationPermit(listener.withOnResponse((l, releasable) -> {
                try (Releasable releasable2 = releasable;){
                    this.doRetentionLeaseAction(indexShard, request, (ActionListener<Response>)l);
                }
            }), "same", request);
        }

        @Override
        protected Response shardOperation(T request, ShardId shardId) {
            throw new UnsupportedOperationException();
        }

        abstract void doRetentionLeaseAction(IndexShard var1, T var2, ActionListener<Response> var3);

        @Override
        protected Writeable.Reader<Response> getResponseReader() {
            return Response::new;
        }
    }
}

