/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.seqno;

import io.crate.common.exceptions.Exceptions;
import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.store.AlreadyClosedException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActiveShardCount;
import org.elasticsearch.action.support.replication.ReplicationRequest;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.action.support.replication.TransportWriteAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.gateway.WriteStateException;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.seqno.RetentionLeases;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardClosedException;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class RetentionLeaseSyncAction
extends TransportWriteAction<Request, Request, ReplicationResponse> {
    public static final String ACTION_NAME = "indices:admin/seq_no/retention_lease_sync";
    private static final Logger LOGGER = LogManager.getLogger(RetentionLeaseSyncAction.class);

    protected Logger getLogger() {
        return LOGGER;
    }

    @Inject
    public RetentionLeaseSyncAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, Request::new, Request::new, "management", false);
    }

    @Override
    protected void doExecute(Request request, ActionListener<ReplicationResponse> listener) {
        assert (false) : "use RetentionLeaseSyncAction#sync";
    }

    final void sync(final ShardId shardId, String primaryAllocationId, long primaryTerm, RetentionLeases retentionLeases, final ActionListener<ReplicationResponse> listener) {
        Request request = new Request(shardId, retentionLeases);
        this.transportService.sendRequest(this.clusterService.localNode(), this.transportPrimaryAction, new TransportReplicationAction.ConcreteShardRequest<Request>(request, primaryAllocationId, primaryTerm), new TransportResponseHandler<ReplicationResponse>(){
            final /* synthetic */ RetentionLeaseSyncAction this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public ReplicationResponse read(StreamInput in) throws IOException {
                return this.this$0.newResponseInstance(in);
            }

            @Override
            public String executor() {
                return "same";
            }

            @Override
            public void handleResponse(ReplicationResponse response) {
                listener.onResponse(response);
            }

            @Override
            public void handleException(TransportException e) {
                Class[] clazzes = new Class[]{IndexNotFoundException.class, AlreadyClosedException.class, IndexShardClosedException.class};
                if (Exceptions.firstCause((Throwable)e, (Class[])clazzes) == null) {
                    this.this$0.getLogger().warn((Message)new ParameterizedMessage("{} retention lease sync failed", (Object)shardId), (Throwable)e);
                }
                listener.onFailure(e);
            }
        });
    }

    @Override
    protected void shardOperationOnPrimary(Request request, IndexShard primary, ActionListener<TransportReplicationAction.PrimaryResult<Request, ReplicationResponse>> listener) {
        try {
            assert (request.waitForActiveShards().equals(ActiveShardCount.NONE)) : request.waitForActiveShards();
            Objects.requireNonNull(request);
            Objects.requireNonNull(primary);
            primary.persistRetentionLeases();
            listener.onResponse(new TransportWriteAction.WritePrimaryResult<Request, ReplicationResponse>(request, new ReplicationResponse(), null, primary));
        }
        catch (Throwable ex) {
            listener.onFailure(Exceptions.toException((Throwable)ex));
        }
    }

    protected TransportWriteAction.WriteReplicaResult shardOperationOnReplica(Request request, IndexShard replica) throws WriteStateException {
        Objects.requireNonNull(request);
        Objects.requireNonNull(replica);
        replica.updateRetentionLeasesOnReplica(request.getRetentionLeases());
        replica.persistRetentionLeases();
        return new TransportWriteAction.WriteReplicaResult(null, replica);
    }

    @Override
    public ClusterBlockLevel indexBlockLevel() {
        return null;
    }

    @Override
    protected ReplicationResponse newResponseInstance(StreamInput in) throws IOException {
        return new ReplicationResponse(in);
    }

    public static final class Request
    extends ReplicationRequest<Request> {
        private RetentionLeases retentionLeases;

        public RetentionLeases getRetentionLeases() {
            return this.retentionLeases;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.retentionLeases = new RetentionLeases(in);
        }

        public Request(ShardId shardId, RetentionLeases retentionLeases) {
            super(Objects.requireNonNull(shardId));
            this.retentionLeases = Objects.requireNonNull(retentionLeases);
            this.waitForActiveShards(ActiveShardCount.NONE);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(Objects.requireNonNull(out));
            this.retentionLeases.writeTo(out);
        }

        @Override
        public String toString() {
            return "RetentionLeaseSyncAction.Request{retentionLeases=" + String.valueOf(this.retentionLeases) + ", shardId=" + String.valueOf(this.shardId) + ", timeout=" + String.valueOf(this.timeout) + ", waitForActiveShards=" + String.valueOf(this.waitForActiveShards) + "}";
        }
    }
}

