/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.snapshots.blobstore;

import io.crate.server.xcontent.XContentParserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.Version;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ParseField;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.index.snapshots.blobstore.BlobStoreIndexShardSnapshot;
import org.elasticsearch.index.snapshots.blobstore.SnapshotFiles;
import org.jetbrains.annotations.VisibleForTesting;

public class BlobStoreIndexShardSnapshots
implements Iterable<SnapshotFiles>,
Writeable {
    public static final BlobStoreIndexShardSnapshots EMPTY = new BlobStoreIndexShardSnapshots(Collections.emptyList());
    private final List<SnapshotFiles> shardSnapshots;
    private final Map<String, BlobStoreIndexShardSnapshot.FileInfo> files;
    private final Map<String, List<BlobStoreIndexShardSnapshot.FileInfo>> physicalFiles;

    public BlobStoreIndexShardSnapshots(List<SnapshotFiles> shardSnapshots) {
        this.shardSnapshots = List.copyOf(shardSnapshots);
        HashMap<String, BlobStoreIndexShardSnapshot.FileInfo> newFiles = new HashMap<String, BlobStoreIndexShardSnapshot.FileInfo>();
        HashMap<String, List> physicalFiles = new HashMap<String, List>();
        for (SnapshotFiles snapshot : shardSnapshots) {
            for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : snapshot.indexFiles()) {
                BlobStoreIndexShardSnapshot.FileInfo oldFile = newFiles.put(fileInfo.name(), fileInfo);
                assert (oldFile == null || oldFile.isSame(fileInfo));
            }
            for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : snapshot.indexFiles()) {
                physicalFiles.computeIfAbsent(fileInfo.physicalName(), k -> new ArrayList()).add((BlobStoreIndexShardSnapshot.FileInfo)newFiles.get(fileInfo.name()));
            }
        }
        HashMap mapBuilder = new HashMap();
        for (Map.Entry entry : physicalFiles.entrySet()) {
            mapBuilder.put((String)entry.getKey(), List.copyOf((Collection)entry.getValue()));
        }
        this.physicalFiles = Collections.unmodifiableMap(mapBuilder);
        this.files = Collections.unmodifiableMap(newFiles);
    }

    private BlobStoreIndexShardSnapshots(Map<String, BlobStoreIndexShardSnapshot.FileInfo> files, List<SnapshotFiles> shardSnapshots) {
        this.shardSnapshots = shardSnapshots;
        this.files = files;
        HashMap<String, List> physicalFiles = new HashMap<String, List>();
        for (SnapshotFiles snapshot : shardSnapshots) {
            for (BlobStoreIndexShardSnapshot.FileInfo fileInfo : snapshot.indexFiles()) {
                physicalFiles.computeIfAbsent(fileInfo.physicalName(), k -> new ArrayList()).add(files.get(fileInfo.name()));
            }
        }
        HashMap mapBuilder = new HashMap();
        for (Map.Entry entry : physicalFiles.entrySet()) {
            mapBuilder.put((String)entry.getKey(), List.copyOf((Collection)entry.getValue()));
        }
        this.physicalFiles = Collections.unmodifiableMap(mapBuilder);
    }

    private BlobStoreIndexShardSnapshots(List<SnapshotFiles> shardSnapshots, Map<String, List<BlobStoreIndexShardSnapshot.FileInfo>> physicalFiles, Map<String, BlobStoreIndexShardSnapshot.FileInfo> files) {
        this.shardSnapshots = shardSnapshots;
        this.physicalFiles = physicalFiles;
        this.files = files;
    }

    public static BlobStoreIndexShardSnapshots fromStream(StreamInput in) throws IOException {
        if (in.getVersion().after(Version.V_5_10_2)) {
            Map<String, BlobStoreIndexShardSnapshot.FileInfo> filesByName = in.readMap(StreamInput::readString, BlobStoreIndexShardSnapshot.FileInfo::new);
            ArrayList<SnapshotFiles> shardSnapshots = new ArrayList<SnapshotFiles>();
            int shardSnapshotsSize = in.readVInt();
            for (int i = 0; i < shardSnapshotsSize; ++i) {
                shardSnapshots.add(new SnapshotFiles(in.readString(), in.readList(input -> (BlobStoreIndexShardSnapshot.FileInfo)filesByName.get(input.readString())), in.readOptionalString()));
            }
            return new BlobStoreIndexShardSnapshots(filesByName, shardSnapshots);
        }
        return new BlobStoreIndexShardSnapshots(in.readList(SnapshotFiles::new), in.readMap(StreamInput::readString, x -> x.readList(BlobStoreIndexShardSnapshot.FileInfo::new)), in.readMap(StreamInput::readString, BlobStoreIndexShardSnapshot.FileInfo::new));
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        if (out.getVersion().after(Version.V_5_10_2)) {
            out.writeMap(this.files, StreamOutput::writeString, (o, fileInfo) -> fileInfo.writeTo(o));
            out.writeVInt(this.shardSnapshots.size());
            for (SnapshotFiles snapshotFiles : this.shardSnapshots) {
                out.writeString(snapshotFiles.snapshot());
                out.writeCollection(snapshotFiles.indexFiles(), (o, fileInfo) -> o.writeString(fileInfo.name()));
                out.writeOptionalString(snapshotFiles.shardStateIdentifier());
            }
        } else {
            out.writeList(this.shardSnapshots);
            out.writeMap(this.physicalFiles, StreamOutput::writeString, (o, v) -> o.writeList((List<? extends Writeable>)v));
            out.writeMap(this.files, StreamOutput::writeString, (o, v) -> v.writeTo(out));
        }
    }

    public List<SnapshotFiles> snapshots() {
        return this.shardSnapshots;
    }

    @VisibleForTesting
    Map<String, BlobStoreIndexShardSnapshot.FileInfo> files() {
        return this.files;
    }

    @VisibleForTesting
    Map<String, List<BlobStoreIndexShardSnapshot.FileInfo>> physicalFiles() {
        return this.physicalFiles;
    }

    public List<BlobStoreIndexShardSnapshot.FileInfo> findPhysicalIndexFiles(String physicalName) {
        return this.physicalFiles.get(physicalName);
    }

    public BlobStoreIndexShardSnapshot.FileInfo findNameFile(String name) {
        return this.files.get(name);
    }

    @Override
    public Iterator<SnapshotFiles> iterator() {
        return this.shardSnapshots.iterator();
    }

    public static BlobStoreIndexShardSnapshots fromXContent(XContentParser parser) throws IOException {
        XContentParser.Token token = parser.currentToken();
        if (token == null) {
            token = parser.nextToken();
        }
        HashMap snapshotsMap = new HashMap();
        HashMap<String, String> historyUUIDs = new HashMap<String, String>();
        HashMap<String, BlobStoreIndexShardSnapshot.FileInfo> files = new HashMap<String, BlobStoreIndexShardSnapshot.FileInfo>();
        if (token == XContentParser.Token.START_OBJECT) {
            while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
                String currentFieldName = parser.currentName();
                token = parser.nextToken();
                if (token == XContentParser.Token.START_ARRAY) {
                    if (!ParseFields.FILES.match(currentFieldName, parser.getDeprecationHandler())) {
                        throw new ElasticsearchParseException("unknown array [{}]", currentFieldName);
                    }
                    while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                        BlobStoreIndexShardSnapshot.FileInfo fileInfo = BlobStoreIndexShardSnapshot.FileInfo.fromXContent(parser);
                        files.put(fileInfo.name(), fileInfo);
                    }
                    continue;
                }
                if (token == XContentParser.Token.START_OBJECT) {
                    if (!ParseFields.SNAPSHOTS.match(currentFieldName, parser.getDeprecationHandler())) {
                        throw new ElasticsearchParseException("unknown object [{}]", currentFieldName);
                    }
                    while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                        XContentParserUtils.ensureExpectedToken(XContentParser.Token.FIELD_NAME, token, parser);
                        String snapshot = parser.currentName();
                        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
                        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                            if (token != XContentParser.Token.FIELD_NAME) continue;
                            currentFieldName = parser.currentName();
                            if (ParseFields.FILES.match(currentFieldName, parser.getDeprecationHandler()) && parser.nextToken() == XContentParser.Token.START_ARRAY) {
                                ArrayList<String> fileNames = new ArrayList<String>();
                                while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                                    fileNames.add(parser.text());
                                }
                                snapshotsMap.put(snapshot, fileNames);
                                continue;
                            }
                            if (!ParseFields.SHARD_STATE_ID.match(currentFieldName, parser.getDeprecationHandler())) continue;
                            parser.nextToken();
                            historyUUIDs.put(snapshot, parser.text());
                        }
                    }
                    continue;
                }
                throw new ElasticsearchParseException("unexpected token [{}]", token);
            }
        }
        ArrayList<SnapshotFiles> snapshots = new ArrayList<SnapshotFiles>(snapshotsMap.size());
        for (Map.Entry entry : snapshotsMap.entrySet()) {
            ArrayList<BlobStoreIndexShardSnapshot.FileInfo> fileInfosBuilder = new ArrayList<BlobStoreIndexShardSnapshot.FileInfo>();
            for (String file : (List)entry.getValue()) {
                BlobStoreIndexShardSnapshot.FileInfo fileInfo = (BlobStoreIndexShardSnapshot.FileInfo)files.get(file);
                assert (fileInfo != null);
                fileInfosBuilder.add(fileInfo);
            }
            snapshots.add(new SnapshotFiles((String)entry.getKey(), Collections.unmodifiableList(fileInfosBuilder), (String)historyUUIDs.get(entry.getKey())));
        }
        return new BlobStoreIndexShardSnapshots(files, Collections.unmodifiableList(snapshots));
    }

    static final class ParseFields {
        static final ParseField FILES = new ParseField("files", new String[0]);
        static final ParseField SHARD_STATE_ID = new ParseField("shard_state_id", new String[0]);
        static final ParseField SNAPSHOTS = new ParseField("snapshots", new String[0]);

        ParseFields() {
        }
    }

    static final class Fields {
        static final String FILES = "files";
        static final String SNAPSHOTS = "snapshots";

        Fields() {
        }
    }
}

