/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices;

import io.crate.common.CheckedFunction;
import io.crate.common.collections.Iterables;
import io.crate.common.collections.MapBuilder;
import io.crate.common.collections.Sets;
import io.crate.common.io.IOUtils;
import io.crate.common.unit.TimeValue;
import io.crate.metadata.NodeContext;
import io.crate.metadata.RelationName;
import io.crate.metadata.Schemas;
import io.crate.metadata.doc.DocTableInfoFactory;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.lucene.search.QueryCache;
import org.apache.lucene.util.CollectionUtil;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ResourceAlreadyExistsException;
import org.elasticsearch.Version;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Priority;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.FileSystemUtils;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.AbstractRefCounted;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.common.util.concurrent.RejectableRunnable;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.env.ShardLock;
import org.elasticsearch.env.ShardLockObtainFailedException;
import org.elasticsearch.gateway.MetaStateService;
import org.elasticsearch.gateway.MetadataStateFormat;
import org.elasticsearch.index.AbstractIndexComponent;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.analysis.AnalysisRegistry;
import org.elasticsearch.index.cache.query.DisabledQueryCache;
import org.elasticsearch.index.engine.EngineFactory;
import org.elasticsearch.index.seqno.RetentionLeaseSyncer;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexingOperationListener;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndexingMemoryController;
import org.elasticsearch.indices.IndicesQueryCache;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.cluster.IndicesClusterStateService;
import org.elasticsearch.indices.recovery.PeerRecoveryTargetService;
import org.elasticsearch.indices.recovery.RecoveryState;
import org.elasticsearch.node.Node;
import org.elasticsearch.plugins.IndexStorePlugin;
import org.elasticsearch.plugins.PluginsService;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.threadpool.ThreadPool;
import org.jetbrains.annotations.Nullable;

public class IndicesService
extends AbstractLifecycleComponent
implements IndicesClusterStateService.AllocatedIndices<IndexShard, IndexService>,
IndexService.ShardStoreDeleter {
    private static final Logger LOGGER = LogManager.getLogger(IndicesService.class);
    public static final String INDICES_SHARDS_CLOSED_TIMEOUT = "indices.shards_closed_timeout";
    public static final Setting<Boolean> WRITE_DANGLING_INDICES_INFO_SETTING = Setting.boolSetting("gateway.write_dangling_indices_info", true, Setting.Property.NodeScope);
    private final ClusterService clusterService;
    private final PluginsService pluginsService;
    private final NodeEnvironment nodeEnv;
    private final TimeValue shardsClosedTimeout;
    private final AnalysisRegistry analysisRegistry;
    private final IndexScopedSettings indexScopedSettings;
    private final ThreadPool threadPool;
    private final CircuitBreakerService circuitBreakerService;
    private final BigArrays bigArrays;
    private final Settings settings;
    private volatile Map<String, IndexService> indices = Collections.emptyMap();
    private final Map<Index, List<PendingDelete>> pendingDeletes = new HashMap<Index, List<PendingDelete>>();
    private final AtomicInteger numUncompletedDeletes = new AtomicInteger();
    private final NodeContext nodeContext;
    private final IndexingMemoryController indexingMemoryController;
    private final QueryCache indicesQueryCache;
    private final MetaStateService metaStateService;
    private final Collection<Function<IndexSettings, Optional<EngineFactory>>> engineFactoryProviders;
    private final Map<String, IndexStorePlugin.DirectoryFactory> directoryFactories;
    final AbstractRefCounted indicesRefCount;
    private final CountDownLatch closeLatch = new CountDownLatch(1);
    @Nullable
    private final EsThreadPoolExecutor danglingIndicesThreadPoolExecutor;
    private final Set<Index> danglingIndicesToWrite = Sets.newConcurrentHashSet();
    private final boolean nodeWriteDanglingIndicesInfo;
    private final Map<ShardId, CompletableFuture<IndexShard>> pendingShardCreations = new ConcurrentHashMap<ShardId, CompletableFuture<IndexShard>>();
    private final DocTableInfoFactory tableFactory;
    private static final String DANGLING_INDICES_UPDATE_THREAD_NAME = "DanglingIndices#updateTask";
    private final IndexDeletionAllowedPredicate DEFAULT_INDEX_DELETION_PREDICATE = (index, indexSettings) -> this.canDeleteIndexContents(index, indexSettings);
    private final IndexDeletionAllowedPredicate ALWAYS_TRUE = (index, indexSettings) -> true;

    @Override
    protected void doStart() {
    }

    public IndicesService(NodeContext nodeContext, Settings settings, ClusterService clusterService, PluginsService pluginsService, NodeEnvironment nodeEnv, final AnalysisRegistry analysisRegistry, ThreadPool threadPool, IndexScopedSettings indexScopedSettings, CircuitBreakerService circuitBreakerService, BigArrays bigArrays, MetaStateService metaStateService, Collection<Function<IndexSettings, Optional<EngineFactory>>> engineFactoryProviders, Map<String, IndexStorePlugin.DirectoryFactory> directoryFactories) {
        this.settings = settings;
        this.clusterService = clusterService;
        this.threadPool = threadPool;
        this.pluginsService = pluginsService;
        this.nodeEnv = nodeEnv;
        this.shardsClosedTimeout = settings.getAsTime(INDICES_SHARDS_CLOSED_TIMEOUT, new TimeValue(1L, TimeUnit.DAYS));
        this.analysisRegistry = analysisRegistry;
        this.indicesQueryCache = IndicesQueryCache.createCache(settings);
        this.indexingMemoryController = new IndexingMemoryController(settings, threadPool, () -> Iterables.concat((Iterable)this).iterator());
        this.indexScopedSettings = indexScopedSettings;
        this.circuitBreakerService = circuitBreakerService;
        this.bigArrays = bigArrays;
        this.metaStateService = metaStateService;
        this.engineFactoryProviders = engineFactoryProviders;
        this.nodeContext = nodeContext;
        this.tableFactory = new DocTableInfoFactory(nodeContext);
        for (String indexStoreType : directoryFactories.keySet()) {
            if (!IndexModule.isBuiltinType(indexStoreType)) continue;
            throw new IllegalStateException("registered index store type [" + indexStoreType + "] conflicts with a built-in type");
        }
        this.directoryFactories = directoryFactories;
        this.indicesRefCount = new AbstractRefCounted(this, "indices"){
            final /* synthetic */ IndicesService this$0;
            {
                this.this$0 = this$0;
                super(name);
            }

            @Override
            protected void closeInternal() {
                try {
                    IOUtils.close((Closeable[])new Closeable[]{analysisRegistry, this.this$0.indexingMemoryController});
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                finally {
                    this.this$0.closeLatch.countDown();
                }
            }
        };
        String nodeName = Objects.requireNonNull(Node.NODE_NAME_SETTING.get(settings));
        this.nodeWriteDanglingIndicesInfo = WRITE_DANGLING_INDICES_INFO_SETTING.get(settings);
        this.danglingIndicesThreadPoolExecutor = this.nodeWriteDanglingIndicesInfo ? EsExecutors.newScaling(nodeName + "/DanglingIndices#updateTask", 1, 1, 0L, TimeUnit.MILLISECONDS, EsExecutors.daemonThreadFactory(nodeName, DANGLING_INDICES_UPDATE_THREAD_NAME)) : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        ThreadPool.terminate(this.danglingIndicesThreadPoolExecutor, 10L, TimeUnit.SECONDS);
        ExecutorService indicesStopExecutor = Executors.newFixedThreadPool(5, EsExecutors.daemonThreadFactory(this.settings, "indices_shutdown"));
        Set indices = this.indices.values().stream().map(AbstractIndexComponent::index).collect(Collectors.toSet());
        CountDownLatch latch = new CountDownLatch(indices.size());
        for (Index index : indices) {
            indicesStopExecutor.execute(() -> {
                try {
                    this.removeIndex(index, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.NO_LONGER_ASSIGNED, "shutdown");
                }
                finally {
                    latch.countDown();
                }
            });
        }
        try {
            if (!latch.await(this.shardsClosedTimeout.seconds(), TimeUnit.SECONDS)) {
                LOGGER.warn("Not all shards are closed yet, waited {}sec - stopping service", (Object)this.shardsClosedTimeout.seconds());
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            indicesStopExecutor.shutdown();
        }
    }

    @Override
    protected void doClose() {
        this.indicesRefCount.decRef();
    }

    public boolean awaitClose(long timeout, TimeUnit timeUnit) throws InterruptedException {
        return this.closeLatch.await(timeout, timeUnit);
    }

    private void ensureChangesAllowed() {
        if (!this.lifecycle.started()) {
            throw new IllegalStateException("Can't make changes to indices service, node is closed");
        }
    }

    @Override
    public Iterator<IndexService> iterator() {
        return this.indices.values().iterator();
    }

    public boolean hasIndex(Index index) {
        return this.indices.containsKey(index.getUUID());
    }

    @Override
    @Nullable
    public IndexService indexService(Index index) {
        return this.indices.get(index.getUUID());
    }

    public IndexService indexServiceSafe(Index index) {
        IndexService indexService = this.indices.get(index.getUUID());
        if (indexService == null) {
            throw new IndexNotFoundException(index);
        }
        assert (indexService.indexUUID().equals(index.getUUID())) : "uuid mismatch local: " + indexService.indexUUID() + " incoming: " + index.getUUID();
        return indexService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized IndexService createIndex(IndexMetadata indexMetadata, List<IndexEventListener> builtInListeners, boolean writeDanglingIndices) throws IOException {
        this.ensureChangesAllowed();
        if (indexMetadata.getIndexUUID().equals("_na_")) {
            throw new IllegalArgumentException("index must have a real UUID found value: [" + indexMetadata.getIndexUUID() + "]");
        }
        Index index = indexMetadata.getIndex();
        if (this.hasIndex(index)) {
            throw new ResourceAlreadyExistsException(index);
        }
        ArrayList<IndexEventListener> finalListeners = new ArrayList<IndexEventListener>(builtInListeners);
        IndexEventListener onStoreClose = new IndexEventListener(){

            @Override
            public void onStoreCreated(ShardId shardId) {
                IndicesService.this.indicesRefCount.incRef();
            }

            @Override
            public void onStoreClosed(ShardId shardId) {
                IndicesService.this.indicesRefCount.decRef();
            }
        };
        finalListeners.add(onStoreClose);
        IndexService indexService = this.createIndexService(IndexService.IndexCreationContext.CREATE_INDEX, indexMetadata, this.indicesQueryCache, finalListeners, this.indexingMemoryController);
        boolean success = false;
        try {
            if (writeDanglingIndices && this.nodeWriteDanglingIndicesInfo) {
                indexService.addMetadataListener(imd -> this.updateDanglingIndicesInfo(index));
            }
            indexService.getIndexEventListener().afterIndexCreated(indexService);
            this.indices = MapBuilder.newMapBuilder(this.indices).put((Object)index.getUUID(), (Object)indexService).immutableMap();
            if (writeDanglingIndices) {
                if (this.nodeWriteDanglingIndicesInfo) {
                    this.updateDanglingIndicesInfo(index);
                } else {
                    indexService.deleteDanglingIndicesInfo();
                }
            }
            success = true;
            IndexService indexService2 = indexService;
            return indexService2;
        }
        finally {
            if (!success) {
                indexService.close("plugins_failed", true);
            }
        }
    }

    public <T, E extends Exception> T withTempIndexService(IndexMetadata indexMetadata, CheckedFunction<IndexService, T, E> indexServiceConsumer) throws IOException, E {
        final Index index = indexMetadata.getIndex();
        if (this.hasIndex(index)) {
            throw new ResourceAlreadyExistsException(index);
        }
        List<IndexEventListener> finalListeners = Collections.singletonList(new IndexEventListener(){

            @Override
            public void beforeIndexShardCreated(ShardId shardId, Settings indexSettings) {
                assert (false) : "temp index should not trigger shard creation";
                throw new ElasticsearchException("temp index should not trigger shard creation [{}]", index);
            }

            @Override
            public void onStoreCreated(ShardId shardId) {
                assert (false) : "temp index should not trigger store creation";
                throw new ElasticsearchException("temp index should not trigger store creation [{}]", index);
            }
        });
        IndexService indexService = this.createIndexService(IndexService.IndexCreationContext.CREATE_INDEX, indexMetadata, this.indicesQueryCache, finalListeners, this.indexingMemoryController);
        try (Closeable dummy = () -> indexService.close("temp", false);){
            Object object = indexServiceConsumer.apply((Object)indexService);
            return (T)object;
        }
    }

    private synchronized IndexService createIndexService(IndexService.IndexCreationContext indexCreationContext, IndexMetadata indexMetadata, QueryCache indicesQueryCache, List<IndexEventListener> builtInListeners, IndexingOperationListener ... indexingOperationListeners) throws IOException {
        Settings safeSettings;
        this.indexScopedSettings.validate(indexMetadata.getSettings(), true, true, true);
        IndexMetadata safeMetadata = indexMetadata;
        Version versionCreated = IndexMetadata.SETTING_INDEX_VERSION_CREATED.get(indexMetadata.getSettings());
        if (versionCreated.before(Version.CURRENT) && (safeSettings = this.indexScopedSettings.removeUnknownSettings(indexMetadata.getSettings())) != indexMetadata.getSettings()) {
            safeMetadata = IndexMetadata.builder(indexMetadata).settings(safeSettings).build();
        }
        IndexSettings idxSettings = new IndexSettings(safeMetadata, this.settings, this.indexScopedSettings);
        LOGGER.debug("creating Index [{}], shards [{}]/[{}] - reason [{}]", (Object)safeMetadata.getIndex(), (Object)idxSettings.getNumberOfShards(), (Object)idxSettings.getNumberOfReplicas(), (Object)indexCreationContext);
        IndexModule indexModule = new IndexModule(idxSettings, this.analysisRegistry, this.engineFactoryProviders, this.directoryFactories);
        for (IndexingOperationListener operationListener : indexingOperationListeners) {
            indexModule.addIndexOperationListener(operationListener);
        }
        this.pluginsService.onIndexModule(indexModule);
        for (IndexEventListener listener : builtInListeners) {
            indexModule.addIndexEventListener(listener);
        }
        String indexName = safeMetadata.getIndex().getName();
        Schemas schemas = this.nodeContext.schemas();
        return indexModule.newIndexService(this.nodeContext, indexCreationContext, this.nodeEnv, this, this.circuitBreakerService, this.bigArrays, this.threadPool, indicesQueryCache, () -> schemas.getTableInfo(RelationName.fromIndexName(indexName)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void verifyIndexMetadata(IndexMetadata metadata, IndexMetadata metadataUpdate) throws IOException {
        ArrayList<Closeable> closeables = new ArrayList<Closeable>();
        try {
            IndexService service = this.createIndexService(IndexService.IndexCreationContext.METADATA_VERIFICATION, metadata, DisabledQueryCache.instance(), Collections.emptyList(), new IndexingOperationListener[0]);
            closeables.add(() -> service.close("metadata verification", false));
            if (!metadata.equals(metadataUpdate)) {
                this.tableFactory.create(metadataUpdate);
                service.updateMetadata(metadata, metadataUpdate);
            }
        }
        finally {
            IOUtils.close(closeables);
        }
    }

    private void createShard(CompletableFuture<IndexShard> result, ClusterState originalState, IndexService indexService, ShardRouting shardRouting, Consumer<ShardId> globalCheckpointSyncer, RetentionLeaseSyncer retentionLeaseSyncer, @Nullable Iterator<TimeValue> backoff) {
        ShardId shardId = shardRouting.shardId();
        try {
            IndexShard indexShard = indexService.createShard(shardRouting, globalCheckpointSyncer, retentionLeaseSyncer);
            result.complete(indexShard);
        }
        catch (ShardLockObtainFailedException e) {
            if (e.getCause() instanceof InterruptedException || Thread.currentThread().isInterrupted()) {
                result.completeExceptionally(e);
                return;
            }
            int firstDelayInMS = 50;
            int maxRetries = 800;
            int maxDelayInMS = 5000;
            Iterator<TimeValue> backoffIt = backoff == null ? BackoffPolicy.exponentialBackoff(firstDelayInMS, maxRetries, maxDelayInMS).iterator() : backoff;
            TimeValue delay = backoffIt.next();
            if (LOGGER.isWarnEnabled() && delay.millis() == (long)maxDelayInMS) {
                LOGGER.warn("Repeated attempts to acquire shardLock for {}. Retrying again in {}", (Object)shardId, (Object)delay);
            } else if (LOGGER.isDebugEnabled() && delay.millis() > 150L) {
                LOGGER.debug("Repeated attempts to acquire shardLock for {}. Retrying again in {}", (Object)shardId, (Object)delay);
            }
            Runnable retry = () -> this.clusterService.getClusterApplierService().runOnApplierThread("create-shard", state -> {
                ShardRouting currentRouting = shardRouting;
                if (!state.stateUUID().equals(originalState.stateUUID())) {
                    LOGGER.debug("Cluster state changed from {} to {} before shard creation finished", (Object)originalState.stateUUID(), (Object)state.stateUUID());
                    RoutingNode localRoutingNode = state.getRoutingNodes().node(shardRouting.currentNodeId());
                    currentRouting = localRoutingNode.getByShardId(shardId);
                    if (currentRouting == null) {
                        String msg = "Shard routing for " + String.valueOf(shardId) + " is not available while retrying to create the shard.";
                        LOGGER.debug(msg);
                        result.completeExceptionally(new IllegalStateException(msg));
                        return;
                    }
                    if (!currentRouting.initializing()) {
                        String msg = "Shard " + String.valueOf(shardId) + " state changed and is not INITIALIZING while retrying to create the shard.";
                        LOGGER.debug(msg);
                        result.completeExceptionally(new IllegalStateException(msg));
                        return;
                    }
                }
                this.createShard(result, (ClusterState)state, indexService, currentRouting, globalCheckpointSyncer, retentionLeaseSyncer, backoffIt);
            }, (string, e1) -> result.completeExceptionally(e1), Priority.NORMAL);
            this.threadPool.schedule(retry, delay, "same");
        }
        catch (IOException e) {
            result.completeExceptionally(e);
        }
    }

    @Override
    public CompletableFuture<IndexShard> createShard(ClusterState state, ShardRouting shardRouting, RecoveryState recoveryState, PeerRecoveryTargetService recoveryTargetService, PeerRecoveryTargetService.RecoveryListener recoveryListener, RepositoriesService repositoriesService, Consumer<IndexShard.ShardFailure> onShardFailure, Consumer<ShardId> globalCheckpointSyncer, RetentionLeaseSyncer retentionLeaseSyncer) throws IOException {
        Objects.requireNonNull(retentionLeaseSyncer);
        this.ensureChangesAllowed();
        IndexService indexService = this.indexService(shardRouting.index());
        ShardId shardId = shardRouting.shardId();
        CompletableFuture<IndexShard> future = new CompletableFuture<IndexShard>();
        CompletableFuture<IndexShard> pending = this.pendingShardCreations.putIfAbsent(shardId, future);
        if (pending != null) {
            return pending;
        }
        try {
            this.createShard(future, state, indexService, shardRouting, globalCheckpointSyncer, retentionLeaseSyncer, null);
        }
        catch (Throwable t) {
            this.pendingShardCreations.remove(shardId);
            throw t;
        }
        return ((CompletableFuture)future.whenComplete((ignored, err) -> this.pendingShardCreations.remove(shardId))).thenCompose(indexShard -> {
            indexShard.addShardFailureCallback(onShardFailure);
            indexShard.startRecovery(recoveryState, recoveryTargetService, recoveryListener, repositoriesService, this);
            return CompletableFuture.completedFuture(indexShard);
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeIndex(Index index, IndicesClusterStateService.AllocatedIndices.IndexRemovalReason reason, String extraInfo) {
        String indexName = index.getName();
        try {
            IndexEventListener listener;
            IndexService indexService;
            IndicesService indicesService = this;
            synchronized (indicesService) {
                if (!this.hasIndex(index)) {
                    return;
                }
                LOGGER.debug("[{}] closing ... (reason [{}])", (Object)indexName, (Object)reason);
                HashMap<String, IndexService> newIndices = new HashMap<String, IndexService>(this.indices);
                indexService = (IndexService)newIndices.remove(index.getUUID());
                assert (indexService != null) : "IndexService is null for index: " + String.valueOf(index);
                this.indices = Collections.unmodifiableMap(newIndices);
                listener = indexService.getIndexEventListener();
            }
            listener.beforeIndexRemoved(indexService, reason);
            LOGGER.debug("{} closing index service (reason [{}][{}])", (Object)index, (Object)reason, (Object)extraInfo);
            indexService.close(extraInfo, reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.DELETED);
            LOGGER.debug("{} closed... (reason [{}][{}])", (Object)index, (Object)reason, (Object)extraInfo);
            IndexSettings indexSettings = indexService.getIndexSettings();
            listener.afterIndexRemoved(indexService.index(), indexSettings, reason);
            if (reason == IndicesClusterStateService.AllocatedIndices.IndexRemovalReason.DELETED) {
                this.deleteIndexStore(extraInfo, indexService.index(), indexSettings);
            }
        }
        catch (Exception e) {
            LOGGER.warn(() -> new ParameterizedMessage("failed to remove index {} ([{}][{}])", new Object[]{index, reason, extraInfo}), (Throwable)e);
        }
    }

    public CircuitBreakerService getCircuitBreakerService() {
        return this.circuitBreakerService;
    }

    @Override
    public void deleteUnassignedIndex(String reason, IndexMetadata metadata, ClusterState clusterState) {
        if (this.nodeEnv.hasNodeFile()) {
            Index index = metadata.getIndex();
            try {
                if (clusterState.metadata().hasIndex(index)) {
                    IndexMetadata indexMetadata = clusterState.metadata().index(index);
                    throw new IllegalStateException("Can't delete unassigned index store for [" + indexMetadata.getIndex().getName() + "] - it's still part of the cluster state [" + indexMetadata.getIndexUUID() + "] [" + metadata.getIndexUUID() + "]");
                }
                this.deleteIndexStore(reason, metadata);
            }
            catch (Exception e) {
                LOGGER.warn(() -> new ParameterizedMessage("[{}] failed to delete unassigned index (reason [{}])", (Object)metadata.getIndex(), (Object)reason), (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteIndexStore(String reason, IndexMetadata metadata) throws IOException {
        if (this.nodeEnv.hasNodeFile()) {
            IndicesService indicesService = this;
            synchronized (indicesService) {
                Index index = metadata.getIndex();
                if (this.hasIndex(index)) {
                    String localUUid = this.indexService(index).indexUUID();
                    throw new IllegalStateException("Can't delete index store for [" + index.getName() + "] - it's still part of the indices service [" + localUUid + "] [" + metadata.getIndexUUID() + "]");
                }
            }
            IndexSettings indexSettings = this.buildIndexSettings(metadata);
            this.deleteIndexStore(reason, indexSettings.getIndex(), indexSettings);
        }
    }

    private void deleteIndexStore(String reason, Index index, IndexSettings indexSettings) throws IOException {
        this.deleteIndexStoreIfDeletionAllowed(reason, index, indexSettings, this.DEFAULT_INDEX_DELETION_PREDICATE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deleteIndexStoreIfDeletionAllowed(String reason, Index index, IndexSettings indexSettings, IndexDeletionAllowedPredicate predicate) throws IOException {
        boolean success = false;
        try {
            LOGGER.debug("{} deleting index store reason [{}]", (Object)index, (Object)reason);
            if (predicate.apply(index, indexSettings)) {
                this.nodeEnv.deleteIndexDirectorySafe(index, 0L, indexSettings);
            }
            success = true;
        }
        catch (ShardLockObtainFailedException ex) {
            LOGGER.debug(() -> new ParameterizedMessage("{} failed to delete index store - at least one shards is still locked", (Object)index), (Throwable)ex);
        }
        catch (Exception ex) {
            LOGGER.warn(() -> new ParameterizedMessage("{} failed to delete index", (Object)index), (Throwable)ex);
        }
        finally {
            if (!success) {
                this.addPendingDelete(index, indexSettings);
            }
            MetadataStateFormat.deleteMetaState(this.nodeEnv.indexPaths(index));
        }
    }

    @Override
    public void deleteShardStore(String reason, ShardLock lock, IndexSettings indexSettings) throws IOException {
        ShardId shardId = lock.getShardId();
        LOGGER.trace("{} deleting shard reason [{}]", (Object)shardId, (Object)reason);
        this.nodeEnv.deleteShardDirectoryUnderLock(lock, indexSettings);
    }

    public void deleteShardStore(String reason, ShardId shardId, ClusterState clusterState) throws IOException, ShardLockObtainFailedException {
        IndexMetadata metadata = clusterState.metadata().indices().get(shardId.getIndexName());
        IndexSettings indexSettings = this.buildIndexSettings(metadata);
        ShardDeletionCheckResult shardDeletionCheckResult = this.canDeleteShardContent(shardId, indexSettings);
        if (shardDeletionCheckResult != ShardDeletionCheckResult.FOLDER_FOUND_CAN_DELETE) {
            throw new IllegalStateException("Can't delete shard " + String.valueOf(shardId) + " (cause: " + String.valueOf((Object)shardDeletionCheckResult) + ")");
        }
        this.nodeEnv.deleteShardDirectorySafe(shardId, indexSettings);
        LOGGER.debug("{} deleted shard reason [{}]", (Object)shardId, (Object)reason);
        if (this.canDeleteIndexContents(shardId.getIndex(), indexSettings)) {
            if (this.nodeEnv.findAllShardIds(shardId.getIndex()).isEmpty()) {
                try {
                    this.deleteIndexStore("no longer used", metadata);
                }
                catch (Exception e) {
                    throw new ElasticsearchException("failed to delete unused index after deleting its last shard (" + String.valueOf(shardId) + ")", (Throwable)e, new Object[0]);
                }
            } else {
                LOGGER.trace("[{}] still has shard stores, leaving as is", (Object)shardId.getIndex());
            }
        }
    }

    public boolean canDeleteIndexContents(Index index, IndexSettings indexSettings) {
        IndexService indexService = this.indexService(index);
        return indexService == null && this.nodeEnv.hasNodeFile();
    }

    @Override
    @Nullable
    public IndexMetadata verifyIndexIsDeleted(Index index, ClusterState clusterState) {
        if (clusterState.metadata().index(index) != null) {
            throw new IllegalStateException("Cannot delete index [" + String.valueOf(index) + "], it is still part of the cluster state.");
        }
        if (this.nodeEnv.hasNodeFile() && FileSystemUtils.exists(this.nodeEnv.indexPaths(index))) {
            IndexMetadata metadata;
            try {
                metadata = this.metaStateService.loadIndexState(index);
                if (metadata == null) {
                    return null;
                }
            }
            catch (Exception e) {
                LOGGER.warn(() -> new ParameterizedMessage("[{}] failed to load state file from a stale deleted index, folders will be left on disk", (Object)index), (Throwable)e);
                return null;
            }
            IndexSettings indexSettings = this.buildIndexSettings(metadata);
            try {
                this.deleteIndexStoreIfDeletionAllowed("stale deleted index", index, indexSettings, this.ALWAYS_TRUE);
            }
            catch (Exception e) {
                LOGGER.warn(() -> new ParameterizedMessage("[{}] failed to delete index on disk", (Object)metadata.getIndex()), (Throwable)e);
            }
            return metadata;
        }
        return null;
    }

    public ShardDeletionCheckResult canDeleteShardContent(ShardId shardId, IndexSettings indexSettings) {
        assert (shardId.getIndex().equals(indexSettings.getIndex()));
        IndexService indexService = this.indexService(shardId.getIndex());
        if (this.nodeEnv.hasNodeFile()) {
            boolean isAllocated;
            boolean bl = isAllocated = indexService != null && indexService.hasShard(shardId.id());
            if (isAllocated) {
                return ShardDeletionCheckResult.STILL_ALLOCATED;
            }
            if (indexSettings.hasCustomDataPath()) {
                return Files.exists(this.nodeEnv.resolveCustomLocation(indexSettings.customDataPath(), shardId), new LinkOption[0]) ? ShardDeletionCheckResult.FOLDER_FOUND_CAN_DELETE : ShardDeletionCheckResult.NO_FOLDER_FOUND;
            }
            return FileSystemUtils.exists(this.nodeEnv.availableShardPaths(shardId)) ? ShardDeletionCheckResult.FOLDER_FOUND_CAN_DELETE : ShardDeletionCheckResult.NO_FOLDER_FOUND;
        }
        return ShardDeletionCheckResult.NO_LOCAL_STORAGE;
    }

    private IndexSettings buildIndexSettings(IndexMetadata metadata) {
        return new IndexSettings(metadata, this.settings);
    }

    @Override
    public void addPendingDelete(ShardId shardId, IndexSettings settings) {
        if (shardId == null) {
            throw new IllegalArgumentException("shardId must not be null");
        }
        if (settings == null) {
            throw new IllegalArgumentException("settings must not be null");
        }
        PendingDelete pendingDelete = new PendingDelete(shardId, settings);
        this.addPendingDelete(shardId.getIndex(), pendingDelete);
    }

    public void addPendingDelete(Index index, IndexSettings settings) {
        PendingDelete pendingDelete = new PendingDelete(index, settings);
        this.addPendingDelete(index, pendingDelete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addPendingDelete(Index index, PendingDelete pendingDelete) {
        Map<Index, List<PendingDelete>> map = this.pendingDeletes;
        synchronized (map) {
            List<PendingDelete> list = this.pendingDeletes.get(index);
            if (list == null) {
                list = new ArrayList<PendingDelete>();
                this.pendingDeletes.put(index, list);
            }
            list.add(pendingDelete);
            this.numUncompletedDeletes.incrementAndGet();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void processPendingDeletes(Index index, IndexSettings indexSettings, TimeValue timeout) throws IOException, InterruptedException, ShardLockObtainFailedException {
        block20: {
            LOGGER.debug("{} processing pending deletes", (Object)index);
            long startTimeNS = System.nanoTime();
            List<ShardLock> shardLocks = this.nodeEnv.lockAllForIndex(index, indexSettings, "process pending deletes", timeout.millis());
            int numRemoved = 0;
            try {
                List<PendingDelete> remove;
                HashMap<ShardId, ShardLock> locks = new HashMap<ShardId, ShardLock>();
                for (ShardLock shardLock : shardLocks) {
                    locks.put(shardLock.getShardId(), shardLock);
                }
                Map<Index, List<PendingDelete>> map = this.pendingDeletes;
                synchronized (map) {
                    remove = this.pendingDeletes.remove(index);
                }
                if (remove == null || remove.isEmpty()) break block20;
                numRemoved = remove.size();
                CollectionUtil.timSort(remove);
                long l = 10000L;
                long sleepTime = 10L;
                do {
                    if (remove.isEmpty()) {
                        break;
                    }
                    Iterator<PendingDelete> iterator = remove.iterator();
                    while (iterator.hasNext()) {
                        PendingDelete delete = iterator.next();
                        if (delete.deleteIndex) {
                            assert (delete.shardId == -1);
                            LOGGER.debug("{} deleting index store reason [{}]", (Object)index, (Object)"pending delete");
                            try {
                                this.nodeEnv.deleteIndexDirectoryUnderLock(index, indexSettings);
                                iterator.remove();
                            }
                            catch (IOException ex) {
                                LOGGER.debug(() -> new ParameterizedMessage("{} retry pending delete", (Object)index), (Throwable)ex);
                            }
                            continue;
                        }
                        assert (delete.shardId != -1);
                        ShardLock shardLock = (ShardLock)locks.get(new ShardId(delete.index, delete.shardId));
                        if (shardLock != null) {
                            try {
                                this.deleteShardStore("pending delete", shardLock, delete.settings);
                                iterator.remove();
                            }
                            catch (IOException ex) {
                                LOGGER.debug(() -> new ParameterizedMessage("{} retry pending delete", (Object)shardLock.getShardId()), (Throwable)ex);
                            }
                            continue;
                        }
                        LOGGER.warn("{} no shard lock for pending delete", (Object)delete.shardId);
                        iterator.remove();
                    }
                    if (remove.isEmpty()) continue;
                    LOGGER.warn("{} still pending deletes present for shards {} - retrying", (Object)index, (Object)remove.toString());
                    Thread.sleep(sleepTime);
                    sleepTime = Math.min(10000L, sleepTime * 2L);
                    LOGGER.debug("{} schedule pending delete retry after {} ms", (Object)index, (Object)sleepTime);
                } while (System.nanoTime() - startTimeNS < timeout.nanos());
            }
            finally {
                IOUtils.close(shardLocks);
                if (numRemoved > 0) {
                    int remainingUncompletedDeletes = this.numUncompletedDeletes.addAndGet(-numRemoved);
                    assert (remainingUncompletedDeletes >= 0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int numPendingDeletes(Index index) {
        Map<Index, List<PendingDelete>> map = this.pendingDeletes;
        synchronized (map) {
            List<PendingDelete> deleteList = this.pendingDeletes.get(index);
            if (deleteList == null) {
                return 0;
            }
            return deleteList.size();
        }
    }

    public boolean hasUncompletedPendingDeletes() {
        return this.numUncompletedDeletes.get() > 0;
    }

    public AnalysisRegistry getAnalysis() {
        return this.analysisRegistry;
    }

    public ByteSizeValue getTotalIndexingBufferBytes() {
        return this.indexingMemoryController.indexingBufferSize();
    }

    private void updateDanglingIndicesInfo(final Index index) {
        assert (DiscoveryNode.isDataNode(this.settings)) : "dangling indices information should only be persisted on data nodes";
        assert (this.nodeWriteDanglingIndicesInfo) : "writing dangling indices info is not enabled";
        assert (this.danglingIndicesThreadPoolExecutor != null) : "executor for dangling indices info is not available";
        if (this.danglingIndicesToWrite.add(index)) {
            LOGGER.trace("triggered dangling indices update for {}", (Object)index);
            final long triggeredTimeMillis = this.threadPool.relativeTimeInMillis();
            try {
                this.danglingIndicesThreadPoolExecutor.execute(new RejectableRunnable(){
                    final /* synthetic */ IndicesService this$0;
                    {
                        this.this$0 = this$0;
                    }

                    @Override
                    public void onFailure(Exception e) {
                        LOGGER.warn(() -> new ParameterizedMessage("failed to write dangling indices state for index {}", (Object)index), (Throwable)e);
                    }

                    @Override
                    public void doRun() {
                        boolean exists = this.this$0.danglingIndicesToWrite.remove(index);
                        assert (exists) : "removed non-existing item for " + String.valueOf(index);
                        IndexService indexService = this.this$0.indices.get(index.getUUID());
                        if (indexService != null) {
                            long executedTimeMillis = this.this$0.threadPool.relativeTimeInMillis();
                            LOGGER.trace("writing out dangling indices state for index {}, triggered {} ago", (Object)index, (Object)TimeValue.timeValueMillis((long)Math.min(0L, executedTimeMillis - triggeredTimeMillis)));
                            indexService.writeDanglingIndicesInfo();
                            long completedTimeMillis = this.this$0.threadPool.relativeTimeInMillis();
                            LOGGER.trace("writing out of dangling indices state for index {} completed after {}", (Object)index, (Object)TimeValue.timeValueMillis((long)Math.min(0L, completedTimeMillis - executedTimeMillis)));
                        } else {
                            LOGGER.trace("omit writing dangling indices state for index {} as index is deallocated on this node", (Object)index);
                        }
                    }
                });
            }
            catch (EsRejectedExecutionException e) {
                assert (this.danglingIndicesThreadPoolExecutor.isShutdown());
            }
        } else {
            LOGGER.trace("dangling indices update already pending for {}", (Object)index);
        }
    }

    public boolean allPendingDanglingIndicesWritten() {
        return !this.nodeWriteDanglingIndicesInfo || this.danglingIndicesToWrite.isEmpty() && this.danglingIndicesThreadPoolExecutor.getActiveCount() == 0;
    }

    @FunctionalInterface
    static interface IndexDeletionAllowedPredicate {
        public boolean apply(Index var1, IndexSettings var2);
    }

    public static enum ShardDeletionCheckResult {
        FOLDER_FOUND_CAN_DELETE,
        STILL_ALLOCATED,
        NO_FOLDER_FOUND,
        NO_LOCAL_STORAGE;

    }

    private static final class PendingDelete
    implements Comparable<PendingDelete> {
        final Index index;
        final int shardId;
        final IndexSettings settings;
        final boolean deleteIndex;

        PendingDelete(ShardId shardId, IndexSettings settings) {
            this.index = shardId.getIndex();
            this.shardId = shardId.id();
            this.settings = settings;
            this.deleteIndex = false;
        }

        PendingDelete(Index index, IndexSettings settings) {
            this.index = index;
            this.shardId = -1;
            this.settings = settings;
            this.deleteIndex = true;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("[").append(this.index).append("]");
            if (this.shardId != -1) {
                sb.append("[").append(this.shardId).append("]");
            }
            return sb.toString();
        }

        @Override
        public int compareTo(PendingDelete o) {
            return Integer.compare(this.shardId, o.shardId);
        }
    }
}

