/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.breaker;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.breaker.ChildMemoryCircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreaker;
import org.elasticsearch.common.breaker.CircuitBreakingException;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.indices.breaker.BreakerSettings;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.indices.breaker.CircuitBreakerStats;

public class HierarchyCircuitBreakerService
extends CircuitBreakerService {
    private static final Logger LOGGER = LogManager.getLogger(HierarchyCircuitBreakerService.class);
    private static final MemoryMXBean MEMORY_MX_BEAN = ManagementFactory.getMemoryMXBean();
    private static final double PARENT_BREAKER_ESCAPE_HATCH_PERCENTAGE = 0.3;
    private final ConcurrentMap<String, ChildMemoryCircuitBreaker> breakers = new ConcurrentHashMap<String, ChildMemoryCircuitBreaker>();
    public static final Setting<ByteSizeValue> TOTAL_CIRCUIT_BREAKER_LIMIT_SETTING = Setting.memorySizeSetting("indices.breaker.total.limit", "95%", Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Exposed);
    public static final Setting<ByteSizeValue> REQUEST_CIRCUIT_BREAKER_LIMIT_SETTING = Setting.memorySizeSetting("indices.breaker.request.limit", "60%", Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Exposed);
    public static final Setting<ByteSizeValue> IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_LIMIT_SETTING = Setting.memorySizeSetting("network.breaker.inflight_requests.limit", "100%", Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final String QUERY = "query";
    public static final Setting<ByteSizeValue> QUERY_CIRCUIT_BREAKER_LIMIT_SETTING = Setting.memorySizeSetting("indices.breaker.query.limit", "60%", Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Exposed);
    public static final String JOBS_LOG = "jobs_log";
    public static final Setting<ByteSizeValue> JOBS_LOG_CIRCUIT_BREAKER_LIMIT_SETTING = Setting.memorySizeSetting("stats.breaker.log.jobs.limit", "5%", Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Exposed);
    public static final String OPERATIONS_LOG = "operations_log";
    public static final Setting<ByteSizeValue> OPERATIONS_LOG_CIRCUIT_BREAKER_LIMIT_SETTING = Setting.memorySizeSetting("stats.breaker.log.operations.limit", "5%", Setting.Property.Dynamic, Setting.Property.NodeScope, Setting.Property.Exposed);
    public static final String BREAKING_EXCEPTION_MESSAGE = "[query] Data too large, data for [%s] would be larger than limit of [%d/%s]";
    private volatile BreakerSettings queryBreakerSettings;
    private volatile BreakerSettings logJobsBreakerSettings;
    private volatile BreakerSettings logOperationsBreakerSettings;
    private volatile BreakerSettings parentSettings;
    private volatile BreakerSettings inFlightRequestsSettings;
    private volatile BreakerSettings requestSettings;
    private final AtomicLong parentTripCount = new AtomicLong(0L);

    public HierarchyCircuitBreakerService(Settings settings, ClusterSettings clusterSettings) {
        this.inFlightRequestsSettings = new BreakerSettings("in_flight_requests", IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_LIMIT_SETTING.get(settings).getBytes());
        this.requestSettings = new BreakerSettings("request", REQUEST_CIRCUIT_BREAKER_LIMIT_SETTING.get(settings).getBytes());
        this.parentSettings = new BreakerSettings("parent", TOTAL_CIRCUIT_BREAKER_LIMIT_SETTING.get(settings).getBytes());
        this.queryBreakerSettings = new BreakerSettings(QUERY, QUERY_CIRCUIT_BREAKER_LIMIT_SETTING.get(settings).getBytes());
        this.logJobsBreakerSettings = new BreakerSettings(JOBS_LOG, JOBS_LOG_CIRCUIT_BREAKER_LIMIT_SETTING.get(settings).getBytes());
        this.logOperationsBreakerSettings = new BreakerSettings(OPERATIONS_LOG, OPERATIONS_LOG_CIRCUIT_BREAKER_LIMIT_SETTING.get(settings).getBytes());
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("parent circuit breaker with settings {}", (Object)this.parentSettings);
        }
        this.setBreaker(this.requestSettings);
        this.setBreaker(this.inFlightRequestsSettings);
        this.setBreaker(this.queryBreakerSettings);
        this.setBreaker(this.logJobsBreakerSettings);
        this.setBreaker(this.logOperationsBreakerSettings);
        clusterSettings.addSettingsUpdateConsumer(TOTAL_CIRCUIT_BREAKER_LIMIT_SETTING, this::setTotalCircuitBreakerLimit);
        clusterSettings.addSettingsUpdateConsumer(IN_FLIGHT_REQUESTS_CIRCUIT_BREAKER_LIMIT_SETTING, this::setInFlightRequestsBreakerLimit);
        clusterSettings.addSettingsUpdateConsumer(REQUEST_CIRCUIT_BREAKER_LIMIT_SETTING, this::setRequestBreakerLimit);
        clusterSettings.addSettingsUpdateConsumer(QUERY_CIRCUIT_BREAKER_LIMIT_SETTING, newLimit -> this.setBreakerLimit(this.queryBreakerSettings, QUERY, s -> {
            this.queryBreakerSettings = s;
        }, (ByteSizeValue)newLimit));
        clusterSettings.addSettingsUpdateConsumer(JOBS_LOG_CIRCUIT_BREAKER_LIMIT_SETTING, newLimit -> this.setBreakerLimit(this.logJobsBreakerSettings, JOBS_LOG, s -> {
            this.logJobsBreakerSettings = s;
        }, (ByteSizeValue)newLimit));
        clusterSettings.addSettingsUpdateConsumer(OPERATIONS_LOG_CIRCUIT_BREAKER_LIMIT_SETTING, newLimit -> this.setBreakerLimit(this.logOperationsBreakerSettings, OPERATIONS_LOG, s -> {
            this.logOperationsBreakerSettings = s;
        }, (ByteSizeValue)newLimit));
    }

    public static String breakingExceptionMessage(String label, long limit) {
        return String.format(Locale.ENGLISH, BREAKING_EXCEPTION_MESSAGE, label, limit, new ByteSizeValue(limit));
    }

    private void setRequestBreakerLimit(ByteSizeValue newRequestMax) {
        BreakerSettings newRequestSettings = new BreakerSettings("request", newRequestMax.getBytes());
        this.setBreaker(newRequestSettings);
        this.requestSettings = newRequestSettings;
        LOGGER.info("Updated breaker settings request: {}", (Object)newRequestSettings);
    }

    private void setInFlightRequestsBreakerLimit(ByteSizeValue newInFlightRequestsMax) {
        BreakerSettings newInFlightRequestsSettings = new BreakerSettings("in_flight_requests", newInFlightRequestsMax.getBytes());
        this.setBreaker(newInFlightRequestsSettings);
        this.inFlightRequestsSettings = newInFlightRequestsSettings;
        LOGGER.info("Updated breaker settings for in-flight requests: {}", (Object)newInFlightRequestsSettings);
    }

    private void setTotalCircuitBreakerLimit(ByteSizeValue byteSizeValue) {
        BreakerSettings newParentSettings;
        this.parentSettings = newParentSettings = new BreakerSettings("parent", byteSizeValue.getBytes());
    }

    private void setBreakerLimit(BreakerSettings oldSettings, String breakerName, Consumer<BreakerSettings> settingsConsumer, ByteSizeValue newLimit) {
        long newLimitBytes = newLimit == null ? oldSettings.bytesLimit() : newLimit.getBytes();
        BreakerSettings newSettings = new BreakerSettings(breakerName, newLimitBytes);
        this.setBreaker(newSettings);
        settingsConsumer.accept(newSettings);
        LOGGER.info("[{}] Updated breaker settings: {}", (Object)breakerName, (Object)newSettings);
    }

    @Override
    public CircuitBreaker getBreaker(String name) {
        return (CircuitBreaker)this.breakers.get(name);
    }

    @Override
    public CircuitBreakerStats stats(String name) {
        if ("parent".equals(name)) {
            return new CircuitBreakerStats("parent", this.parentSettings.bytesLimit(), this.parentUsed(0L), this.parentTripCount.get(), 1.0);
        }
        CircuitBreaker breaker = Objects.requireNonNull((ChildMemoryCircuitBreaker)this.breakers.get(name), "Unknown circuit breaker: " + name);
        return new CircuitBreakerStats(breaker.getName(), breaker.getLimit(), breaker.getUsed(), breaker.getTrippedCount(), 1.0);
    }

    private long parentUsed(long newBytesReserved) {
        return this.currentMemoryUsage() + newBytesReserved;
    }

    long currentMemoryUsage() {
        try {
            return MEMORY_MX_BEAN.getHeapMemoryUsage().getUsed();
        }
        catch (IllegalArgumentException ex) {
            assert (ex.getMessage().matches("committed = \\d+ should be < max = \\d+"));
            LOGGER.info("Cannot determine current memory usage due to JDK-8207200.", (Throwable)ex);
            return 0L;
        }
    }

    @Override
    public void checkParentLimit(long newBytesReserved, String label) throws CircuitBreakingException {
        long parentLimit;
        long totalUsed = this.parentUsed(newBytesReserved);
        if (totalUsed > (parentLimit = this.parentSettings.bytesLimit())) {
            long breakersTotalUsed = this.breakers.values().stream().mapToLong(CircuitBreaker::getUsed).sum();
            if ((double)(breakersTotalUsed + newBytesReserved) < (double)parentLimit * 0.3) {
                return;
            }
            this.parentTripCount.incrementAndGet();
            throw new CircuitBreakingException(newBytesReserved, totalUsed, parentLimit, "parent: " + label);
        }
    }

    private void setBreaker(BreakerSettings breakerSettings) {
        this.breakers.compute(breakerSettings.name(), (string, oldBreaker) -> new ChildMemoryCircuitBreaker(breakerSettings, (ChildMemoryCircuitBreaker)oldBreaker, this));
    }
}

