/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.recovery;

import io.crate.blob.BlobTransferTarget;
import io.crate.blob.recovery.BlobRecoveryHandler;
import io.crate.blob.v2.BlobIndex;
import io.crate.blob.v2.BlobIndicesService;
import io.crate.exceptions.SQLExceptions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ChannelActionListener;
import org.elasticsearch.action.support.PlainFuture;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.shard.IndexEventListener;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.indices.recovery.DelayRecoveryException;
import org.elasticsearch.indices.recovery.PeerRecoveryNotFound;
import org.elasticsearch.indices.recovery.RecoveryResponse;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.indices.recovery.RecoverySourceHandler;
import org.elasticsearch.indices.recovery.ReestablishRecoveryRequest;
import org.elasticsearch.indices.recovery.RemoteRecoveryTargetHandler;
import org.elasticsearch.indices.recovery.StartRecoveryRequest;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportService;
import org.jetbrains.annotations.Nullable;

public class PeerRecoverySourceService
extends AbstractLifecycleComponent
implements IndexEventListener,
ClusterStateListener {
    private static final Logger LOGGER = LogManager.getLogger(PeerRecoverySourceService.class);
    private final TransportService transportService;
    private final IndicesService indicesService;
    private final ClusterService clusterService;
    private final RecoverySettings recoverySettings;
    private final BlobTransferTarget blobTransferTarget;
    private final BlobIndicesService blobIndicesService;
    final OngoingRecoveries ongoingRecoveries = new OngoingRecoveries();

    public PeerRecoverySourceService(TransportService transportService, IndicesService indicesService, ClusterService clusterService, RecoverySettings recoverySettings, BlobTransferTarget blobTransferTarget, BlobIndicesService blobIndicesService) {
        this.transportService = transportService;
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.recoverySettings = recoverySettings;
        this.blobTransferTarget = blobTransferTarget;
        this.blobIndicesService = blobIndicesService;
        transportService.registerRequestHandler("internal:index/shard/recovery/start_recovery", "generic", StartRecoveryRequest::new, new StartRecoveryTransportRequestHandler());
        transportService.registerRequestHandler("internal:index/shard/recovery/reestablish_recovery", "generic", ReestablishRecoveryRequest::new, new ReestablishRecoveryTransportRequestHandler());
    }

    @Override
    protected void doStart() {
        if (DiscoveryNode.isDataNode(this.clusterService.getSettings())) {
            this.clusterService.addListener(this);
        }
    }

    @Override
    protected void doStop() {
        if (DiscoveryNode.isDataNode(this.clusterService.getSettings())) {
            this.ongoingRecoveries.awaitEmpty();
            this.clusterService.removeListener(this);
        }
    }

    @Override
    protected void doClose() {
    }

    @Override
    public void beforeIndexShardClosed(ShardId shardId, @Nullable IndexShard indexShard, Settings indexSettings) {
        if (indexShard != null) {
            this.ongoingRecoveries.cancel(indexShard, "shard is closed");
        }
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (event.nodesRemoved()) {
            for (DiscoveryNode removedNode : event.nodesDelta().removedNodes()) {
                this.ongoingRecoveries.cancelOnNodeLeft(removedNode);
            }
        }
    }

    private void recover(StartRecoveryRequest request, ActionListener<RecoveryResponse> listener) {
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard shard = indexService.getShard(request.shardId().id());
        ShardRouting routingEntry = shard.routingEntry();
        if (!routingEntry.primary() || !routingEntry.active()) {
            throw new DelayRecoveryException("source shard [" + String.valueOf(routingEntry) + "] is not an active primary");
        }
        if (!(!request.isPrimaryRelocation() || routingEntry.relocating() && routingEntry.relocatingNodeId().equals(request.targetNode().getId()))) {
            LOGGER.debug("delaying recovery of {} as source shard is not marked yet as relocating to {}", (Object)request.shardId(), (Object)request.targetNode());
            throw new DelayRecoveryException("source shard is not marked yet as relocating to [" + String.valueOf(request.targetNode()) + "]");
        }
        RecoverySourceHandler handler = this.ongoingRecoveries.addNewRecovery(request, shard);
        LOGGER.trace("[{}][{}] starting recovery to {}", (Object)request.shardId().getIndex().getName(), (Object)request.shardId().id(), (Object)request.targetNode());
        handler.recoverToTarget(listener.runAfter(() -> this.ongoingRecoveries.remove(shard, handler)));
    }

    private void reestablish(ReestablishRecoveryRequest request, ActionListener<RecoveryResponse> listener) {
        IndexService indexService = this.indicesService.indexServiceSafe(request.shardId().getIndex());
        IndexShard shard = indexService.getShard(request.shardId().id());
        LOGGER.trace("[{}][{}] reestablishing recovery {}", (Object)request.shardId().getIndex().getName(), (Object)request.shardId().id(), (Object)request.recoveryId());
        this.ongoingRecoveries.reestablishRecovery(request, shard, listener);
    }

    final int numberOfOngoingRecoveries() {
        return this.ongoingRecoveries.ongoingRecoveries.size();
    }

    final class OngoingRecoveries {
        private final Map<IndexShard, ShardRecoveryContext> ongoingRecoveries = new HashMap<IndexShard, ShardRecoveryContext>();
        private final Map<DiscoveryNode, Collection<RemoteRecoveryTargetHandler>> nodeToHandlers = new HashMap<DiscoveryNode, Collection<RemoteRecoveryTargetHandler>>();
        @Nullable
        private List<ActionListener<Void>> emptyListeners;

        OngoingRecoveries() {
        }

        synchronized RecoverySourceHandler addNewRecovery(StartRecoveryRequest request, IndexShard shard) {
            assert (PeerRecoverySourceService.this.lifecycle.started());
            ShardRecoveryContext shardContext = this.ongoingRecoveries.computeIfAbsent(shard, s -> new ShardRecoveryContext());
            RecoveryHandlers handlers = shardContext.addNewRecovery(request, shard);
            RemoteRecoveryTargetHandler recoveryTargetHandler = handlers.remoteHandler();
            this.nodeToHandlers.computeIfAbsent(recoveryTargetHandler.targetNode(), k -> new HashSet()).add(recoveryTargetHandler);
            shard.recoveryStats().incCurrentAsSource();
            return handlers.sourceHandler();
        }

        synchronized void cancelOnNodeLeft(DiscoveryNode node) {
            Collection<RemoteRecoveryTargetHandler> handlers = this.nodeToHandlers.get(node);
            if (handlers != null) {
                for (RemoteRecoveryTargetHandler handler : handlers) {
                    handler.cancel();
                }
            }
        }

        synchronized void reestablishRecovery(ReestablishRecoveryRequest request, IndexShard shard, ActionListener<RecoveryResponse> listener) {
            assert (PeerRecoverySourceService.this.lifecycle.started());
            ShardRecoveryContext shardContext = this.ongoingRecoveries.get(shard);
            if (shardContext == null) {
                throw new PeerRecoveryNotFound(request.recoveryId(), request.shardId(), request.targetAllocationId());
            }
            shardContext.reestablishRecovery(request, listener);
        }

        synchronized void remove(IndexShard shard, RecoverySourceHandler handler) {
            ShardRecoveryContext shardRecoveryContext = this.ongoingRecoveries.get(shard);
            assert (shardRecoveryContext != null) : "Shard was not registered [" + String.valueOf(shard) + "]";
            RemoteRecoveryTargetHandler removed = shardRecoveryContext.recoveryHandlers.remove(handler);
            assert (removed != null) : "Handler was not registered [" + String.valueOf(handler) + "]";
            if (removed != null) {
                shard.recoveryStats().decCurrentAsSource();
                removed.cancel();
                assert (((Collection)this.nodeToHandlers.getOrDefault(removed.targetNode(), Collections.emptySet())).contains(removed)) : "Remote recovery was not properly tracked [" + String.valueOf(removed) + "]";
                this.nodeToHandlers.computeIfPresent(removed.targetNode(), (k, handlersForNode) -> {
                    handlersForNode.remove(removed);
                    if (handlersForNode.isEmpty()) {
                        return null;
                    }
                    return handlersForNode;
                });
            }
            if (shardRecoveryContext.recoveryHandlers.isEmpty()) {
                this.ongoingRecoveries.remove(shard);
            }
            if (this.ongoingRecoveries.isEmpty() && this.emptyListeners != null) {
                List onEmptyListeners = this.emptyListeners;
                this.emptyListeners = null;
                ActionListener.onResponse(onEmptyListeners, null);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        synchronized void cancel(IndexShard shard, String reason) {
            ShardRecoveryContext shardRecoveryContext = this.ongoingRecoveries.get(shard);
            if (shardRecoveryContext != null) {
                ArrayList<Exception> failures = new ArrayList<Exception>();
                for (RecoverySourceHandler handlers : shardRecoveryContext.recoveryHandlers.keySet()) {
                    try {
                        handlers.cancel(reason);
                    }
                    catch (Exception ex) {
                        failures.add(ex);
                    }
                    finally {
                        shard.recoveryStats().decCurrentAsSource();
                    }
                }
                SQLExceptions.maybeThrowRuntimeAndSuppress(failures);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void awaitEmpty() {
            PlainFuture future;
            assert (PeerRecoverySourceService.this.lifecycle.stoppedOrClosed());
            OngoingRecoveries ongoingRecoveries = this;
            synchronized (ongoingRecoveries) {
                if (this.ongoingRecoveries.isEmpty()) {
                    return;
                }
                future = new PlainFuture();
                if (this.emptyListeners == null) {
                    this.emptyListeners = new ArrayList<ActionListener<Void>>();
                }
                this.emptyListeners.add(future);
            }
            FutureUtils.get(future);
        }

        private final class ShardRecoveryContext {
            final Map<RecoverySourceHandler, RemoteRecoveryTargetHandler> recoveryHandlers = new HashMap<RecoverySourceHandler, RemoteRecoveryTargetHandler>();

            private ShardRecoveryContext() {
            }

            synchronized RecoveryHandlers addNewRecovery(StartRecoveryRequest request, IndexShard shard) {
                for (RecoverySourceHandler existingHandler : this.recoveryHandlers.keySet()) {
                    if (!existingHandler.getRequest().targetAllocationId().equals(request.targetAllocationId())) continue;
                    throw new DelayRecoveryException("recovery with same target already registered, waiting for previous recovery attempt to be cancelled or completed");
                }
                RecoveryHandlers handlers = this.createRecoverySourceHandler(request, shard);
                this.recoveryHandlers.put(handlers.sourceHandler(), handlers.remoteHandler());
                return handlers;
            }

            synchronized void reestablishRecovery(ReestablishRecoveryRequest request, ActionListener<RecoveryResponse> listener) {
                RecoverySourceHandler handler = null;
                for (RecoverySourceHandler existingHandler : this.recoveryHandlers.keySet()) {
                    if (existingHandler.getRequest().recoveryId() != request.recoveryId() || !existingHandler.getRequest().targetAllocationId().equals(request.targetAllocationId())) continue;
                    handler = existingHandler;
                    break;
                }
                if (handler == null) {
                    throw new ResourceNotFoundException("Cannot reestablish recovery, recovery id [" + request.recoveryId() + "] not found.", new Object[0]);
                }
                handler.addListener(listener);
            }

            private RecoveryHandlers createRecoverySourceHandler(StartRecoveryRequest request, IndexShard shard) {
                RemoteRecoveryTargetHandler recoveryTarget = new RemoteRecoveryTargetHandler(request.recoveryId(), request.shardId(), PeerRecoverySourceService.this.transportService, request.targetNode(), PeerRecoverySourceService.this.recoverySettings, throttleTime -> shard.recoveryStats().addThrottleTime((long)throttleTime));
                int recoveryChunkSizeInBytes = PeerRecoverySourceService.this.recoverySettings.getChunkSize().bytesAsInt();
                RecoverySourceHandler handler = BlobIndex.isBlobIndex(shard.shardId().getIndexName()) ? new BlobRecoveryHandler(shard, recoveryTarget, request, recoveryChunkSizeInBytes, PeerRecoverySourceService.this.recoverySettings.getMaxConcurrentFileChunks(), PeerRecoverySourceService.this.recoverySettings.getMaxConcurrentOperations(), PeerRecoverySourceService.this.transportService, PeerRecoverySourceService.this.blobTransferTarget, PeerRecoverySourceService.this.blobIndicesService) : new RecoverySourceHandler(shard, recoveryTarget, shard.getThreadPool(), request, recoveryChunkSizeInBytes, PeerRecoverySourceService.this.recoverySettings.getMaxConcurrentFileChunks(), PeerRecoverySourceService.this.recoverySettings.getMaxConcurrentOperations());
                return new RecoveryHandlers(handler, recoveryTarget);
            }
        }
    }

    public static class Actions {
        public static final String START_RECOVERY = "internal:index/shard/recovery/start_recovery";
        public static final String REESTABLISH_RECOVERY = "internal:index/shard/recovery/reestablish_recovery";
    }

    class StartRecoveryTransportRequestHandler
    implements TransportRequestHandler<StartRecoveryRequest> {
        StartRecoveryTransportRequestHandler() {
        }

        @Override
        public void messageReceived(StartRecoveryRequest request, TransportChannel channel) throws Exception {
            PeerRecoverySourceService.this.recover(request, new ChannelActionListener<RecoveryResponse>(channel));
        }
    }

    class ReestablishRecoveryTransportRequestHandler
    implements TransportRequestHandler<ReestablishRecoveryRequest> {
        ReestablishRecoveryTransportRequestHandler() {
        }

        @Override
        public void messageReceived(ReestablishRecoveryRequest request, TransportChannel channel) throws Exception {
            PeerRecoverySourceService.this.reestablish(request, new ChannelActionListener<RecoveryResponse>(channel));
        }
    }

    record RecoveryHandlers(RecoverySourceHandler sourceHandler, RemoteRecoveryTargetHandler remoteHandler) {
    }
}

