/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.indices.store;

import io.crate.common.collections.Tuple;
import io.crate.common.unit.TimeValue;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.ClusterStateObserver;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.IndexRoutingTable;
import org.elasticsearch.cluster.routing.IndexShardRoutingTable;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingTable;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.IndexShardState;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;

public class IndicesStore
implements ClusterStateListener,
Closeable {
    private static final Logger LOGGER = LogManager.getLogger(IndicesStore.class);
    public static final Setting<TimeValue> INDICES_STORE_DELETE_SHARD_TIMEOUT = Setting.positiveTimeSetting("indices.store.delete.shard.timeout", new TimeValue(30L, TimeUnit.SECONDS), Setting.Property.NodeScope);
    public static final String ACTION_SHARD_EXISTS = "internal:index/shard/exists";
    private static final EnumSet<IndexShardState> ACTIVE_STATES = EnumSet.of(IndexShardState.STARTED);
    private final IndicesService indicesService;
    private final ClusterService clusterService;
    private final TransportService transportService;
    private final Set<ShardId> folderNotFoundCache = new HashSet<ShardId>();
    private final Settings settings;
    private final TimeValue deleteShardTimeout;

    @Inject
    public IndicesStore(Settings settings, IndicesService indicesService, ClusterService clusterService, TransportService transportService) {
        this.settings = settings;
        this.indicesService = indicesService;
        this.clusterService = clusterService;
        this.transportService = transportService;
        transportService.registerRequestHandler(ACTION_SHARD_EXISTS, "same", ShardActiveRequest::new, new ShardActiveRequestHandler());
        this.deleteShardTimeout = INDICES_STORE_DELETE_SHARD_TIMEOUT.get(settings);
        if (DiscoveryNode.isDataNode(settings)) {
            clusterService.addListener(this);
        }
    }

    @Override
    public void close() {
        if (DiscoveryNode.isDataNode(this.settings)) {
            this.clusterService.removeListener(this);
        }
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (!event.routingTableChanged()) {
            return;
        }
        if (event.state().blocks().disableStatePersistence()) {
            return;
        }
        RoutingTable routingTable = event.state().routingTable();
        Iterator<ShardId> it = this.folderNotFoundCache.iterator();
        while (it.hasNext()) {
            ShardId shardId = it.next();
            if (routingTable.hasIndex(shardId.getIndex())) continue;
            it.remove();
        }
        String localNodeId = event.state().nodes().getLocalNodeId();
        RoutingNode localRoutingNode = event.state().getRoutingNodes().node(localNodeId);
        if (localRoutingNode != null) {
            for (ShardRouting routing : localRoutingNode) {
                this.folderNotFoundCache.remove(routing.shardId());
            }
        }
        for (IndexRoutingTable indexRoutingTable : routingTable) {
            block9: for (IndexShardRoutingTable indexShardRoutingTable : indexRoutingTable) {
                IndexSettings indexSettings;
                ShardId shardId = indexShardRoutingTable.shardId();
                if (this.folderNotFoundCache.contains(shardId) || !IndicesStore.shardCanBeDeleted(localNodeId, indexShardRoutingTable)) continue;
                IndexService indexService = this.indicesService.indexService(indexRoutingTable.getIndex());
                if (indexService == null) {
                    IndexMetadata indexMetadata = event.state().metadata().getIndexSafe(indexRoutingTable.getIndex());
                    indexSettings = new IndexSettings(indexMetadata, this.settings);
                } else {
                    indexSettings = indexService.getIndexSettings();
                }
                IndicesService.ShardDeletionCheckResult shardDeletionCheckResult = this.indicesService.canDeleteShardContent(shardId, indexSettings);
                switch (shardDeletionCheckResult) {
                    case FOLDER_FOUND_CAN_DELETE: {
                        this.deleteShardIfExistElseWhere(event.state(), indexShardRoutingTable);
                        continue block9;
                    }
                    case NO_FOLDER_FOUND: {
                        this.folderNotFoundCache.add(shardId);
                        continue block9;
                    }
                    case NO_LOCAL_STORAGE: {
                        assert (false) : "shard deletion only runs on data nodes which always have local storage";
                        continue block9;
                    }
                    case STILL_ALLOCATED: {
                        continue block9;
                    }
                }
                assert (false) : "unknown shard deletion check result: " + String.valueOf((Object)shardDeletionCheckResult);
            }
        }
    }

    static boolean shardCanBeDeleted(String localNodeId, IndexShardRoutingTable indexShardRoutingTable) {
        if (indexShardRoutingTable.size() == 0) {
            return false;
        }
        for (ShardRouting shardRouting : indexShardRoutingTable) {
            if (!shardRouting.started()) {
                return false;
            }
            if (!localNodeId.equals(shardRouting.currentNodeId())) continue;
            return false;
        }
        return true;
    }

    private void deleteShardIfExistElseWhere(ClusterState state, IndexShardRoutingTable indexShardRoutingTable) {
        ArrayList<Tuple> requests = new ArrayList<Tuple>(indexShardRoutingTable.size());
        String indexUUID = indexShardRoutingTable.shardId().getIndex().getUUID();
        ClusterName clusterName = state.getClusterName();
        for (ShardRouting shardRouting : indexShardRoutingTable) {
            assert (shardRouting.started()) : "expected started shard but was " + String.valueOf(shardRouting);
            DiscoveryNode currentNode = state.nodes().get(shardRouting.currentNodeId());
            requests.add(new Tuple((Object)currentNode, (Object)new ShardActiveRequest(clusterName, indexUUID, shardRouting.shardId(), this.deleteShardTimeout)));
        }
        ShardActiveResponseHandler responseHandler = new ShardActiveResponseHandler(indexShardRoutingTable.shardId(), state.version(), requests.size());
        for (Tuple request : requests) {
            LOGGER.trace("{} sending shard active check to {}", (Object)((ShardActiveRequest)request.v2()).shardId, request.v1());
            this.transportService.sendRequest((DiscoveryNode)request.v1(), ACTION_SHARD_EXISTS, (TransportRequest)request.v2(), responseHandler);
        }
    }

    private class ShardActiveRequestHandler
    implements TransportRequestHandler<ShardActiveRequest> {
        private ShardActiveRequestHandler() {
        }

        @Override
        public void messageReceived(final ShardActiveRequest request, final TransportChannel channel) throws Exception {
            IndexShard indexShard = this.getShard(request);
            if (indexShard == null) {
                channel.sendResponse(new ShardActiveResponse(false, IndicesStore.this.clusterService.localNode()));
            } else {
                ClusterStateObserver observer = new ClusterStateObserver(IndicesStore.this.clusterService, request.timeout, LOGGER);
                boolean shardActive = this.shardActive(indexShard);
                if (shardActive) {
                    channel.sendResponse(new ShardActiveResponse(true, IndicesStore.this.clusterService.localNode()));
                } else {
                    observer.waitForNextChange(new ClusterStateObserver.Listener(){
                        final /* synthetic */ ShardActiveRequestHandler this$1;
                        {
                            this.this$1 = this$1;
                        }

                        @Override
                        public void onNewClusterState(ClusterState state) {
                            this.sendResult(this.this$1.shardActive(this.this$1.getShard(request)));
                        }

                        @Override
                        public void onClusterServiceClose() {
                            this.sendResult(false);
                        }

                        @Override
                        public void onTimeout(TimeValue timeout) {
                            this.sendResult(this.this$1.shardActive(this.this$1.getShard(request)));
                        }

                        public void sendResult(boolean shardActive) {
                            try {
                                channel.sendResponse(new ShardActiveResponse(shardActive, this.this$1.IndicesStore.this.clusterService.localNode()));
                            }
                            catch (IOException | EsRejectedExecutionException e) {
                                LOGGER.error(() -> new ParameterizedMessage("failed send response for shard active while trying to delete shard {} - shard will probably not be removed", (Object)request2.shardId), (Throwable)e);
                            }
                        }
                    }, newState -> {
                        IndexShard currentShard = this.getShard(request);
                        return currentShard == null || this.shardActive(currentShard);
                    });
                }
            }
        }

        private boolean shardActive(IndexShard indexShard) {
            if (indexShard != null) {
                return ACTIVE_STATES.contains((Object)indexShard.state());
            }
            return false;
        }

        private IndexShard getShard(ShardActiveRequest request) {
            ClusterName thisClusterName = IndicesStore.this.clusterService.getClusterName();
            if (!thisClusterName.equals(request.clusterName)) {
                LOGGER.trace("shard exists request meant for cluster[{}], but this is cluster[{}], ignoring request", (Object)request.clusterName, (Object)thisClusterName);
                return null;
            }
            ShardId shardId = request.shardId;
            IndexService indexService = IndicesStore.this.indicesService.indexService(shardId.getIndex());
            if (indexService != null && indexService.indexUUID().equals(request.indexUUID)) {
                return indexService.getShardOrNull(shardId.id());
            }
            return null;
        }
    }

    private static class ShardActiveRequest
    extends TransportRequest {
        protected final TimeValue timeout;
        private final ClusterName clusterName;
        private final String indexUUID;
        private final ShardId shardId;

        ShardActiveRequest(ClusterName clusterName, String indexUUID, ShardId shardId, TimeValue timeout) {
            this.shardId = shardId;
            this.indexUUID = indexUUID;
            this.clusterName = clusterName;
            this.timeout = timeout;
        }

        public ShardActiveRequest(StreamInput in) throws IOException {
            super(in);
            this.clusterName = new ClusterName(in);
            this.indexUUID = in.readString();
            this.shardId = new ShardId(in);
            this.timeout = new TimeValue(in.readLong(), TimeUnit.MILLISECONDS);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.clusterName.writeTo(out);
            out.writeString(this.indexUUID);
            this.shardId.writeTo(out);
            out.writeLong(this.timeout.millis());
        }
    }

    private class ShardActiveResponseHandler
    implements TransportResponseHandler<ShardActiveResponse> {
        private final ShardId shardId;
        private final int expectedActiveCopies;
        private final long clusterStateVersion;
        private final AtomicInteger awaitingResponses;
        private final AtomicInteger activeCopies;

        ShardActiveResponseHandler(ShardId shardId, long clusterStateVersion, int expectedActiveCopies) {
            this.shardId = shardId;
            this.expectedActiveCopies = expectedActiveCopies;
            this.clusterStateVersion = clusterStateVersion;
            this.awaitingResponses = new AtomicInteger(expectedActiveCopies);
            this.activeCopies = new AtomicInteger();
        }

        @Override
        public ShardActiveResponse read(StreamInput in) throws IOException {
            return new ShardActiveResponse(in);
        }

        @Override
        public void handleResponse(ShardActiveResponse response) {
            LOGGER.trace("{} is {}active on node {}", (Object)this.shardId, (Object)(response.shardActive ? "" : "not "), (Object)response.node);
            if (response.shardActive) {
                this.activeCopies.incrementAndGet();
            }
            if (this.awaitingResponses.decrementAndGet() == 0) {
                this.allNodesResponded();
            }
        }

        @Override
        public void handleException(TransportException exp) {
            LOGGER.debug(() -> new ParameterizedMessage("shards active request failed for {}", (Object)this.shardId), (Throwable)exp);
            if (this.awaitingResponses.decrementAndGet() == 0) {
                this.allNodesResponded();
            }
        }

        @Override
        public String executor() {
            return "same";
        }

        private void allNodesResponded() {
            if (this.activeCopies.get() != this.expectedActiveCopies) {
                LOGGER.trace("not deleting shard {}, expected {} active copies, but only {} found active copies", (Object)this.shardId, (Object)this.expectedActiveCopies, (Object)this.activeCopies.get());
                return;
            }
            ClusterState latestClusterState = IndicesStore.this.clusterService.state();
            if (this.clusterStateVersion != latestClusterState.version()) {
                LOGGER.trace("not deleting shard {}, the latest cluster state version[{}] is not equal to cluster state before shard active api call [{}]", (Object)this.shardId, (Object)latestClusterState.version(), (Object)this.clusterStateVersion);
                return;
            }
            IndicesStore.this.clusterService.getClusterApplierService().runOnApplierThread("indices_store ([" + String.valueOf(this.shardId) + "] active fully on other nodes)", currentState -> {
                if (this.clusterStateVersion != currentState.version()) {
                    LOGGER.trace("not deleting shard {}, the update task state version[{}] is not equal to cluster state before shard active api call [{}]", (Object)this.shardId, (Object)currentState.version(), (Object)this.clusterStateVersion);
                    return;
                }
                try {
                    IndicesStore.this.indicesService.deleteShardStore("no longer used", this.shardId, (ClusterState)currentState);
                }
                catch (Exception ex) {
                    LOGGER.debug(() -> new ParameterizedMessage("{} failed to delete unallocated shard, ignoring", (Object)this.shardId), (Throwable)ex);
                }
            }, (source, e) -> LOGGER.error(() -> new ParameterizedMessage("{} unexpected error during deletion of unallocated shard", (Object)this.shardId), (Throwable)e));
        }
    }

    private static class ShardActiveResponse
    extends TransportResponse {
        private final boolean shardActive;
        private final DiscoveryNode node;

        ShardActiveResponse(boolean shardActive, DiscoveryNode node) {
            this.shardActive = shardActive;
            this.node = node;
        }

        ShardActiveResponse(StreamInput in) throws IOException {
            this.shardActive = in.readBoolean();
            this.node = new DiscoveryNode(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeBoolean(this.shardActive);
            this.node.writeTo(out);
        }
    }
}

