/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.monitor.process;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;
import org.elasticsearch.monitor.Probes;
import org.elasticsearch.monitor.process.ProcessStats;

public class ProcessProbe {
    private static final OperatingSystemMXBean OS_MX_BEAN = ManagementFactory.getOperatingSystemMXBean();
    private static final Method GET_MAX_FILE_DESCRIPTOR_COUNT_FIELD = ProcessProbe.getUnixMethod("getMaxFileDescriptorCount");
    private static final Method GET_OPEN_FILE_DESCRIPTOR_COUNT_FIELD = ProcessProbe.getUnixMethod("getOpenFileDescriptorCount");
    private static final Method GET_PROCESS_CPU_LOAD = ProcessProbe.getMethod("getProcessCpuLoad");
    private static final Method GET_PROCESS_CPU_TIME = ProcessProbe.getMethod("getProcessCpuTime");
    private static final Method GET_COMMITTED_VIRTUAL_MEMORY_SIZE = ProcessProbe.getMethod("getCommittedVirtualMemorySize");

    public static ProcessProbe getInstance() {
        return ProcessProbeHolder.INSTANCE;
    }

    private ProcessProbe() {
    }

    public long getMaxFileDescriptorCount() {
        if (GET_MAX_FILE_DESCRIPTOR_COUNT_FIELD == null) {
            return -1L;
        }
        try {
            return (Long)GET_MAX_FILE_DESCRIPTOR_COUNT_FIELD.invoke((Object)OS_MX_BEAN, new Object[0]);
        }
        catch (Exception t) {
            return -1L;
        }
    }

    public long getOpenFileDescriptorCount() {
        if (GET_OPEN_FILE_DESCRIPTOR_COUNT_FIELD == null) {
            return -1L;
        }
        try {
            return (Long)GET_OPEN_FILE_DESCRIPTOR_COUNT_FIELD.invoke((Object)OS_MX_BEAN, new Object[0]);
        }
        catch (Exception t) {
            return -1L;
        }
    }

    public short getProcessCpuPercent() {
        return Probes.getLoadAndScaleToPercent(GET_PROCESS_CPU_LOAD, OS_MX_BEAN);
    }

    public long getProcessCpuTotalTime() {
        if (GET_PROCESS_CPU_TIME != null) {
            try {
                long time = (Long)GET_PROCESS_CPU_TIME.invoke((Object)OS_MX_BEAN, new Object[0]);
                if (time >= 0L) {
                    return time / 1000000L;
                }
            }
            catch (Exception t) {
                return -1L;
            }
        }
        return -1L;
    }

    public long getTotalVirtualMemorySize() {
        if (GET_COMMITTED_VIRTUAL_MEMORY_SIZE != null) {
            try {
                long virtual = (Long)GET_COMMITTED_VIRTUAL_MEMORY_SIZE.invoke((Object)OS_MX_BEAN, new Object[0]);
                if (virtual >= 0L) {
                    return virtual;
                }
            }
            catch (Exception t) {
                return -1L;
            }
        }
        return -1L;
    }

    public ProcessStats processStats() {
        ProcessStats.Cpu cpu = new ProcessStats.Cpu(this.getProcessCpuPercent(), this.getProcessCpuTotalTime());
        ProcessStats.Mem mem = new ProcessStats.Mem(this.getTotalVirtualMemorySize());
        return new ProcessStats(System.currentTimeMillis(), this.getOpenFileDescriptorCount(), this.getMaxFileDescriptorCount(), cpu, mem);
    }

    private static Method getMethod(String methodName) {
        try {
            return Class.forName("com.sun.management.OperatingSystemMXBean").getMethod(methodName, new Class[0]);
        }
        catch (Exception t) {
            return null;
        }
    }

    private static Method getUnixMethod(String methodName) {
        try {
            return Class.forName("com.sun.management.UnixOperatingSystemMXBean").getMethod(methodName, new Class[0]);
        }
        catch (Exception t) {
            return null;
        }
    }

    private static class ProcessProbeHolder {
        private static final ProcessProbe INSTANCE = new ProcessProbe();

        private ProcessProbeHolder() {
        }
    }
}

