/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import io.crate.analyze.repositories.TypeSettings;
import io.crate.replication.logical.LogicalReplicationService;
import io.crate.replication.logical.LogicalReplicationSettings;
import io.crate.replication.logical.repository.LogicalReplicationRepository;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.elasticsearch.cluster.metadata.MetadataUpgradeService;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.AbstractModule;
import org.elasticsearch.common.inject.Binder;
import org.elasticsearch.common.inject.multibindings.MapBinder;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.env.Environment;
import org.elasticsearch.indices.recovery.RecoverySettings;
import org.elasticsearch.plugins.RepositoryPlugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.fs.FsRepository;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusters;
import org.elasticsearch.transport.TransportService;

public class RepositoriesModule
extends AbstractModule {
    private final RepositoriesService repositoriesService;

    public RepositoriesModule(final Environment env, List<RepositoryPlugin> repoPlugins, TransportService transportService, final ClusterService clusterService, final LogicalReplicationService logicalReplicationService, final MetadataUpgradeService metadataUpgradeService, final RemoteClusters remoteClusters, final ThreadPool threadPool, final NamedWriteableRegistry namedWriteableRegistry, final NamedXContentRegistry namedXContentRegistry, final LogicalReplicationSettings replicationSettings, final RecoverySettings recoverySettings) {
        HashMap<String, Repository.Factory> factories = new HashMap<String, Repository.Factory>();
        factories.put("fs", new Repository.Factory(){

            @Override
            public TypeSettings settings() {
                return new TypeSettings(FsRepository.mandatorySettings(), FsRepository.optionalSettings());
            }

            @Override
            public Repository create(RepositoryMetadata metadata) throws Exception {
                return new FsRepository(metadata, env, namedWriteableRegistry, namedXContentRegistry, clusterService, recoverySettings);
            }
        });
        factories.put("logical_replication", new Repository.Factory(){

            @Override
            public Repository create(RepositoryMetadata metadata) throws Exception {
                return new LogicalReplicationRepository(clusterService, logicalReplicationService, metadataUpgradeService, remoteClusters, metadata, threadPool, replicationSettings);
            }

            @Override
            public TypeSettings settings() {
                return new TypeSettings(List.of(), List.of());
            }
        });
        for (RepositoryPlugin repoPlugin : repoPlugins) {
            Map<String, Repository.Factory> newRepoTypes = repoPlugin.getRepositories(env, namedWriteableRegistry, namedXContentRegistry, clusterService, recoverySettings);
            for (Map.Entry<String, Repository.Factory> entry : newRepoTypes.entrySet()) {
                if (factories.put(entry.getKey(), entry.getValue()) == null) continue;
                throw new IllegalArgumentException("Repository type [" + entry.getKey() + "] is already registered");
            }
        }
        Map<String, Repository.Factory> repositoryTypes = Collections.unmodifiableMap(factories);
        this.repositoriesService = new RepositoriesService(env.settings(), clusterService, transportService, repositoryTypes, threadPool);
    }

    protected void configure() {
        Map<String, Repository.Factory> repositoryTypes = this.repositoriesService.typesRegistry();
        MapBinder typesBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, Repository.Factory.class);
        repositoryTypes.forEach((k, v) -> typesBinder.addBinding(k).toInstance(v));
        MapBinder typeSettingsBinder = MapBinder.newMapBinder((Binder)this.binder(), String.class, TypeSettings.class);
        for (Map.Entry<String, Repository.Factory> e : repositoryTypes.entrySet()) {
            String repoScheme = e.getKey();
            TypeSettings repoSettings = e.getValue().settings();
            typeSettingsBinder.addBinding((Object)repoScheme).toInstance((Object)repoSettings);
        }
    }

    public RepositoriesService repositoryService() {
        return this.repositoriesService;
    }
}

