/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.threadpool;

import io.crate.common.unit.TimeValue;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.EsThreadPoolExecutor;
import org.elasticsearch.node.Node;
import org.elasticsearch.threadpool.ExecutorBuilder;
import org.elasticsearch.threadpool.ThreadPool;

public final class ScalingExecutorBuilder
extends ExecutorBuilder {
    private final Setting<Integer> coreSetting;
    private final Setting<Integer> maxSetting;
    private final Setting<TimeValue> keepAliveSetting;

    public ScalingExecutorBuilder(String name, int core, int max, TimeValue keepAlive) {
        super(name);
        String prefix = "thread_pool." + name;
        this.coreSetting = Setting.intSetting(ScalingExecutorBuilder.settingsKey(prefix, "core"), core, Setting.Property.NodeScope);
        this.maxSetting = Setting.intSetting(ScalingExecutorBuilder.settingsKey(prefix, "max"), max, Setting.Property.NodeScope);
        this.keepAliveSetting = Setting.timeSetting(ScalingExecutorBuilder.settingsKey(prefix, "keep_alive"), keepAlive, Setting.Property.NodeScope);
    }

    @Override
    public List<Setting<?>> getRegisteredSettings() {
        return Arrays.asList(this.coreSetting, this.maxSetting, this.keepAliveSetting);
    }

    @Override
    ThreadPool.ExecutorHolder build(Settings settings) {
        String nodeName = Node.NODE_NAME_SETTING.get(settings);
        int core = this.coreSetting.get(settings);
        int max = this.maxSetting.get(settings);
        TimeValue keepAlive = this.keepAliveSetting.get(settings);
        ThreadPool.Info info = new ThreadPool.Info(this.name(), ThreadPool.ThreadPoolType.SCALING, core, max, keepAlive, null);
        ThreadFactory threadFactory = EsExecutors.daemonThreadFactory(EsExecutors.threadName(nodeName, this.name()));
        EsThreadPoolExecutor executor = EsExecutors.newScaling(nodeName + "/" + this.name(), core, max, keepAlive.millis(), TimeUnit.MILLISECONDS, threadFactory);
        return new ThreadPool.ExecutorHolder(executor, info);
    }

    @Override
    String formatInfo(ThreadPool.Info info) {
        return String.format(Locale.ROOT, "name [%s], core [%d], max [%d], keep alive [%s]", info.name(), info.min(), info.max(), info.keepAlive());
    }
}

