/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.elasticsearch.Version;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.transport.OutboundHandler;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportResponse;

public final class TcpTransportChannel
implements TransportChannel {
    private final AtomicBoolean released = new AtomicBoolean();
    private final OutboundHandler outboundHandler;
    private final CloseableChannel channel;
    private final String action;
    private final long requestId;
    private final Version version;
    private final boolean compressResponse;
    private final boolean isHandshake;
    private final Releasable breakerRelease;
    private Exception releaseBy;

    TcpTransportChannel(OutboundHandler outboundHandler, CloseableChannel channel, String action, long requestId, Version version, boolean compressResponse, boolean isHandshake, Releasable breakerRelease) {
        this.version = version;
        this.channel = channel;
        this.outboundHandler = outboundHandler;
        this.action = action;
        this.requestId = requestId;
        this.compressResponse = compressResponse;
        this.isHandshake = isHandshake;
        this.breakerRelease = breakerRelease;
    }

    @Override
    public void sendResponse(TransportResponse response) throws IOException {
        try {
            this.outboundHandler.sendResponse(this.version, this.channel, this.requestId, this.action, response, this.compressResponse, this.isHandshake);
        }
        finally {
            this.release(false);
        }
    }

    @Override
    public void sendResponse(Exception exception) throws IOException {
        try {
            this.outboundHandler.sendErrorResponse(this.version, this.channel, this.requestId, this.action, exception);
        }
        finally {
            this.release(true);
        }
    }

    private void release(boolean isExceptionResponse) {
        if (this.released.compareAndSet(false, true)) {
            assert ((this.releaseBy = new Exception()) != null);
            this.breakerRelease.close();
        } else if (!isExceptionResponse) {
            throw new IllegalStateException("reserved bytes are already released", this.releaseBy);
        }
    }

    @Override
    public String getChannelType() {
        return "transport";
    }

    @Override
    public Version getVersion() {
        return this.version;
    }

    public CloseableChannel getChannel() {
        return this.channel;
    }

    public String toString() {
        return "TcpTransportChannel{action=" + this.action + ", channel=" + String.valueOf(this.channel) + "}";
    }
}

