/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import io.crate.common.io.IOUtils;
import java.io.Closeable;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.network.CloseableChannel;
import org.elasticsearch.transport.Header;
import org.elasticsearch.transport.InboundMessage;

public final class TransportLogger {
    private static final Logger LOGGER = LogManager.getLogger(TransportLogger.class);
    private static final int HEADER_SIZE = 6;

    static void logInboundMessage(CloseableChannel channel, InboundMessage message) {
        if (LOGGER.isTraceEnabled()) {
            try {
                String logMessage = TransportLogger.format(channel, message, "READ");
                LOGGER.trace(logMessage);
            }
            catch (IOException e) {
                LOGGER.warn("an exception occurred formatting a READ trace message", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String format(CloseableChannel channel, InboundMessage message, String event) throws IOException {
        StreamInput streamInput;
        StringBuilder sb;
        block6: {
            sb = new StringBuilder();
            sb.append(channel);
            if (message.isPing()) {
                sb.append(" [ping]").append(' ').append(event).append(": ").append(6).append('B');
                return sb.toString();
            }
            boolean success = false;
            Header header = message.getHeader();
            int networkMessageSize = header.getNetworkMessageSize();
            int messageLengthWithHeader = 6 + networkMessageSize;
            streamInput = message.openOrGetStreamInput();
            try {
                long requestId = header.getRequestId();
                boolean isRequest = header.isRequest();
                String type = isRequest ? "request" : "response";
                String version = header.getVersion().toString();
                sb.append(" [length: ").append(messageLengthWithHeader);
                sb.append(", request id: ").append(requestId);
                sb.append(", type: ").append(type);
                sb.append(", version: ").append(version);
                if (!header.needsToReadVariableHeader() && isRequest) {
                    sb.append(", action: ").append(header.getActionName());
                }
                sb.append(']');
                sb.append(' ').append(event).append(": ").append(messageLengthWithHeader).append('B');
                success = true;
                if (!success) break block6;
            }
            catch (Throwable throwable) {
                if (success) {
                    IOUtils.close((Closeable[])new Closeable[]{streamInput});
                    throw throwable;
                } else {
                    IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{streamInput});
                }
                throw throwable;
            }
            IOUtils.close((Closeable[])new Closeable[]{streamInput});
            return sb.toString();
        }
        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{streamInput});
        return sb.toString();
    }
}

