/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport;

import io.crate.common.io.IOUtils;
import io.crate.common.unit.TimeValue;
import io.crate.protocols.ConnectionStats;
import java.io.Closeable;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.UnknownHostException;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Predicate;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.elasticsearch.Version;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionListenerResponseHandler;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.BoundTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.EsRejectedExecutionException;
import org.elasticsearch.common.util.concurrent.RejectableRunnable;
import org.elasticsearch.node.NodeClosedException;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.ActionNotFoundTransportException;
import org.elasticsearch.transport.ClusterConnectionManager;
import org.elasticsearch.transport.ConnectTransportException;
import org.elasticsearch.transport.ConnectionManager;
import org.elasticsearch.transport.ConnectionProfile;
import org.elasticsearch.transport.NodeDisconnectedException;
import org.elasticsearch.transport.NodeNotConnectedException;
import org.elasticsearch.transport.ReceiveTimeoutTransportException;
import org.elasticsearch.transport.RemoteTransportException;
import org.elasticsearch.transport.RequestHandlerRegistry;
import org.elasticsearch.transport.ResponseHandlerFailureTransportException;
import org.elasticsearch.transport.SendRequestTransportException;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportConnectionListener;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportMessageListener;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportSettings;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.VisibleForTesting;

public class TransportService
extends AbstractLifecycleComponent
implements TransportMessageListener,
TransportConnectionListener {
    protected static final Logger LOGGER = LogManager.getLogger(TransportService.class);
    public static final String HANDSHAKE_ACTION_NAME = "internal:transport/handshake";
    private final AtomicBoolean handleIncomingRequests = new AtomicBoolean();
    protected final Transport transport;
    protected final ConnectionManager connectionManager;
    protected final ThreadPool threadPool;
    protected final ClusterName clusterName;
    private final Function<BoundTransportAddress, DiscoveryNode> localNodeFactory;
    private final Transport.ResponseHandlers responseHandlers;
    private final Map<Long, TimeoutInfoHolder> timeoutInfoHandlers = Collections.synchronizedMap(new LinkedHashMap<Long, TimeoutInfoHolder>(100, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, TimeoutInfoHolder> eldest) {
            return this.size() > 100;
        }
    });
    private final Logger tracerLog;
    volatile DiscoveryNode localNode = null;
    private final Transport.Connection localNodeConnection = new Transport.Connection(){

        @Override
        public DiscoveryNode getNode() {
            return TransportService.this.localNode;
        }

        @Override
        public void sendRequest(long requestId, String action, TransportRequest request, TransportRequestOptions options) throws TransportException {
            TransportService.this.sendLocalRequest(requestId, action, request, options);
        }

        @Override
        public void addCloseListener(ActionListener<Void> listener) {
        }

        @Override
        public boolean isClosed() {
            return false;
        }

        @Override
        public void close() {
        }
    };
    public static final Set<String> VALID_ACTION_PREFIXES = Set.of("indices:admin", "indices:monitor", "indices:data/write", "indices:data/read", "indices:internal", "cluster:admin", "cluster:monitor", "cluster:internal", "internal:");

    public TransportService(Settings settings, Transport transport, ThreadPool threadPool, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings) {
        this(settings, transport, threadPool, localNodeFactory, clusterSettings, new ClusterConnectionManager(settings, transport));
    }

    public TransportService(Settings settings, Transport transport, ThreadPool threadPool, Function<BoundTransportAddress, DiscoveryNode> localNodeFactory, @Nullable ClusterSettings clusterSettings, ConnectionManager connectionManager) {
        this.transport = transport;
        transport.setSlowLogThreshold(TransportSettings.SLOW_OPERATION_THRESHOLD_SETTING.get(settings));
        this.threadPool = threadPool;
        this.localNodeFactory = localNodeFactory;
        this.connectionManager = connectionManager;
        this.clusterName = ClusterName.CLUSTER_NAME_SETTING.get(settings);
        this.tracerLog = Loggers.getLogger(LOGGER, ".tracer");
        this.responseHandlers = transport.getResponseHandlers();
        if (clusterSettings != null) {
            clusterSettings.addSettingsUpdateConsumer(TransportSettings.SLOW_OPERATION_THRESHOLD_SETTING, transport::setSlowLogThreshold);
        }
        this.registerRequestHandler(HANDSHAKE_ACTION_NAME, "same", false, false, HandshakeRequest::new, (request, channel) -> channel.sendResponse(new HandshakeResponse(this.localNode, this.clusterName, this.localNode.getVersion())));
    }

    public DiscoveryNode getLocalNode() {
        return this.localNode;
    }

    @VisibleForTesting
    public Transport.ResponseHandlers getResponseHandlers() {
        return this.responseHandlers;
    }

    private Executor getExecutorService() {
        return this.threadPool.generic();
    }

    @Override
    protected void doStart() {
        this.transport.setMessageListener(this);
        this.connectionManager.addListener(this);
        this.transport.start();
        if (this.transport.boundAddress() != null && LOGGER.isInfoEnabled()) {
            LOGGER.info("{}", (Object)this.transport.boundAddress());
        }
        this.localNode = this.localNodeFactory.apply(this.transport.boundAddress());
    }

    @Override
    protected void doStop() {
        try {
            Closeable[] closeableArray = new Closeable[2];
            closeableArray[0] = this.connectionManager;
            closeableArray[1] = this.transport::stop;
            IOUtils.close((Closeable[])closeableArray);
        }
        catch (IOException e) {
            try {
                throw new UncheckedIOException(e);
            }
            catch (Throwable throwable) {
                for (Transport.ResponseContext<? extends TransportResponse> holderToNotify : this.responseHandlers.prune(h -> true)) {
                    this.getExecutorService().execute(new RejectableRunnable(){
                        final /* synthetic */ Transport.ResponseContext val$holderToNotify;
                        final /* synthetic */ TransportService this$0;
                        {
                            this.val$holderToNotify = responseContext;
                            this.this$0 = this$0;
                        }

                        @Override
                        public void onRejection(Exception e) {
                            LOGGER.debug(() -> new ParameterizedMessage("failed to notify response handler on rejection, action: {}", (Object)this.val$holderToNotify.action()), (Throwable)e);
                        }

                        @Override
                        public void onFailure(Exception e) {
                            LOGGER.warn(() -> new ParameterizedMessage("failed to notify response handler on exception, action: {}", (Object)this.val$holderToNotify.action()), (Throwable)e);
                        }

                        @Override
                        public void doRun() {
                            SendRequestTransportException ex = new SendRequestTransportException(this.val$holderToNotify.connection().getNode(), this.val$holderToNotify.action(), new NodeClosedException(this.this$0.localNode));
                            this.val$holderToNotify.handler().handleException(ex);
                        }
                    });
                }
                throw throwable;
            }
        }
        for (Transport.ResponseContext<? extends TransportResponse> holderToNotify : this.responseHandlers.prune(h -> true)) {
            this.getExecutorService().execute(new /* invalid duplicate definition of identical inner class */);
        }
    }

    @Override
    protected void doClose() throws IOException {
        this.transport.close();
    }

    public final void acceptIncomingRequests() {
        this.handleIncomingRequests.set(true);
    }

    public ConnectionStats stats() {
        return this.transport.getStats();
    }

    public BoundTransportAddress boundAddress() {
        return this.transport.boundAddress();
    }

    public List<String> getDefaultSeedAddresses() {
        return this.transport.getDefaultSeedAddresses();
    }

    public boolean nodeConnected(DiscoveryNode node) {
        return this.isLocalNode(node) || this.connectionManager.nodeConnected(node);
    }

    public void connectToNode(DiscoveryNode node, ActionListener<Void> listener) throws ConnectTransportException {
        if (this.isLocalNode(node)) {
            listener.onResponse(null);
            return;
        }
        this.connectionManager.connectToNode(node, this.connectionValidator(node), listener);
    }

    public ConnectionManager.ConnectionValidator connectionValidator(DiscoveryNode node) {
        return (newConnection, actualProfile, listener) -> this.handshake(newConnection, actualProfile.getHandshakeTimeout().millis(), clusterName -> true, listener.map(resp -> {
            DiscoveryNode remote = resp.discoveryNode;
            if (!node.equals(remote)) {
                throw new ConnectTransportException(node, "handshake failed. unexpected remote node " + String.valueOf(remote));
            }
            return null;
        }));
    }

    public void openConnection(DiscoveryNode node, ConnectionProfile connectionProfile, ActionListener<Transport.Connection> listener) {
        if (this.isLocalNode(node)) {
            listener.onResponse(this.localNodeConnection);
        } else {
            this.connectionManager.openConnection(node, connectionProfile, listener);
        }
    }

    public void handshake(Transport.Connection connection, long handshakeTimeout, ActionListener<DiscoveryNode> listener) {
        this.handshake(connection, handshakeTimeout, this.clusterName.getEqualityPredicate(), listener.map(HandshakeResponse::getDiscoveryNode));
    }

    public void handshake(Transport.Connection connection, long handshakeTimeout, final Predicate<ClusterName> clusterNamePredicate, final ActionListener<HandshakeResponse> listener) {
        final DiscoveryNode node = connection.getNode();
        this.sendRequest(connection, HANDSHAKE_ACTION_NAME, (TransportRequest)HandshakeRequest.INSTANCE, new TransportRequestOptions(handshakeTimeout), new ActionListenerResponseHandler<HandshakeResponse>(HANDSHAKE_ACTION_NAME, new ActionListener<HandshakeResponse>(this){
            final /* synthetic */ TransportService this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void onResponse(HandshakeResponse response) {
                if (!clusterNamePredicate.test(response.clusterName)) {
                    listener.onFailure(new IllegalStateException("handshake with [" + String.valueOf(node) + "] failed: remote cluster name [" + response.clusterName.value() + "] does not match " + String.valueOf(clusterNamePredicate)));
                } else if (!response.version.isCompatible(this.this$0.localNode.getVersion())) {
                    listener.onFailure(new IllegalStateException("handshake with [" + String.valueOf(node) + "] failed: remote node version [" + String.valueOf(response.version) + "] is incompatible with local node version [" + String.valueOf(this.this$0.localNode.getVersion()) + "]"));
                } else {
                    listener.onResponse(response);
                }
            }

            @Override
            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        }, HandshakeResponse::new, "generic"));
    }

    public ConnectionManager getConnectionManager() {
        return this.connectionManager;
    }

    public void disconnectFromNode(DiscoveryNode node) {
        if (this.isLocalNode(node)) {
            return;
        }
        this.connectionManager.disconnectFromNode(node);
    }

    public void addConnectionListener(TransportConnectionListener listener) {
        this.connectionManager.addListener(listener);
    }

    public void removeConnectionListener(TransportConnectionListener listener) {
        this.connectionManager.removeListener(listener);
    }

    public <T extends TransportResponse> void sendRequest(DiscoveryNode node, String action, TransportRequest request, TransportResponseHandler<T> handler) {
        Transport.Connection connection;
        try {
            connection = this.getConnection(node);
        }
        catch (NodeNotConnectedException ex) {
            handler.handleException(ex);
            return;
        }
        this.sendRequest(connection, action, request, TransportRequestOptions.EMPTY, handler);
    }

    public final <T extends TransportResponse> void sendRequest(DiscoveryNode node, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        Transport.Connection connection;
        try {
            connection = this.getConnection(node);
        }
        catch (NodeNotConnectedException ex) {
            handler.handleException(ex);
            return;
        }
        this.sendRequest(connection, action, request, options, handler);
    }

    public final <T extends TransportResponse> void sendRequest(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        try {
            this.sendRequestInternal(connection, action, request, options, handler);
        }
        catch (Exception ex) {
            if (ex instanceof TransportException) {
                TransportException transportException = (TransportException)ex;
                handler.handleException(transportException);
            }
            handler.handleException(new TransportException("failed to send", ex));
        }
    }

    public Transport.Connection getConnection(DiscoveryNode node) {
        if (this.isLocalNode(node)) {
            return this.localNodeConnection;
        }
        return this.connectionManager.getConnection(node);
    }

    private <T extends TransportResponse> void sendRequestInternal(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        TimeoutResponseHandler<T> timeoutHandler;
        if (connection == null) {
            throw new IllegalStateException("can't send request to a null connection");
        }
        DiscoveryNode node = connection.getNode();
        if (this.lifecycle.stoppedOrClosed()) {
            handler.handleException(new SendRequestTransportException(node, action, new NodeClosedException(this.localNode)));
            return;
        }
        long requestId = this.responseHandlers.newRequestId();
        TimeValue timeout = options.timeout();
        if (timeout != null) {
            timeoutHandler = new TimeoutResponseHandler<T>(handler, requestId, connection.getNode(), action, timeout);
            handler = timeoutHandler;
        } else {
            timeoutHandler = null;
        }
        this.responseHandlers.add(requestId, new Transport.ResponseContext<T>(handler, connection, action));
        if (timeoutHandler != null) {
            timeoutHandler.schedule();
        }
        try {
            connection.sendRequest(requestId, action, request, options);
        }
        catch (Exception e) {
            final Transport.ResponseContext<? extends TransportResponse> contextToNotify = this.responseHandlers.remove(requestId);
            if (contextToNotify == null) {
                LOGGER.debug("Exception while sending request, handler likely already notified due to timeout", (Throwable)e);
                return;
            }
            if (timeoutHandler != null) {
                timeoutHandler.cancel();
            }
            final SendRequestTransportException sendRequestException = new SendRequestTransportException(node, action, e);
            String executor = this.lifecycle.stoppedOrClosed() ? "same" : "generic";
            this.threadPool.executor(executor).execute(new RejectableRunnable(){

                @Override
                public void onRejection(Exception e) {
                    LOGGER.debug(() -> new ParameterizedMessage("failed to notify response handler on rejection, action: {}", (Object)contextToNotify.action()), (Throwable)e);
                }

                @Override
                public void onFailure(Exception e) {
                    LOGGER.warn(() -> new ParameterizedMessage("failed to notify response handler on exception, action: {}", (Object)contextToNotify.action()), (Throwable)e);
                }

                @Override
                public void doRun() throws Exception {
                    contextToNotify.handler().handleException(sendRequestException);
                }
            });
        }
    }

    private void sendLocalRequest(final long requestId, final String action, final TransportRequest request, TransportRequestOptions options) {
        final DirectResponseChannel channel = new DirectResponseChannel(LOGGER, this.localNode, action, requestId, this, this.threadPool);
        try {
            this.onRequestSent(this.localNode, requestId, action, request, options);
            this.onRequestReceived(requestId, action);
            final RequestHandlerRegistry<? extends TransportRequest> reg = this.getRequestHandler(action);
            if (reg == null) {
                throw new ActionNotFoundTransportException("Action [" + action + "] not found");
            }
            String executor = reg.getExecutor();
            if ("same".equals(executor)) {
                reg.processMessageReceived(request, channel);
            } else {
                this.threadPool.executor(executor).execute(new RejectableRunnable(){

                    @Override
                    public void doRun() throws Exception {
                        reg.processMessageReceived(request, channel);
                    }

                    @Override
                    public boolean isForceExecution() {
                        return reg.isForceExecution();
                    }

                    @Override
                    public void onFailure(Exception e) {
                        try {
                            channel.sendResponse(e);
                        }
                        catch (Exception inner) {
                            inner.addSuppressed(e);
                            LOGGER.warn(() -> new ParameterizedMessage("failed to notify channel of error message for action [{}]", (Object)action), (Throwable)inner);
                        }
                    }

                    public String toString() {
                        return "processing of [" + requestId + "][" + action + "]: " + String.valueOf(request);
                    }
                });
            }
        }
        catch (Exception e) {
            try {
                channel.sendResponse(e);
            }
            catch (Exception inner) {
                inner.addSuppressed(e);
                LOGGER.warn(() -> new ParameterizedMessage("failed to notify channel of error message for action [{}]", (Object)action), (Throwable)inner);
            }
        }
    }

    public TransportAddress[] addressesFromString(String address) throws UnknownHostException {
        return this.transport.addressesFromString(address);
    }

    private void validateActionName(String actionName) {
        assert (TransportService.isValidActionName(actionName)) : "invalid action name [" + actionName + "] must start with one of: " + String.valueOf(VALID_ACTION_PREFIXES);
    }

    private static boolean isValidActionName(String actionName) {
        for (String prefix : VALID_ACTION_PREFIXES) {
            if (!actionName.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }

    public <Request extends TransportRequest> void registerRequestHandler(String action, String executor, Writeable.Reader<Request> requestReader, TransportRequestHandler<Request> handler) {
        this.validateActionName(action);
        RequestHandlerRegistry<Request> reg = new RequestHandlerRegistry<Request>(action, requestReader, handler, executor, false, true);
        this.transport.registerRequestHandler(reg);
    }

    public <Request extends TransportRequest> void registerRequestHandler(String action, String executor, boolean forceExecution, boolean canTripCircuitBreaker, Writeable.Reader<Request> requestReader, TransportRequestHandler<Request> handler) {
        this.validateActionName(action);
        RequestHandlerRegistry<Request> reg = new RequestHandlerRegistry<Request>(action, requestReader, handler, executor, forceExecution, canTripCircuitBreaker);
        this.transport.registerRequestHandler(reg);
    }

    @Override
    public void onRequestReceived(long requestId, String action) {
        if (!this.handleIncomingRequests.get()) {
            throw new IllegalStateException("transport not ready yet to handle incoming requests");
        }
        if (this.tracerLog.isTraceEnabled()) {
            this.tracerLog.trace("[{}][{}] received request", (Object)requestId, (Object)action);
        }
    }

    @Override
    public void onRequestSent(DiscoveryNode node, long requestId, String action, TransportRequest request, TransportRequestOptions options) {
        if (this.tracerLog.isTraceEnabled()) {
            this.tracerLog.trace("[{}][{}] sent to [{}] (timeout: [{}])", (Object)requestId, (Object)action, (Object)node, (Object)options.timeout());
        }
    }

    @Override
    public void onResponseReceived(long requestId, Transport.ResponseContext<?> holder) {
        if (holder == null) {
            this.checkForTimeout(requestId);
        } else if (this.tracerLog.isTraceEnabled()) {
            this.tracerLog.trace("[{}][{}] received response from [{}]", (Object)requestId, (Object)holder.action(), (Object)holder.connection().getNode());
        }
    }

    @Override
    public void onResponseSent(long requestId, String action, TransportResponse response) {
        if (this.tracerLog.isTraceEnabled()) {
            this.tracerLog.trace("[{}][{}] sent response", (Object)requestId, (Object)action);
        }
    }

    @Override
    public void onResponseSent(long requestId, String action, Exception e) {
        if (this.tracerLog.isTraceEnabled()) {
            this.tracerLog.trace(() -> new ParameterizedMessage("[{}][{}] sent error response", (Object)requestId, (Object)action), (Throwable)e);
        }
    }

    public RequestHandlerRegistry<? extends TransportRequest> getRequestHandler(String action) {
        return this.transport.getRequestHandlers().getHandler(action);
    }

    private void checkForTimeout(long requestId) {
        DiscoveryNode sourceNode;
        String action;
        assert (!this.responseHandlers.contains(requestId));
        TimeoutInfoHolder timeoutInfoHolder = this.timeoutInfoHandlers.remove(requestId);
        if (timeoutInfoHolder != null) {
            long time = this.threadPool.relativeTimeInMillis();
            LOGGER.warn("Received response for a request that has timed out, sent [{}ms] ago, timed out [{}ms] ago, action [{}], node [{}], id [{}]", (Object)(time - timeoutInfoHolder.sentTime()), (Object)(time - timeoutInfoHolder.timeoutTime()), (Object)timeoutInfoHolder.action(), (Object)timeoutInfoHolder.node(), (Object)requestId);
            action = timeoutInfoHolder.action();
            sourceNode = timeoutInfoHolder.node();
        } else {
            LOGGER.warn("Transport response handler not found of id [{}]", (Object)requestId);
            action = null;
            sourceNode = null;
        }
        if (!this.tracerLog.isTraceEnabled()) {
            return;
        }
        if (action == null) {
            assert (sourceNode == null);
            this.tracerLog.trace("[{}] received response but can't resolve it to a request", (Object)requestId);
        } else {
            this.tracerLog.trace("[{}][{}] received response from [{}]", (Object)requestId, action, sourceNode);
        }
    }

    @Override
    public void onConnectionClosed(Transport.Connection connection) {
        try {
            List<Transport.ResponseContext<? extends TransportResponse>> pruned = this.responseHandlers.prune(h -> h.connection().getCacheKey().equals(connection.getCacheKey()));
            this.getExecutorService().execute(() -> {
                for (Transport.ResponseContext holderToNotify : pruned) {
                    holderToNotify.handler().handleException(new NodeDisconnectedException(connection.getNode(), holderToNotify.action()));
                }
            });
        }
        catch (EsRejectedExecutionException ex) {
            LOGGER.debug("Rejected execution on onConnectionClosed", (Throwable)ex);
        }
    }

    public ThreadPool getThreadPool() {
        return this.threadPool;
    }

    private boolean isLocalNode(DiscoveryNode discoveryNode) {
        return Objects.requireNonNull(discoveryNode, "discovery node must not be null").equals(this.localNode);
    }

    static class HandshakeRequest
    extends TransportRequest {
        public static final HandshakeRequest INSTANCE = new HandshakeRequest();

        private HandshakeRequest() {
        }

        public HandshakeRequest(StreamInput in) throws IOException {
            super(in);
        }
    }

    public final class TimeoutResponseHandler<T extends TransportResponse>
    implements TransportResponseHandler<T>,
    Runnable {
        private final TransportResponseHandler<T> delegate;
        private final long requestId;
        private final long sentTime;
        private final String action;
        private final DiscoveryNode node;
        private final TimeValue timeout;
        private Scheduler.Cancellable cancellable;

        public TimeoutResponseHandler(TransportResponseHandler<T> delegate, long requestId, DiscoveryNode node, String action, TimeValue timeout) {
            this.sentTime = TransportService.this.threadPool.relativeTimeInMillis();
            this.delegate = delegate;
            this.requestId = requestId;
            this.node = node;
            this.action = action;
            this.timeout = timeout;
        }

        private void cancel() {
            assert (!TransportService.this.responseHandlers.contains(this.requestId)) : "cancel must be called after the requestId [" + this.requestId + "] has been removed from clientHandlers";
            if (this.cancellable != null) {
                this.cancellable.cancel();
            }
        }

        void schedule() {
            this.cancellable = TransportService.this.threadPool.schedule(this, this.timeout, "generic");
        }

        @Override
        public void run() {
            if (TransportService.this.responseHandlers.contains(this.requestId)) {
                long timeoutTime = TransportService.this.threadPool.relativeTimeInMillis();
                TransportService.this.timeoutInfoHandlers.put(this.requestId, new TimeoutInfoHolder(this.node, this.action, this.sentTime, timeoutTime));
                Transport.ResponseContext<? extends TransportResponse> holder = TransportService.this.responseHandlers.remove(this.requestId);
                if (holder != null) {
                    assert (holder.action().equals(this.action));
                    assert (holder.connection().getNode().equals(this.node));
                    holder.handler().handleException(new ReceiveTimeoutTransportException(holder.connection().getNode(), holder.action(), "request_id [" + this.requestId + "] timed out after [" + (timeoutTime - this.sentTime) + "ms]"));
                } else {
                    TransportService.this.timeoutInfoHandlers.remove(this.requestId);
                }
            }
        }

        @Override
        public T read(StreamInput in) throws IOException {
            return (T)this.delegate.read(in);
        }

        @Override
        public void handleResponse(T response) {
            this.cancel();
            this.delegate.handleResponse(response);
        }

        @Override
        public void handleException(TransportException exp) {
            this.cancel();
            this.delegate.handleException(exp);
        }

        @Override
        public String executor() {
            return this.delegate.executor();
        }

        public String toString() {
            return this.getClass().getName() + "/" + this.delegate.toString();
        }
    }

    static class DirectResponseChannel
    implements TransportChannel {
        final Logger logger;
        final DiscoveryNode localNode;
        private final String action;
        private final long requestId;
        final TransportService service;
        final ThreadPool threadPool;

        DirectResponseChannel(Logger logger, DiscoveryNode localNode, String action, long requestId, TransportService service, ThreadPool threadPool) {
            this.logger = logger;
            this.localNode = localNode;
            this.action = action;
            this.requestId = requestId;
            this.service = service;
            this.threadPool = threadPool;
        }

        @Override
        public void sendResponse(final TransportResponse response) throws IOException {
            this.service.onResponseSent(this.requestId, this.action, response);
            final TransportResponseHandler<? extends TransportResponse> handler = this.service.responseHandlers.onResponseReceived(this.requestId, this.service);
            if (handler != null) {
                String executor = handler.executor();
                if ("same".equals(executor)) {
                    this.processResponse(handler, response);
                } else {
                    this.threadPool.executor(executor).execute(new Runnable(){
                        final /* synthetic */ DirectResponseChannel this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            this.this$0.processResponse(handler, response);
                        }

                        public String toString() {
                            return "delivery of response to [" + this.this$0.requestId + "][" + this.this$0.action + "]: " + String.valueOf(response);
                        }
                    });
                }
            }
        }

        protected void processResponse(TransportResponseHandler handler, TransportResponse response) {
            try {
                handler.handleResponse(response);
            }
            catch (Exception e) {
                this.processException(handler, this.wrapInRemote(new ResponseHandlerFailureTransportException(e)));
            }
        }

        @Override
        public void sendResponse(final Exception exception) throws IOException {
            this.service.onResponseSent(this.requestId, this.action, exception);
            final TransportResponseHandler<? extends TransportResponse> handler = this.service.responseHandlers.onResponseReceived(this.requestId, this.service);
            if (handler != null) {
                final RemoteTransportException rtx = this.wrapInRemote(exception);
                String executor = handler.executor();
                if ("same".equals(executor)) {
                    this.processException(handler, rtx);
                } else {
                    this.threadPool.executor(handler.executor()).execute(new Runnable(){
                        final /* synthetic */ DirectResponseChannel this$0;
                        {
                            this.this$0 = this$0;
                        }

                        @Override
                        public void run() {
                            this.this$0.processException(handler, rtx);
                        }

                        public String toString() {
                            return "delivery of failure response to [" + this.this$0.requestId + "][" + this.this$0.action + "]: " + String.valueOf(exception);
                        }
                    });
                }
            }
        }

        protected RemoteTransportException wrapInRemote(Exception e) {
            if (e instanceof RemoteTransportException) {
                RemoteTransportException rte = (RemoteTransportException)e;
                return rte;
            }
            return new RemoteTransportException(this.localNode.getName(), this.localNode.getAddress(), this.action, e);
        }

        protected void processException(TransportResponseHandler<?> handler, RemoteTransportException rtx) {
            try {
                handler.handleException(rtx);
            }
            catch (Exception e) {
                this.logger.error(() -> new ParameterizedMessage("failed to handle exception for action [{}], handler [{}]", (Object)this.action, (Object)handler), (Throwable)e);
            }
        }

        @Override
        public String getChannelType() {
            return "direct";
        }

        @Override
        public Version getVersion() {
            return this.localNode.getVersion();
        }
    }

    record TimeoutInfoHolder(DiscoveryNode node, String action, long sentTime, long timeoutTime) {
    }

    public static class HandshakeResponse
    extends TransportResponse {
        private final DiscoveryNode discoveryNode;
        private final ClusterName clusterName;
        private final Version version;

        public HandshakeResponse(DiscoveryNode discoveryNode, ClusterName clusterName, Version version) {
            this.discoveryNode = discoveryNode;
            this.version = version;
            this.clusterName = clusterName;
        }

        public HandshakeResponse(StreamInput in) throws IOException {
            this.discoveryNode = in.readOptionalWriteable(DiscoveryNode::new);
            this.clusterName = new ClusterName(in);
            this.version = Version.readVersion(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalWriteable(this.discoveryNode);
            this.clusterName.writeTo(out);
            Version.writeVersion(this.version, out);
        }

        public DiscoveryNode getDiscoveryNode() {
            return this.discoveryNode;
        }

        public ClusterName getClusterName() {
            return this.clusterName;
        }
    }
}

