/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql;

import io.crate.sql.parser.ParsingException;
import io.crate.sql.parser.SqlParser;
import io.crate.sql.parser.antlr.SqlBaseLexer;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.FunctionCall;
import io.crate.sql.tree.QualifiedNameReference;
import java.util.Collection;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.antlr.v4.runtime.Vocabulary;

public final class Identifiers {
    private static final Pattern IDENTIFIER = Pattern.compile("(^[a-zA-Z_]+[a-zA-Z0-9_]*)");
    private static final Pattern ESCAPE_REPLACE_RE = Pattern.compile("\"", 16);
    private static final String ESCAPE_REPLACEMENT = Matcher.quoteReplacement("\"\"");
    public static final Set<String> RESERVED_FUNCTIONS = Set.of("current_catalog", "current_role", "current_session", "current_user", "user", "session_user");
    public static final Set<String> PARENTHESIS_LESS_FUNCTIONS = Set.of("current_date", "current_time", "current_timestamp", "current_catalog", "current_schema", "current_user", "current_role", "user", "session_user");
    public static final Collection<Keyword> KEYWORDS = Identifiers.identifierCandidates();
    private static final Set<String> RESERVED_KEYWORDS = KEYWORDS.stream().filter(Keyword::reserved).map(Keyword::word).collect(Collectors.toSet());

    private Identifiers() {
    }

    public static String quote(String identifier) {
        return "\"" + Identifiers.escape(identifier) + "\"";
    }

    public static String quoteIfNeeded(String identifier) {
        if (Identifiers.quotesRequired(false, identifier)) {
            return Identifiers.quote(identifier);
        }
        return identifier;
    }

    public static String quoteFunctionIfNeeded(String identifier) {
        if (Identifiers.quotesRequired(true, identifier)) {
            return Identifiers.quote(identifier);
        }
        return identifier;
    }

    private static boolean quotesRequired(boolean isFunction, String identifier) {
        return Identifiers.isKeyWord(identifier) && !Identifiers.isParenthesisLessFunction(isFunction, identifier) || !Identifiers.quotesNotRequired(identifier);
    }

    private static boolean isParenthesisLessFunction(boolean isFunction, String identifier) {
        return isFunction && PARENTHESIS_LESS_FUNCTIONS.contains(identifier);
    }

    public static boolean isKeyWord(String identifier) {
        return RESERVED_KEYWORDS.contains(identifier.toUpperCase(Locale.ENGLISH));
    }

    private static boolean quotesNotRequired(String identifier) {
        assert (identifier != null && !identifier.isEmpty()) : "null or empty idents should not be possible";
        char c = identifier.charAt(0);
        if (c != '_' && !Identifiers.isLowerCase(c)) {
            return false;
        }
        for (int i = 1; i < identifier.length(); ++i) {
            c = identifier.charAt(i);
            if (c == '_' || Identifiers.isLowerCase(c) || Identifiers.isDigit(c)) continue;
            return false;
        }
        return true;
    }

    private static boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private static boolean isLowerCase(char c) {
        return c >= 'a' && c <= 'z';
    }

    private static boolean reserved(String expression) {
        try {
            Expression expr = SqlParser.createExpression(expression);
            if (RESERVED_FUNCTIONS.contains(expression.toLowerCase(Locale.ENGLISH))) {
                return true;
            }
            return !(expr instanceof QualifiedNameReference) && !(expr instanceof FunctionCall);
        }
        catch (ParsingException ignored) {
            return true;
        }
    }

    private static Set<Keyword> identifierCandidates() {
        HashSet<Keyword> candidates = new HashSet<Keyword>();
        Vocabulary vocabulary = SqlBaseLexer.VOCABULARY;
        for (int i = 0; i < vocabulary.getMaxTokenType(); ++i) {
            Matcher matcher;
            String literal = vocabulary.getLiteralName(i);
            if (literal == null || !(matcher = IDENTIFIER.matcher(literal = literal.replace("'", ""))).matches()) continue;
            candidates.add(new Keyword(literal, Identifiers.reserved(literal)));
        }
        return candidates;
    }

    public static String escape(String identifier) {
        return ESCAPE_REPLACE_RE.matcher(identifier).replaceAll(ESCAPE_REPLACEMENT);
    }

    public record Keyword(String word, boolean reserved) {
    }
}

