/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql;

import io.crate.common.collections.Lists;
import io.crate.sql.ExpressionFormatter;
import io.crate.sql.Identifiers;
import io.crate.sql.Literals;
import io.crate.sql.tree.AliasedRelation;
import io.crate.sql.tree.AllColumns;
import io.crate.sql.tree.AlterPublication;
import io.crate.sql.tree.AlterRoleReset;
import io.crate.sql.tree.AlterRoleSet;
import io.crate.sql.tree.AlterServer;
import io.crate.sql.tree.AlterSubscription;
import io.crate.sql.tree.Assignment;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.CascadeMode;
import io.crate.sql.tree.CheckColumnConstraint;
import io.crate.sql.tree.CheckConstraint;
import io.crate.sql.tree.Close;
import io.crate.sql.tree.ClusteredBy;
import io.crate.sql.tree.CollectionColumnType;
import io.crate.sql.tree.ColumnConstraint;
import io.crate.sql.tree.ColumnDefinition;
import io.crate.sql.tree.ColumnStorageDefinition;
import io.crate.sql.tree.ColumnType;
import io.crate.sql.tree.CopyFrom;
import io.crate.sql.tree.CreateForeignTable;
import io.crate.sql.tree.CreateFunction;
import io.crate.sql.tree.CreatePublication;
import io.crate.sql.tree.CreateRole;
import io.crate.sql.tree.CreateServer;
import io.crate.sql.tree.CreateSnapshot;
import io.crate.sql.tree.CreateSubscription;
import io.crate.sql.tree.CreateTable;
import io.crate.sql.tree.CreateTableAs;
import io.crate.sql.tree.CreateUserMapping;
import io.crate.sql.tree.Declare;
import io.crate.sql.tree.DecommissionNodeStatement;
import io.crate.sql.tree.DefaultConstraint;
import io.crate.sql.tree.DenyPrivilege;
import io.crate.sql.tree.DropAnalyzer;
import io.crate.sql.tree.DropBlobTable;
import io.crate.sql.tree.DropForeignTable;
import io.crate.sql.tree.DropFunction;
import io.crate.sql.tree.DropPublication;
import io.crate.sql.tree.DropRepository;
import io.crate.sql.tree.DropRole;
import io.crate.sql.tree.DropServer;
import io.crate.sql.tree.DropSnapshot;
import io.crate.sql.tree.DropSubscription;
import io.crate.sql.tree.DropTable;
import io.crate.sql.tree.DropUserMapping;
import io.crate.sql.tree.DropView;
import io.crate.sql.tree.EscapedCharStringLiteral;
import io.crate.sql.tree.Explain;
import io.crate.sql.tree.Expression;
import io.crate.sql.tree.Fetch;
import io.crate.sql.tree.FunctionArgument;
import io.crate.sql.tree.GCDanglingArtifacts;
import io.crate.sql.tree.GeneratedExpressionConstraint;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.GrantPrivilege;
import io.crate.sql.tree.GroupBy;
import io.crate.sql.tree.IndexColumnConstraint;
import io.crate.sql.tree.IndexDefinition;
import io.crate.sql.tree.Insert;
import io.crate.sql.tree.IntegerLiteral;
import io.crate.sql.tree.IntervalLiteral;
import io.crate.sql.tree.Join;
import io.crate.sql.tree.JoinCriteria;
import io.crate.sql.tree.JoinOn;
import io.crate.sql.tree.JoinType;
import io.crate.sql.tree.JoinUsing;
import io.crate.sql.tree.LongLiteral;
import io.crate.sql.tree.NaturalJoin;
import io.crate.sql.tree.Node;
import io.crate.sql.tree.NotNullColumnConstraint;
import io.crate.sql.tree.NullColumnConstraint;
import io.crate.sql.tree.ObjectColumnType;
import io.crate.sql.tree.PartitionedBy;
import io.crate.sql.tree.PrimaryKeyColumnConstraint;
import io.crate.sql.tree.PrimaryKeyConstraint;
import io.crate.sql.tree.PrivilegeStatement;
import io.crate.sql.tree.QualifiedName;
import io.crate.sql.tree.Query;
import io.crate.sql.tree.QuerySpecification;
import io.crate.sql.tree.RefreshStatement;
import io.crate.sql.tree.Relation;
import io.crate.sql.tree.RevokePrivilege;
import io.crate.sql.tree.Select;
import io.crate.sql.tree.SelectItem;
import io.crate.sql.tree.SetSessionAuthorizationStatement;
import io.crate.sql.tree.SingleColumn;
import io.crate.sql.tree.SortItem;
import io.crate.sql.tree.StringLiteral;
import io.crate.sql.tree.SwapTable;
import io.crate.sql.tree.Table;
import io.crate.sql.tree.TableFunction;
import io.crate.sql.tree.TableSubquery;
import io.crate.sql.tree.Union;
import io.crate.sql.tree.Update;
import io.crate.sql.tree.Values;
import io.crate.sql.tree.ValuesList;
import io.crate.sql.tree.Window;
import io.crate.sql.tree.WindowFrame;
import io.crate.sql.tree.With;
import io.crate.sql.tree.WithQuery;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.jetbrains.annotations.Nullable;

public final class SqlFormatter {
    private static final String INDENT = "   ";
    private static final Collector<CharSequence, ?, String> COMMA_JOINER = Collectors.joining(", ");

    private SqlFormatter() {
    }

    public static String formatSql(Node root) {
        return SqlFormatter.formatSql(root, null, "\n", 1);
    }

    public static String formatSqlInline(Node root) {
        return SqlFormatter.formatSql(root, null, "", 0);
    }

    public static String formatSql(Node root, @Nullable List<Expression> parameters) {
        return SqlFormatter.formatSql(root, parameters, "\n", 1);
    }

    private static String formatSql(Node root, @Nullable List<Expression> parameters, String newLine, int indentBy) {
        StringBuilder builder = new StringBuilder();
        Formatter formatter = new Formatter(builder, parameters, newLine, indentBy);
        root.accept(formatter, 0);
        return builder.toString();
    }

    static String formatSortItem(SortItem sortItem, List<Expression> parameters) {
        StringBuilder sb = new StringBuilder();
        sb.append(ExpressionFormatter.formatStandaloneExpression(sortItem.getSortKey(), parameters));
        switch (sortItem.getOrdering()) {
            case ASCENDING: {
                sb.append(" ASC");
                break;
            }
            case DESCENDING: {
                sb.append(" DESC");
                break;
            }
            default: {
                throw new UnsupportedOperationException("unknown ordering: " + String.valueOf((Object)sortItem.getOrdering()));
            }
        }
        switch (sortItem.getNullOrdering()) {
            case FIRST: {
                sb.append(" NULLS FIRST");
                break;
            }
            case LAST: {
                sb.append(" NULLS LAST");
                break;
            }
        }
        return sb.toString();
    }

    private static class Formatter
    extends AstVisitor<Void, Integer> {
        private final StringBuilder builder;
        @Nullable
        private final List<Expression> parameters;
        private final String newLine;
        private final int indentBy;

        Formatter(StringBuilder builder, @Nullable List<Expression> parameters, String newLine, int indentBy) {
            this.builder = builder;
            this.parameters = parameters;
            this.newLine = newLine;
            this.indentBy = indentBy;
        }

        @Override
        protected Void visitNode(Node node, Integer indent) {
            throw new UnsupportedOperationException("not yet implemented: " + String.valueOf(node));
        }

        @Override
        public Void visitSwapTable(SwapTable<?> swapTable, Integer indent) {
            this.append(indent, "ALTER CLUSTER SWAP TABLE ");
            this.append(indent, swapTable.source().toString());
            this.append(indent, " TO ");
            this.append(indent, swapTable.target().toString());
            if (!swapTable.properties().isEmpty()) {
                this.append(indent, " ");
                swapTable.properties().accept(this, indent);
            }
            return null;
        }

        @Override
        public Void visitCreateServer(CreateServer createServer, Integer indent) {
            this.append(indent, "CREATE SERVER ");
            if (createServer.ifNotExists()) {
                this.append(indent, "IF NOT EXISTS ");
            }
            this.append(indent, createServer.name());
            this.append(indent, " FOREIGN DATA WRAPPER ");
            this.append(indent, createServer.fdw());
            Map<String, Expression> options = createServer.options();
            if (!options.isEmpty()) {
                this.append(indent, " OPTIONS (");
                Iterator<Map.Entry<String, Expression>> it = options.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Expression> entry = it.next();
                    String optionName = entry.getKey();
                    Expression optionValue = entry.getValue();
                    this.append(indent, optionName);
                    this.append(indent, " ");
                    optionValue.accept(this, indent);
                    if (!it.hasNext()) continue;
                    this.append(indent, ", ");
                }
                this.append(indent, ")");
            }
            return null;
        }

        @Override
        public Void visitAlterServer(AlterServer<?> alterServerGen, Integer indent) {
            AlterServer<?> alterServer = alterServerGen;
            this.append(indent, "ALTER SERVER ");
            this.append(indent, alterServer.name());
            List<AlterServer.Option<?>> options = alterServer.options();
            if (!options.isEmpty()) {
                this.append(indent, " OPTIONS (");
                Iterator<AlterServer.Option<?>> it = options.iterator();
                while (it.hasNext()) {
                    AlterServer.Option<?> entry = it.next();
                    AlterServer.Operation operation = entry.operation();
                    String optionName = entry.key();
                    Expression optionValue = (Expression)entry.value();
                    if (operation != null) {
                        this.append(indent, operation.name());
                        this.append(indent, " ");
                    }
                    this.append(indent, optionName);
                    this.append(indent, " ");
                    if (optionValue != null) {
                        optionValue.accept(this, indent);
                    }
                    if (!it.hasNext()) continue;
                    this.append(indent, ", ");
                }
                this.append(indent, ")");
            }
            return null;
        }

        @Override
        public Void visitDropServer(DropServer dropServer, Integer indent) {
            this.append(indent, "DROP SERVER ");
            if (dropServer.ifExists()) {
                this.append(indent, "IF EXISTS ");
            }
            Iterator<String> namesIt = dropServer.names().iterator();
            while (namesIt.hasNext()) {
                this.append(indent, namesIt.next());
                if (!namesIt.hasNext()) continue;
                this.append(indent, ", ");
            }
            this.append(indent, " ");
            this.append(indent, dropServer.cascadeMode() == CascadeMode.CASCADE ? "CASCADE" : "RESTRICT");
            return null;
        }

        @Override
        public Void visitGCDanglingArtifacts(GCDanglingArtifacts gcDanglingArtifacts, Integer indent) {
            this.append(indent, "ALTER CLUSTER GC DANGLING ARTIFACTS");
            return null;
        }

        @Override
        public Void visitAlterClusterDecommissionNode(DecommissionNodeStatement<?> decommissionNode, Integer indent) {
            this.append(indent, "ALTER CLUSTER DECOMMISSION ");
            ((Expression)decommissionNode.nodeIdOrName()).accept(this, indent);
            return null;
        }

        @Override
        public Void visitCopyFrom(CopyFrom<?> node, Integer indent) {
            CopyFrom<?> copyFrom = node;
            this.append(indent, "COPY ");
            copyFrom.table().accept(this, indent);
            Iterator<String> columns = node.columns().iterator();
            if (columns.hasNext()) {
                this.builder.append('(');
                while (columns.hasNext()) {
                    this.builder.append(columns.next());
                    if (!columns.hasNext()) continue;
                    this.builder.append(", ");
                }
                this.builder.append(')');
            }
            this.append(indent, " FROM ");
            ((Expression)copyFrom.path()).accept(this, indent);
            if (!copyFrom.properties().isEmpty()) {
                this.append(indent, " ");
                copyFrom.properties().accept(this, indent);
            }
            if (copyFrom.isReturnSummary()) {
                this.append(indent, " RETURN SUMMARY");
            }
            return null;
        }

        @Override
        public Void visitRefreshStatement(RefreshStatement<?> node, Integer indent) {
            this.append(indent, "REFRESH TABLE ");
            this.appendFlatNodeList(node.tables(), indent);
            return null;
        }

        @Override
        protected Void visitExplain(Explain node, Integer indent) {
            this.append(indent, "EXPLAIN");
            Map<Explain.Option, Boolean> options = node.options();
            if (!options.isEmpty()) {
                this.builder.append(" (");
                Iterator<Map.Entry<Explain.Option, Boolean>> entries = options.entrySet().iterator();
                while (entries.hasNext()) {
                    Map.Entry<Explain.Option, Boolean> entry = entries.next();
                    this.builder.append(entry.getKey().name());
                    Boolean value = entry.getValue();
                    if (value != null) {
                        this.builder.append(' ');
                        this.builder.append(value);
                    }
                    if (!entries.hasNext()) continue;
                    this.builder.append(" , ");
                }
                this.builder.append(')');
            }
            this.builder.append(' ');
            this.builder.append(SqlFormatter.formatSql(node.getStatement()));
            return null;
        }

        @Override
        public Void visitInsert(Insert<?> node, Integer indent) {
            Iterator<SelectItem> returning;
            this.append(indent, "INSERT");
            this.builder.append(' ');
            this.append(indent, "INTO");
            this.builder.append(' ');
            node.table().accept(this, indent);
            this.builder.append(' ');
            Iterator<String> columns = node.columns().iterator();
            if (columns.hasNext()) {
                this.builder.append('(');
                while (columns.hasNext()) {
                    this.builder.append(columns.next());
                    if (!columns.hasNext()) continue;
                    this.builder.append(", ");
                }
                this.builder.append(')');
            }
            this.builder.append(' ');
            node.insertSource().accept(this, indent);
            Insert.DuplicateKeyContext<?> duplicateKeyContext = node.duplicateKeyContext();
            if (duplicateKeyContext.getType() != Insert.DuplicateKeyContext.Type.NONE) {
                this.builder.append(" ON CONFLICT");
                Iterator<?> constraintColumns = duplicateKeyContext.getConstraintColumns().iterator();
                if (constraintColumns.hasNext()) {
                    this.builder.append(" (");
                    while (constraintColumns.hasNext()) {
                        this.builder.append(constraintColumns.next());
                        if (!constraintColumns.hasNext()) continue;
                        this.builder.append(", ");
                    }
                    this.builder.append(')');
                }
                switch (duplicateKeyContext.getType()) {
                    case ON_CONFLICT_DO_NOTHING: {
                        this.builder.append(" DO NOTHING");
                        break;
                    }
                    case ON_CONFLICT_DO_UPDATE_SET: {
                        this.builder.append(" DO UPDATE");
                        Iterator<Assignment<?>> assignments = duplicateKeyContext.getAssignments().iterator();
                        if (!assignments.hasNext()) break;
                        this.builder.append(" SET ");
                        while (assignments.hasNext()) {
                            assignments.next().accept(this, indent);
                            if (!assignments.hasNext()) continue;
                            this.builder.append(", ");
                        }
                        break;
                    }
                }
            }
            if ((returning = node.returningClause().iterator()).hasNext()) {
                this.append(indent, "RETURNING");
                while (returning.hasNext()) {
                    this.builder.append(' ');
                    returning.next().accept(this, indent);
                    if (!returning.hasNext()) continue;
                    this.builder.append(',');
                }
            }
            return null;
        }

        @Override
        public Void visitUpdate(Update node, Integer indent) {
            this.append(indent, "UPDATE");
            this.builder.append(' ');
            node.relation().accept(this, indent);
            this.builder.append(' ');
            if (!node.assignments().isEmpty()) {
                this.append(indent, "SET");
                this.builder.append(' ');
                Iterator<Assignment<Expression>> assignments = node.assignments().iterator();
                while (assignments.hasNext()) {
                    assignments.next().accept(this, indent);
                    if (!assignments.hasNext()) continue;
                    this.builder.append(',');
                }
                this.builder.append(' ');
            }
            node.whereClause().ifPresent(x -> {
                this.append(indent, "WHERE");
                this.builder.append(' ');
                x.accept(this, indent);
                this.builder.append(' ');
            });
            if (!node.returningClause().isEmpty()) {
                this.append(indent, "RETURNING");
                Iterator<SelectItem> returningItems = node.returningClause().iterator();
                while (returningItems.hasNext()) {
                    this.builder.append(' ');
                    returningItems.next().accept(this, indent);
                    if (!returningItems.hasNext()) continue;
                    this.builder.append(',');
                }
            }
            return null;
        }

        @Override
        public Void visitAssignment(Assignment<?> node, Integer indent) {
            Assignment<?> assignment = node;
            ((Expression)assignment.columnName()).accept(this, indent);
            this.append(indent, "=");
            ((Expression)assignment.expression()).accept(this, indent);
            return null;
        }

        @Override
        protected Void visitExpression(Expression node, Integer indent) {
            this.builder.append(ExpressionFormatter.formatStandaloneExpression(node, this.parameters));
            return null;
        }

        @Override
        protected Void visitQuery(Query node, Integer indent) {
            if (node.getWith().isPresent()) {
                node.getWith().get().accept(this, indent);
            }
            node.getQueryBody().accept(this, indent);
            if (!node.getOrderBy().isEmpty()) {
                this.append(indent, " ");
                this.append(indent, "ORDER BY " + node.getOrderBy().stream().map(e -> SqlFormatter.formatSortItem(e, this.parameters)).collect(COMMA_JOINER)).append(this.newLine);
            }
            if (node.getLimit().isPresent()) {
                this.append(indent, "LIMIT " + String.valueOf(node.getLimit().get())).append(this.newLine);
            }
            if (node.getOffset().isPresent()) {
                this.append(indent, "OFFSET " + String.valueOf(node.getOffset().get())).append(this.newLine);
            }
            return null;
        }

        @Override
        protected Void visitQuerySpecification(QuerySpecification node, Integer indent) {
            node.getSelect().accept(this, indent);
            if (!node.getFrom().isEmpty()) {
                this.appendNewLineOrSpace();
                this.append(indent, "FROM");
                if (node.getFrom().size() > 1) {
                    this.appendNewLineOrSpace();
                    this.append(indent, " ");
                    Iterator<Relation> relations = node.getFrom().iterator();
                    while (relations.hasNext()) {
                        relations.next().accept(this, indent);
                        if (!relations.hasNext()) continue;
                        this.builder.append(this.newLine);
                        this.append(indent, ", ");
                    }
                } else {
                    this.builder.append(' ');
                    ((Relation)Lists.getOnlyElement(node.getFrom())).accept(this, indent);
                }
            }
            if (node.getWhere().isPresent()) {
                this.appendNewLineOrSpace();
                this.append(indent, "WHERE " + ExpressionFormatter.formatStandaloneExpression(node.getWhere().get(), this.parameters));
            }
            if (node.getGroupBy().isPresent()) {
                this.appendNewLineOrSpace();
                GroupBy groupBy = node.getGroupBy().get();
                if (groupBy.isAll()) {
                    this.append(indent, "GROUP BY ALL");
                } else if (!groupBy.getExpressions().isEmpty()) {
                    this.append(indent, "GROUP BY ");
                    this.append(indent, groupBy.getExpressions().stream().map(e -> ExpressionFormatter.formatStandaloneExpression(e, this.parameters)).collect(COMMA_JOINER));
                }
            }
            if (node.getHaving().isPresent()) {
                this.appendNewLineOrSpace();
                this.append(indent, "HAVING " + ExpressionFormatter.formatStandaloneExpression(node.getHaving().get(), this.parameters));
            }
            if (!node.getWindows().isEmpty()) {
                this.appendNewLineOrSpace();
                this.append(indent, "WINDOW ");
                Iterator<Map.Entry<String, Window>> windows = node.getWindows().entrySet().iterator();
                while (windows.hasNext()) {
                    Map.Entry<String, Window> window = windows.next();
                    this.append(indent, window.getKey()).append(" AS ");
                    window.getValue().accept(this, indent);
                    if (!windows.hasNext()) continue;
                    this.append(indent, ", ");
                }
            }
            if (!node.getOrderBy().isEmpty()) {
                this.appendNewLineOrSpace();
                this.append(indent, "ORDER BY " + node.getOrderBy().stream().map(e -> SqlFormatter.formatSortItem(e, this.parameters)).collect(COMMA_JOINER));
            }
            if (node.getLimit().isPresent()) {
                this.appendNewLineOrSpace();
                this.append(indent, "LIMIT " + String.valueOf(node.getLimit().get()));
            }
            if (node.getOffset().isPresent()) {
                this.appendNewLineOrSpace();
                this.append(indent, "OFFSET " + String.valueOf(node.getOffset().get()));
            }
            this.builder.append(this.newLine);
            return null;
        }

        @Override
        public Void visitValues(Values values, Integer indent) {
            this.append(indent, "VALUES ");
            List<ValuesList> rows = values.rows();
            for (int i = 0; i < rows.size(); ++i) {
                ValuesList row = rows.get(i);
                this.append(indent, "(");
                List<Expression> expressions = row.values();
                for (int j = 0; j < expressions.size(); ++j) {
                    Expression value = expressions.get(j);
                    this.append(indent, ExpressionFormatter.formatExpression(value));
                    if (j + 1 >= expressions.size()) continue;
                    this.append(indent, ", ");
                }
                this.append(indent, ")");
                if (i + 1 >= rows.size()) continue;
                this.append(indent, ", ");
            }
            return null;
        }

        @Override
        protected Void visitSelect(Select node, Integer indent) {
            this.append(indent, "SELECT");
            if (node.isDistinct()) {
                this.builder.append(" DISTINCT");
            }
            if (node.getSelectItems().size() > 1) {
                boolean first = true;
                for (SelectItem item : node.getSelectItems()) {
                    this.builder.append(this.newLine).append(Formatter.indentString(indent));
                    this.builder.append(first ? " " : ", ");
                    item.accept(this, indent);
                    first = false;
                }
            } else {
                this.builder.append(' ');
                ((SelectItem)Lists.getOnlyElement(node.getSelectItems())).accept(this, indent);
            }
            return null;
        }

        @Override
        protected Void visitSingleColumn(SingleColumn node, Integer indent) {
            this.builder.append(ExpressionFormatter.formatStandaloneExpression(node.getExpression(), this.parameters));
            if (node.getAlias() != null) {
                this.builder.append(' ').append(Formatter.quoteIdentifierIfNeeded(node.getAlias()));
            }
            return null;
        }

        @Override
        protected Void visitAllColumns(AllColumns node, Integer indent) {
            this.builder.append(node.toString());
            return null;
        }

        @Override
        public Void visitTableFunction(TableFunction node, Integer context) {
            this.builder.append(node.name());
            this.builder.append("(");
            Iterator<Expression> iterator = node.functionCall().getArguments().iterator();
            while (iterator.hasNext()) {
                Expression expression = iterator.next();
                expression.accept(this, context);
                if (!iterator.hasNext()) continue;
                this.builder.append(", ");
            }
            this.builder.append(")");
            return null;
        }

        @Override
        protected Void visitTable(Table<?> node, Integer indent) {
            if (node.excludePartitions()) {
                this.builder.append("ONLY ");
            }
            this.builder.append(Formatter.formatQualifiedName(node.getName()));
            if (!node.partitionProperties().isEmpty()) {
                this.builder.append(" PARTITION (");
                for (Assignment<?> assignment : node.partitionProperties()) {
                    this.builder.append(assignment.columnName().toString());
                    this.builder.append("=");
                    this.builder.append(assignment.expression().toString());
                }
                this.builder.append(")");
            }
            return null;
        }

        @Override
        public Void visitCreateTable(CreateTable node, Integer indent) {
            Optional partitionedBy;
            this.builder.append("CREATE TABLE ");
            if (node.ifNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            node.name().accept(this, indent);
            this.builder.append(" ");
            this.appendNestedNodeList(node.tableElements(), indent);
            Optional clusteredBy = node.clusteredBy();
            if (clusteredBy.isPresent()) {
                this.appendNewLineOrSpace();
                clusteredBy.get().accept(this, indent);
            }
            if ((partitionedBy = node.partitionedBy()).isPresent()) {
                this.appendNewLineOrSpace();
                partitionedBy.get().accept(this, indent);
            }
            if (!node.properties().isEmpty()) {
                this.appendNewLineOrSpace();
                node.properties().accept(this, indent);
            }
            return null;
        }

        @Override
        public Void visitCreateTableAs(CreateTableAs<?> node, Integer indent) {
            this.builder.append("CREATE TABLE ");
            if (node.ifNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            node.name().accept(this, indent);
            this.builder.append(" AS ");
            node.query().accept(this, indent);
            return null;
        }

        @Override
        public Void visitCreateForeignTable(CreateForeignTable createTable, Integer indent) {
            this.builder.append("CREATE FOREIGN TABLE ");
            if (createTable.ifNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append(Formatter.formatQualifiedName(createTable.name()));
            this.builder.append(" ");
            this.appendNestedNodeList(createTable.tableElements(), indent);
            this.builder.append(" SERVER ").append(createTable.server());
            Map<String, Expression> options = createTable.options();
            if (!options.isEmpty()) {
                this.builder.append(" OPTIONS (");
                Iterator<Map.Entry<String, Expression>> it = options.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Expression> entry = it.next();
                    String optionName = entry.getKey();
                    Expression value = entry.getValue();
                    this.builder.append(optionName);
                    this.builder.append(" ");
                    value.accept(this, indent);
                    if (!it.hasNext()) continue;
                    this.builder.append(", ");
                }
                this.builder.append(")");
            }
            return null;
        }

        @Override
        public Void visitDropForeignTable(DropForeignTable dropForeignTable, Integer indent) {
            this.append(indent, "DROP FOREIGN TABLE ");
            if (dropForeignTable.ifExists()) {
                this.append(indent, "IF EXISTS ");
            }
            Iterator<QualifiedName> namesIt = dropForeignTable.names().iterator();
            while (namesIt.hasNext()) {
                this.append(indent, Formatter.formatQualifiedName(namesIt.next()));
                if (!namesIt.hasNext()) continue;
                this.append(indent, ", ");
            }
            this.append(indent, " ");
            this.append(indent, dropForeignTable.cascadeMode() == CascadeMode.CASCADE ? "CASCADE" : "RESTRICT");
            return null;
        }

        @Override
        public Void visitCreateUserMapping(CreateUserMapping createUserMapping, Integer indent) {
            this.builder.append("CREATE USER MAPPING ");
            if (createUserMapping.ifNotExists()) {
                this.builder.append("IF NOT EXISTS ");
            }
            this.builder.append("FOR ");
            String userName = createUserMapping.userName();
            this.builder.append(userName == null ? "CURRENT_USER" : userName);
            this.builder.append(" SERVER ");
            this.builder.append(createUserMapping.server());
            Map<String, Expression> options = createUserMapping.options();
            if (!options.isEmpty()) {
                this.builder.append(" OPTIONS (");
                Iterator<Map.Entry<String, Expression>> it = options.entrySet().iterator();
                while (it.hasNext()) {
                    Map.Entry<String, Expression> entry = it.next();
                    String optionName = entry.getKey();
                    Expression value = entry.getValue();
                    this.builder.append(optionName);
                    this.builder.append(" ");
                    value.accept(this, indent);
                    if (!it.hasNext()) continue;
                    this.builder.append(", ");
                }
                this.builder.append(")");
            }
            return null;
        }

        @Override
        public Void visitDropUserMapping(DropUserMapping dropUserMapping, Integer indent) {
            this.append(indent, "DROP USER MAPPING ");
            if (dropUserMapping.ifExists()) {
                this.append(indent, "IF EXISTS ");
            }
            this.builder.append("FOR ");
            String userName = dropUserMapping.userName();
            this.builder.append(userName == null ? "CURRENT_USER" : userName);
            this.builder.append(" SERVER ");
            this.builder.append(dropUserMapping.server());
            return null;
        }

        @Override
        public Void visitCreateFunction(CreateFunction<?> node, Integer indent) {
            this.builder.append("CREATE");
            if (node.replace()) {
                this.builder.append(" OR REPLACE");
            }
            this.builder.append(" FUNCTION ").append(node.name());
            this.appendFlatNodeList(node.arguments(), indent);
            this.builder.append(" RETURNS ").append(node.returnType()).append(" ").append(" LANGUAGE ").append(node.language().toString().replace("'", "")).append(" ").append(" AS ").append(node.definition().toString());
            return null;
        }

        @Override
        public Void visitCreateRole(CreateRole node, Integer indent) {
            this.builder.append("CREATE ").append(node.isUser() ? "USER " : "ROLE ");
            this.builder.append(Formatter.quoteIdentifierIfNeeded(node.name())).append(" ");
            if (node.properties() != null && !node.properties().isEmpty()) {
                this.builder.append(this.newLine);
                node.properties().accept(this, indent);
            }
            return null;
        }

        @Override
        public Void visitGrantPrivilege(GrantPrivilege node, Integer indent) {
            this.builder.append("GRANT ");
            this.appendPrivilegeStatement(node);
            return null;
        }

        @Override
        public Void visitDenyPrivilege(DenyPrivilege node, Integer context) {
            this.builder.append("DENY ");
            this.appendPrivilegeStatement(node);
            return null;
        }

        @Override
        public Void visitRevokePrivilege(RevokePrivilege node, Integer indent) {
            this.builder.append("REVOKE ");
            this.appendPrivilegeStatement(node);
            return null;
        }

        @Override
        public Void visitAlterRoleSet(AlterRoleSet<?> node, Integer indent) {
            this.builder.append("ALTER ROLE ");
            this.builder.append(Formatter.quoteIdentifierIfNeeded(node.name()));
            if (!node.properties().isEmpty()) {
                this.builder.append("SET (");
                this.appendProperties(node.properties(), 0);
                this.builder.append(")");
            }
            return null;
        }

        @Override
        public Void visitAlterRoleReset(AlterRoleReset node, Integer indent) {
            this.builder.append("ALTER ROLE ");
            this.builder.append(Formatter.quoteIdentifierIfNeeded(node.name()));
            this.builder.append("RESET ");
            String property = node.property();
            if (property == null) {
                this.builder.append("ALL");
            } else if (property.contains(".")) {
                this.builder.append(String.format(Locale.ENGLISH, "\"%s\"", property));
            } else {
                this.builder.append(property);
            }
            return null;
        }

        @Override
        public Void visitDropRole(DropRole node, Integer indent) {
            this.builder.append("DROP ROLE ");
            if (node.ifExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(Formatter.quoteIdentifierIfNeeded(node.name()));
            return null;
        }

        @Override
        public Void visitFunctionArgument(FunctionArgument node, Integer context) {
            String name = node.name();
            if (name != null) {
                this.builder.append(name).append(" ");
            }
            this.builder.append(node.type());
            return null;
        }

        @Override
        public Void visitClusteredBy(ClusteredBy<?> node, Integer indent) {
            this.append(indent, "CLUSTERED");
            if (node.column().isPresent()) {
                this.builder.append(String.format(Locale.ENGLISH, " BY (%s)", node.column().get().toString()));
            }
            if (node.numberOfShards().isPresent()) {
                this.builder.append(String.format(Locale.ENGLISH, " INTO %s SHARDS", node.numberOfShards().get()));
            }
            return null;
        }

        @Override
        public Void visitGenericProperties(GenericProperties<?> node, Integer indent) {
            if (!node.isEmpty()) {
                this.builder.append("WITH (");
                this.builder.append(this.newLine);
                this.appendProperties(node, indent);
                this.append(indent, ")");
            }
            return null;
        }

        @Override
        protected Void visitLongLiteral(LongLiteral node, Integer indent) {
            this.builder.append(node.getValue());
            return null;
        }

        @Override
        protected Void visitIntegerLiteral(IntegerLiteral node, Integer indent) {
            this.builder.append(node.getValue());
            return null;
        }

        @Override
        protected Void visitStringLiteral(StringLiteral node, Integer indent) {
            this.builder.append(Literals.quoteStringLiteral(node.getValue()));
            return null;
        }

        @Override
        protected Void visitEscapedCharStringLiteral(EscapedCharStringLiteral node, Integer context) {
            this.builder.append(Literals.quoteEscapedStringLiteral(node.getRawValue()));
            return null;
        }

        @Override
        public Void visitColumnDefinition(ColumnDefinition<?> node, Integer indent) {
            ColumnDefinition<?> columnDefinition = node;
            this.builder.append(Formatter.quoteIdentifierIfNeeded(columnDefinition.ident())).append(" ");
            ColumnType<?> type = columnDefinition.type();
            if (type != null) {
                type.accept(this, indent);
            }
            if (!columnDefinition.constraints().isEmpty()) {
                for (ColumnConstraint<?> constraint : columnDefinition.constraints()) {
                    this.builder.append(" ");
                    constraint.accept(this, indent);
                }
            }
            return null;
        }

        @Override
        public Void visitColumnType(ColumnType<?> node, Integer indent) {
            this.builder.append(node.name().toUpperCase(Locale.ENGLISH));
            if (node.parametrized()) {
                this.builder.append("(").append(node.parameters().stream().map(String::valueOf).collect(Collectors.joining(", "))).append(')');
            }
            return null;
        }

        @Override
        public Void visitObjectColumnType(ObjectColumnType<?> node, Integer indent) {
            this.builder.append("OBJECT");
            if (node.columnPolicy().isPresent()) {
                this.builder.append('(');
                this.builder.append(node.columnPolicy().get().name());
                this.builder.append(')');
            }
            if (!node.nestedColumns().isEmpty()) {
                this.builder.append(" AS ");
                this.appendNestedNodeList(node.nestedColumns(), indent);
            }
            return null;
        }

        @Override
        public Void visitCollectionColumnType(CollectionColumnType<?> node, Integer indent) {
            this.builder.append(node.name().toUpperCase(Locale.ENGLISH)).append("(");
            node.innerType().accept(this, indent);
            this.builder.append(")");
            return null;
        }

        @Override
        public Void visitIndexColumnConstraint(IndexColumnConstraint<?> node, Integer indent) {
            this.builder.append("INDEX ");
            if (node.equals(IndexColumnConstraint.off())) {
                this.builder.append(node.indexMethod().toUpperCase(Locale.ENGLISH));
            } else {
                this.builder.append("USING ").append(node.indexMethod().toUpperCase(Locale.ENGLISH));
                if (!node.properties().isEmpty()) {
                    this.builder.append(" ");
                    node.properties().accept(this, indent);
                }
            }
            return null;
        }

        @Override
        public Void visitColumnStorageDefinition(ColumnStorageDefinition<?> node, Integer indent) {
            this.builder.append("STORAGE ");
            if (!node.properties().isEmpty()) {
                node.properties().accept(this, indent);
            }
            return null;
        }

        @Override
        public Void visitPrimaryKeyColumnConstraint(PrimaryKeyColumnConstraint<?> node, Integer indent) {
            this.visitConstraintName(node.constraintName());
            this.builder.append("PRIMARY KEY");
            return null;
        }

        @Override
        public Void visitNotNullColumnConstraint(NotNullColumnConstraint<?> node, Integer indent) {
            this.builder.append("NOT NULL");
            return null;
        }

        @Override
        public Void visitNullColumnConstraint(NullColumnConstraint node, Integer indent) {
            this.builder.append("NULL");
            return null;
        }

        @Override
        public Void visitPrimaryKeyConstraint(PrimaryKeyConstraint node, Integer indent) {
            this.visitConstraintName(node.constraintName());
            this.builder.append("PRIMARY KEY ");
            this.appendFlatNodeList(node.columns(), indent);
            return null;
        }

        private void visitCheckConstraint(@Nullable String constraintName, String expressionStr) {
            this.visitConstraintName(constraintName);
            this.builder.append("CHECK(").append(expressionStr).append(")");
        }

        private void visitConstraintName(@Nullable String constraintName) {
            if (constraintName != null) {
                this.builder.append("CONSTRAINT ").append(constraintName).append(" ");
            }
        }

        @Override
        public Void visitCheckConstraint(CheckConstraint<?> node, Integer indent) {
            this.visitCheckConstraint(node.name(), node.expressionStr());
            return null;
        }

        @Override
        public Void visitCheckColumnConstraint(CheckColumnConstraint<?> node, Integer indent) {
            this.visitCheckConstraint(node.name(), node.expressionStr());
            return null;
        }

        @Override
        public Void visitDefaultConstraint(DefaultConstraint<?> node, Integer context) {
            this.visitConstraintName(node.name());
            this.builder.append("DEFAULT ").append(ExpressionFormatter.formatStandaloneExpression((Expression)node.expression(), this.parameters));
            return null;
        }

        @Override
        public Void visitGeneratedExpressionConstraint(GeneratedExpressionConstraint<?> node, Integer context) {
            this.visitConstraintName(node.name());
            this.builder.append("GENERATED ALWAYS AS ").append(ExpressionFormatter.formatStandaloneExpression((Expression)node.expression(), this.parameters));
            return null;
        }

        @Override
        public Void visitIndexDefinition(IndexDefinition node, Integer indent) {
            this.builder.append("INDEX ").append(Formatter.quoteIdentifierIfNeeded(node.ident())).append(" USING ").append(node.method().toUpperCase(Locale.ENGLISH)).append(" ");
            this.appendFlatNodeList(node.columns(), indent);
            if (!node.properties().isEmpty()) {
                this.builder.append(" ");
                node.properties().accept(this, indent);
            }
            return null;
        }

        @Override
        public Void visitPartitionedBy(PartitionedBy node, Integer indent) {
            this.append(indent, "PARTITIONED BY ");
            this.appendFlatNodeList(node.columns(), indent);
            return null;
        }

        @Override
        protected Void visitUnion(Union node, Integer context) {
            node.getLeft().accept(this, context);
            this.append(context, " ");
            this.builder.append("UNION");
            if (!node.isDistinct()) {
                this.append(context, " ");
                this.builder.append("ALL");
            }
            this.append(context, " ");
            node.getRight().accept(this, context);
            return null;
        }

        @Override
        protected Void visitJoin(Join node, Integer indent) {
            JoinCriteria criteria = node.getCriteria().orElse(null);
            Object type = node.getType().toString();
            if (criteria instanceof NaturalJoin) {
                type = "NATURAL " + (String)type;
            }
            this.builder.append('(');
            node.getLeft().accept(this, indent);
            this.builder.append(this.newLine);
            this.append(indent, (String)type).append(" JOIN ");
            node.getRight().accept(this, indent);
            if (criteria instanceof JoinUsing) {
                JoinUsing joinUsing = (JoinUsing)criteria;
                this.builder.append(" USING (").append(String.join((CharSequence)", ", joinUsing.getColumns())).append(")");
            } else if (criteria instanceof JoinOn) {
                JoinOn joinOn = (JoinOn)criteria;
                this.builder.append(" ON (").append(ExpressionFormatter.formatStandaloneExpression(joinOn.getExpression(), this.parameters)).append(")");
            } else if (node.getType() != JoinType.CROSS && !(criteria instanceof NaturalJoin)) {
                throw new UnsupportedOperationException("unknown join criteria: " + String.valueOf(criteria));
            }
            this.builder.append(")");
            return null;
        }

        @Override
        protected Void visitAliasedRelation(AliasedRelation node, Integer indent) {
            node.getRelation().accept(this, indent);
            this.builder.append(' ').append(node.getAlias());
            Formatter.appendAliasColumns(this.builder, node.getColumnNames());
            return null;
        }

        @Override
        protected Void visitTableSubquery(TableSubquery node, Integer indent) {
            this.builder.append('(').append(this.newLine);
            node.getQuery().accept(this, indent + this.indentBy);
            this.append(indent, ")");
            return null;
        }

        @Override
        public Void visitDropRepository(DropRepository node, Integer indent) {
            this.builder.append("DROP REPOSITORY ").append(Formatter.quoteIdentifierIfNeeded(node.name()));
            return null;
        }

        @Override
        public Void visitCreateSnapshot(CreateSnapshot<?> node, Integer indent) {
            this.builder.append("CREATE SNAPSHOT ").append(Formatter.formatQualifiedName(node.name()));
            if (!node.tables().isEmpty()) {
                this.builder.append(" TABLE ");
                int count = 0;
                int max = node.tables().size();
                for (Table<?> table : node.tables()) {
                    table.accept(this, indent);
                    if (++count >= max) continue;
                    this.builder.append(",");
                }
            } else {
                this.builder.append(" ALL");
            }
            if (!node.properties().isEmpty()) {
                this.builder.append(' ');
                node.properties().accept(this, indent);
            }
            return null;
        }

        @Override
        public Void visitDropTable(DropTable<?> node, Integer indent) {
            this.builder.append("DROP TABLE ");
            if (node.dropIfExists()) {
                this.builder.append("IF EXISTS ");
            }
            node.table().accept(this, indent);
            return null;
        }

        @Override
        public Void visitDropBlobTable(DropBlobTable<?> node, Integer indent) {
            this.builder.append("DROP BLOB TABLE ");
            if (node.ignoreNonExistentTable()) {
                this.builder.append("IF EXISTS ");
            }
            node.table().accept(this, indent);
            return null;
        }

        @Override
        public Void visitDropView(DropView node, Integer indent) {
            this.builder.append("DROP VIEW ");
            if (node.ifExists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(node.names().stream().map(Formatter::formatQualifiedName).collect(COMMA_JOINER));
            return null;
        }

        @Override
        public Void visitIntervalLiteral(IntervalLiteral node, Integer indent) {
            this.builder.append(IntervalLiteral.format(node));
            return null;
        }

        @Override
        public Void visitDropAnalyzer(DropAnalyzer node, Integer indent) {
            this.builder.append("DROP ANALYZER ").append(Formatter.quoteIdentifierIfNeeded(node.name()));
            return null;
        }

        @Override
        public Void visitDropFunction(DropFunction node, Integer indent) {
            this.builder.append("DROP FUNCTION ");
            if (node.exists()) {
                this.builder.append("IF EXISTS ");
            }
            this.builder.append(Formatter.formatQualifiedName(node.name()));
            this.appendFlatNodeList(node.arguments(), indent);
            return null;
        }

        @Override
        public Void visitDropSnapshot(DropSnapshot node, Integer indent) {
            this.builder.append("DROP REPOSITORY ").append(Formatter.formatQualifiedName(node.name()));
            return null;
        }

        @Override
        public Void visitCreatePublication(CreatePublication createPublication, Integer context) {
            this.builder.append("CREATE PUBLICATION ").append(Formatter.quoteIdentifierIfNeeded(createPublication.name()));
            if (createPublication.isForAllTables()) {
                this.builder.append(" FOR ALL TABLES");
            } else if (!createPublication.tables().isEmpty()) {
                this.builder.append(" FOR TABLE ");
                this.builder.append(createPublication.tables().stream().map(Formatter::formatQualifiedName).collect(COMMA_JOINER));
            }
            return null;
        }

        @Override
        public Void visitDropPublication(DropPublication dropPublication, Integer context) {
            this.builder.append("DROP PUBLICATION ");
            if (dropPublication.ifExists()) {
                this.builder.append(" IF EXISTS ");
            }
            this.builder.append(Formatter.quoteIdentifierIfNeeded(dropPublication.name()));
            return null;
        }

        @Override
        public Void visitAlterPublication(AlterPublication alterPublication, Integer context) {
            this.builder.append("ALTER PUBLICATION ").append(Formatter.quoteIdentifierIfNeeded(alterPublication.name()));
            this.builder.append(" ").append((Object)alterPublication.operation()).append(" ");
            this.builder.append("TABLE ");
            this.builder.append(alterPublication.tables().stream().map(Formatter::formatQualifiedName).collect(COMMA_JOINER));
            return null;
        }

        @Override
        public Void visitCreateSubscription(CreateSubscription<?> createSubscription, Integer context) {
            CreateSubscription<?> subscription = createSubscription;
            this.builder.append("CREATE SUBSCRIPTION ").append(Formatter.quoteIdentifierIfNeeded(subscription.name())).append(" CONNECTION ");
            ((Expression)subscription.connectionInfo()).accept(this, context);
            this.builder.append(" PUBLICATION ");
            this.builder.append(subscription.publications().stream().map(Formatter::quoteIdentifierIfNeeded).collect(COMMA_JOINER));
            if (!subscription.properties().isEmpty()) {
                this.builder.append(" ");
                subscription.properties().accept(this, context);
            }
            return null;
        }

        @Override
        public Void visitDropSubscription(DropSubscription dropSubscription, Integer context) {
            this.builder.append("DROP SUBSCRIPTION ");
            if (dropSubscription.ifExists()) {
                this.builder.append(" IF EXISTS ");
            }
            this.builder.append(Formatter.quoteIdentifierIfNeeded(dropSubscription.name()));
            return null;
        }

        @Override
        public Void visitAlterSubscription(AlterSubscription alterSubscription, Integer context) {
            this.builder.append("ALTER SUBSCRIPTION ").append(Formatter.quoteIdentifierIfNeeded(alterSubscription.name())).append(" ").append((Object)alterSubscription.mode());
            return null;
        }

        @Override
        public Void visitWith(With with, Integer context) {
            this.builder.append("WITH ");
            Iterator<WithQuery> queriesIt = with.withQueries().iterator();
            while (queriesIt.hasNext()) {
                queriesIt.next().accept(this, context);
                if (!queriesIt.hasNext()) continue;
                this.builder.append(",");
            }
            this.builder.append(this.newLine);
            return null;
        }

        @Override
        public Void visitWithQuery(WithQuery withQuery, Integer context) {
            this.builder.append(withQuery.name());
            if (!withQuery.columnNames().isEmpty()) {
                this.builder.append("(").append(withQuery.columnNames().stream().collect(COMMA_JOINER)).append(")");
            }
            this.builder.append(" AS (");
            withQuery.query().accept(this, context);
            this.builder.append(")");
            return null;
        }

        @Override
        public Void visitWindow(Window window, Integer indent) {
            this.append(indent, "(");
            if (window.windowRef() != null) {
                this.append(indent, window.windowRef());
            }
            if (!window.getPartitions().isEmpty()) {
                this.append(indent, " PARTITION BY ");
                Iterator<Expression> partitions = window.getPartitions().iterator();
                while (partitions.hasNext()) {
                    partitions.next().accept(this, indent);
                    if (!partitions.hasNext()) continue;
                    this.append(indent, ", ");
                }
            }
            if (!window.getOrderBy().isEmpty()) {
                this.append(indent, " ORDER BY ");
                Iterator<SortItem> sortItems = window.getOrderBy().iterator();
                while (sortItems.hasNext()) {
                    sortItems.next().accept(this, indent);
                    if (!sortItems.hasNext()) continue;
                    this.append(indent, ", ");
                }
            }
            window.getWindowFrame().map(frame -> frame.accept(this, indent));
            this.append(indent, ")");
            return null;
        }

        @Override
        public Void visitWindowFrame(WindowFrame frame, Integer indent) {
            this.append(indent, " ");
            this.append(indent, frame.mode().name());
            this.append(indent, " ");
            Expression startOffset = frame.getStart().getValue();
            if (startOffset != null) {
                startOffset.accept(this, indent);
                this.append(indent, " ");
            }
            this.append(indent, frame.getStart().getType().name());
            frame.getEnd().map(end -> {
                this.append(indent, " AND ");
                Expression endOffset = end.getValue();
                if (endOffset != null) {
                    endOffset.accept(this, indent);
                    this.append(indent, " ");
                }
                this.append(indent, end.getType().name());
                return null;
            });
            return null;
        }

        @Override
        protected Void visitSortItem(SortItem node, Integer indent) {
            node.getSortKey().accept(this, indent);
            return null;
        }

        @Override
        public Void visitSetSessionAuthorizationStatement(SetSessionAuthorizationStatement node, Integer context) {
            String user = node.user();
            this.builder.append("SET ").append((Object)node.scope()).append(" SESSION AUTHORIZATION ").append(user != null ? Formatter.quoteIdentifierIfNeeded(user) : "DEFAULT");
            return null;
        }

        @Override
        public Void visitDeclare(Declare declare, Integer indent) {
            this.builder.append("DECLARE ").append(declare.cursorName()).append(" ");
            if (declare.binary()) {
                this.builder.append("BINARY ");
            }
            this.builder.append(declare.scroll() ? "SCROLL " : "NO SCROLL ");
            this.builder.append("CURSOR ");
            this.builder.append(declare.hold() == Declare.Hold.WITH ? "WITH HOLD " : "WITHOUT HOLD ");
            this.builder.append("FOR ");
            declare.query().accept(this, indent);
            return null;
        }

        @Override
        public Void visitFetch(Fetch fetch, Integer context) {
            this.builder.append("FETCH ");
            Fetch.ScrollMode scrollMode = fetch.scrollMode();
            long count = fetch.count();
            if (scrollMode == Fetch.ScrollMode.ABSOLUTE) {
                if (count == 1L) {
                    this.builder.append("FIRST ");
                } else if (fetch.count() == -1L) {
                    this.builder.append("LAST ");
                } else {
                    this.builder.append("ABSOLUTE ");
                    this.builder.append(fetch.count());
                    this.builder.append(" ");
                }
            } else if (scrollMode == Fetch.ScrollMode.RELATIVE) {
                this.builder.append("RELATIVE ");
                this.builder.append(fetch.count());
                this.builder.append(" ");
            } else if (scrollMode == Fetch.ScrollMode.MOVE) {
                if (count >= 0L) {
                    this.builder.append("FORWARD ");
                } else {
                    this.builder.append("BACKWARD ");
                }
                if (count == Long.MAX_VALUE || count == -9223372036854775807L) {
                    this.builder.append("ALL ");
                } else if (count > 1L || count < -1L) {
                    this.builder.append(Math.abs(count));
                    this.builder.append(" ");
                }
            }
            this.builder.append("FROM ");
            this.builder.append(fetch.cursorName());
            return null;
        }

        @Override
        public Void visitClose(Close close, Integer context) {
            this.builder.append("CLOSE ");
            String cursorName = close.cursorName();
            this.builder.append(cursorName == null ? "ALL" : cursorName);
            return null;
        }

        private void appendProperties(GenericProperties<?> properties, Integer indent) {
            int count = 0;
            Map<String, ?> sortedMap = properties.toMap(TreeMap::new);
            for (Map.Entry<String, ?> propertyEntry : sortedMap.entrySet()) {
                this.builder.append(Formatter.indentString(indent + this.indentBy));
                String key = propertyEntry.getKey();
                if (propertyEntry.getKey().contains(".")) {
                    key = String.format(Locale.ENGLISH, "\"%s\"", key);
                }
                this.builder.append(key).append(" = ");
                ((Expression)propertyEntry.getValue()).accept(this, indent);
                if (++count < properties.size()) {
                    this.builder.append(",");
                }
                this.builder.append(this.newLine);
            }
        }

        private void appendPrivilegesList(List<String> permissions) {
            int j = 0;
            for (String permission : permissions) {
                this.builder.append(permission);
                if (j < permissions.size() - 1) {
                    this.builder.append(", ");
                }
                ++j;
            }
        }

        private void appendUsersList(List<String> userNames) {
            for (int i = 0; i < userNames.size(); ++i) {
                this.builder.append(Formatter.quoteIdentifierIfNeeded(userNames.get(i)));
                if (i >= userNames.size() - 1) continue;
                this.builder.append(", ");
            }
        }

        private void appendTableOrSchemaNames(List<QualifiedName> tableOrSchemaNames) {
            for (int i = 0; i < tableOrSchemaNames.size(); ++i) {
                this.builder.append(Formatter.quoteIdentifierIfNeeded(tableOrSchemaNames.get(i).toString()));
                if (i >= tableOrSchemaNames.size() - 1) continue;
                this.builder.append(", ");
            }
        }

        private void appendPrivilegeStatement(PrivilegeStatement node) {
            if (node.privileges().isEmpty()) {
                this.builder.append(" ALL ");
            } else {
                this.appendPrivilegesList(node.privileges());
            }
            if (!node.securable().equals("CLUSTER")) {
                this.builder.append(" ON ").append(node.securable()).append(" ");
                this.appendTableOrSchemaNames(node.privilegeIdents());
            }
            if (node instanceof RevokePrivilege) {
                this.builder.append(" FROM ");
            } else {
                this.builder.append(" TO ");
            }
            this.appendUsersList(node.userNames());
        }

        private static String formatQualifiedName(QualifiedName name) {
            return name.getParts().stream().map(Formatter::quoteIdentifierIfNeeded).collect(Collectors.joining("."));
        }

        private static String quoteIdentifierIfNeeded(String identifier) {
            return Arrays.stream(identifier.split("\\.")).map(Identifiers::quote).collect(Collectors.joining("."));
        }

        private void appendFlatNodeList(List<? extends Node> nodes, Integer indent) {
            this.appendNestedNodeList(nodes, 0, "", 0);
        }

        private void appendNestedNodeList(List<? extends Node> nodes, Integer indent) {
            this.appendNestedNodeList(nodes, indent, this.newLine, this.indentBy);
        }

        private void appendNestedNodeList(List<? extends Node> nodes, Integer indent, String newLine, int indentBy) {
            int count = 0;
            int max = nodes.size();
            this.builder.append("(");
            this.builder.append(newLine);
            for (Node node : nodes) {
                this.builder.append(Formatter.indentString(indent + indentBy));
                node.accept(this, indent + indentBy);
                if (++count < max) {
                    this.builder.append(",");
                    if (newLine.isEmpty()) {
                        this.builder.append(" ");
                    }
                }
                this.builder.append(newLine);
            }
            this.append(indent, ")");
        }

        private StringBuilder append(int indent, String value) {
            this.builder.append(Formatter.indentString(indent));
            return this.builder.append(value);
        }

        private StringBuilder appendNewLineOrSpace() {
            if (this.newLine.isEmpty()) {
                this.builder.append(" ");
            } else {
                this.builder.append(this.newLine);
            }
            return this.builder;
        }

        private static String indentString(int indent) {
            return String.join((CharSequence)"", Collections.nCopies(indent, SqlFormatter.INDENT));
        }

        private static void appendAliasColumns(StringBuilder builder, List<String> columns) {
            if (!columns.isEmpty()) {
                builder.append(" (").append(String.join((CharSequence)", ", columns)).append(')');
            }
        }
    }
}

