/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Relation;
import java.util.List;
import java.util.Objects;

public class AliasedRelation
extends Relation {
    private final Relation relation;
    private final String alias;
    private final List<String> columnNames;

    public AliasedRelation(Relation relation, String alias, List<String> columnNames) {
        this.relation = Objects.requireNonNull(relation, "relation is null");
        this.alias = Objects.requireNonNull(alias, "alias is null");
        this.columnNames = columnNames;
    }

    public Relation getRelation() {
        return this.relation;
    }

    public String getAlias() {
        return this.alias;
    }

    public List<String> getColumnNames() {
        return this.columnNames;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAliasedRelation(this, context);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AliasedRelation that = (AliasedRelation)o;
        return Objects.equals(this.relation, that.relation) && Objects.equals(this.alias, that.alias) && Objects.equals(this.columnNames, that.columnNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.relation, this.alias, this.columnNames);
    }

    @Override
    public String toString() {
        return "AliasedRelation{relation=" + String.valueOf(this.relation) + ", alias='" + this.alias + "', columnNames=" + String.valueOf(this.columnNames) + "}";
    }
}

