/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.GenericProperties;
import io.crate.sql.tree.Statement;
import io.crate.sql.tree.Table;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;

public class AlterTable<T>
extends Statement {
    private final Table<T> table;
    private final GenericProperties<T> genericProperties;
    private final List<String> resetProperties;

    public AlterTable(Table<T> table, GenericProperties<T> genericProperties) {
        this.table = table;
        this.genericProperties = genericProperties;
        this.resetProperties = List.of();
    }

    public AlterTable(Table<T> table, List<String> resetProperties) {
        this.table = table;
        this.resetProperties = resetProperties;
        this.genericProperties = GenericProperties.empty();
    }

    private AlterTable(Table<T> table, GenericProperties<T> genericProperties, List<String> resetProperties) {
        this.table = table;
        this.genericProperties = genericProperties;
        this.resetProperties = resetProperties;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitAlterTable(this, context);
    }

    public Table<T> table() {
        return this.table;
    }

    public GenericProperties<T> genericProperties() {
        return this.genericProperties;
    }

    public List<String> resetProperties() {
        return this.resetProperties;
    }

    public <U> AlterTable<U> map(Function<? super T, ? extends U> mapper) {
        return new AlterTable<U>(this.table.map(mapper), this.genericProperties.map(mapper), this.resetProperties);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AlterTable that = (AlterTable)o;
        return Objects.equals(this.table, that.table) && Objects.equals(this.genericProperties, that.genericProperties) && Objects.equals(this.resetProperties, that.resetProperties);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.table, this.genericProperties, this.resetProperties);
    }

    @Override
    public String toString() {
        return "AlterTable{table=" + String.valueOf(this.table) + ", genericProperties=" + String.valueOf(this.genericProperties) + ", resetProperties=" + String.valueOf(this.resetProperties) + "}";
    }
}

