/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Literal;
import java.util.BitSet;

public class BitString
extends Literal
implements Comparable<BitString> {
    private final BitSet bitSet;
    private final int length;

    public static BitString ofBitString(String bitString) {
        assert (bitString.startsWith("B'")) : "Bitstring must start with B'";
        assert (bitString.endsWith("'")) : "Bitstrign must end with '";
        return BitString.ofRawBits(bitString.substring(2, bitString.length() - 1));
    }

    public static BitString ofRawBits(String bits) {
        return BitString.ofRawBits(bits, bits.length());
    }

    public static BitString ofRawBits(String bits, int length) {
        BitSet bitSet = BitString.toBitSet(bits, length);
        return new BitString(bitSet, length);
    }

    private static BitSet toBitSet(String text, int length) {
        BitSet bitSet = new BitSet(length);
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            boolean value = switch (c) {
                case '0' -> false;
                case '1' -> true;
                default -> throw new IllegalArgumentException("Bit string must only contain `0` or `1` values. Encountered: " + c);
            };
            bitSet.set(i, value);
        }
        return bitSet;
    }

    public BitString(BitSet bitSet, int length) {
        this.bitSet = bitSet;
        this.length = length;
    }

    public BitSet bitSet() {
        return this.bitSet;
    }

    public int length() {
        return this.length;
    }

    public String asPrefixedBitString() {
        StringBuilder sb = new StringBuilder("B'");
        for (int i = 0; i < this.length; ++i) {
            sb.append(this.bitSet.get(i) ? (char)'1' : '0');
        }
        sb.append("'");
        return sb.toString();
    }

    public String asRawBitString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.length; ++i) {
            sb.append(this.bitSet.get(i) ? (char)'1' : '0');
        }
        return sb.toString();
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitBitString(this, context);
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.bitSet.hashCode();
        result = 31 * result + this.length;
        return result;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BitString other = (BitString)obj;
        return this.bitSet.equals(other.bitSet) && this.length == other.length;
    }

    @Override
    public int compareTo(BitString o) {
        int smallerLength = Math.min(this.length, o.length);
        for (int i = 0; i < smallerLength; ++i) {
            boolean otherSet;
            boolean thisSet = this.bitSet.get(i);
            int compare = Boolean.compare(thisSet, otherSet = o.bitSet.get(i));
            if (compare == 0) continue;
            return compare;
        }
        return Integer.compare(this.length, o.length);
    }
}

