/*
 * Decompiled with CFR 0.152.
 */
package io.crate.sql.tree;

import io.crate.sql.tree.AnalyzerElement;
import io.crate.sql.tree.AstVisitor;
import io.crate.sql.tree.Statement;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.Nullable;

public class CreateAnalyzer<T>
extends Statement {
    private final String ident;
    @Nullable
    private final String extendedAnalyzer;
    private final List<AnalyzerElement<T>> elements;

    public CreateAnalyzer(String ident, @Nullable String extendedAnalyzer, List<AnalyzerElement<T>> elements) {
        this.ident = ident;
        this.extendedAnalyzer = extendedAnalyzer;
        this.elements = elements;
    }

    public String ident() {
        return this.ident;
    }

    @Nullable
    public String extendedAnalyzer() {
        return this.extendedAnalyzer;
    }

    public boolean isExtending() {
        return this.extendedAnalyzer != null;
    }

    public List<AnalyzerElement<T>> elements() {
        return this.elements;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateAnalyzer that = (CreateAnalyzer)o;
        return Objects.equals(this.ident, that.ident) && Objects.equals(this.extendedAnalyzer, that.extendedAnalyzer) && Objects.equals(this.elements, that.elements);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.ident, this.extendedAnalyzer, this.elements);
    }

    @Override
    public String toString() {
        return "CreateAnalyzer{ident='" + this.ident + "', extends='" + this.extendedAnalyzer + "', elements=" + String.valueOf(this.elements) + "}";
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitCreateAnalyzer(this, context);
    }
}

